/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;

public class FloatingIslandConfig
implements class_3037 {
    public static final Codec<FloatingIslandConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("top_block_provider").forGetter(config -> config.topBlockProvider), (App)class_4651.field_24937.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)Codec.INT.fieldOf("min_radius").orElse((Object)13).forGetter(config -> config.minRadius), (App)Codec.INT.fieldOf("max_radius").orElse((Object)15).forGetter(config -> config.maxRadius)).apply((Applicative)codecRecorder, FloatingIslandConfig::new));
    private final class_4651 topBlockProvider;
    private final class_4651 blockProvider;
    private final int minRadius;
    private final int maxRadius;

    FloatingIslandConfig(class_4651 topBlockProvider, class_4651 blockProvider, int minRadius, int maxRadius) {
        this.topBlockProvider = topBlockProvider;
        this.blockProvider = blockProvider;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    public class_4651 getBlockProvider() {
        return this.blockProvider;
    }

    public class_4651 getTopBlockProvider() {
        return this.topBlockProvider;
    }

    public int getMinRadius() {
        return Math.abs(this.minRadius);
    }

    public int getMaxRadius() {
        return Math.abs(this.maxRadius);
    }

    public int getMaxPossibleRadius() {
        int returnValue = this.maxRadius - this.minRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public static class Builder {
        private class_4651 topBlockProvider = new class_4656(class_2246.field_10219.method_9564());
        private class_4651 blockProvider = new class_4656(class_2246.field_10340.method_9564());
        private int minRadius = 1;
        private int maxRadius = 3;

        public Builder setTopBlock(class_2248 block) {
            this.topBlockProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setTopBlock(class_2680 state) {
            this.topBlockProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setTopBlock(class_4651 provider) {
            this.topBlockProvider = provider != null ? provider : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_2248 block) {
            this.blockProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_2680 state) {
            this.blockProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_4651 provider) {
            this.blockProvider = provider != null ? provider : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setMinRadius(int minRadius) {
            this.minRadius = minRadius <= 0 ? 1 : minRadius;
            return this;
        }

        public Builder setMaxRadius(int maxRadius) {
            this.maxRadius = maxRadius <= 0 ? this.minRadius + 1 : maxRadius;
            return this;
        }

        public Builder copy(FloatingIslandConfig config) {
            this.topBlockProvider = config.topBlockProvider;
            this.blockProvider = config.blockProvider;
            this.minRadius = config.minRadius;
            this.maxRadius = config.maxRadius;
            return this;
        }

        public FloatingIslandConfig build() {
            return new FloatingIslandConfig(this.topBlockProvider, this.blockProvider, this.minRadius, this.maxRadius);
        }
    }
}

