/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;

public class NoisyCaveSphereConfig
implements class_3037 {
    public static final Codec<NoisyCaveSphereConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)class_4651.field_24937.fieldOf("top_block_provider").forGetter(config -> config.topBlockProvider), (App)Codec.INT.fieldOf("min_stack_height").orElse((Object)15).forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_stack_height").orElse((Object)15).forGetter(config -> config.maxHeight), (App)Codec.INT.fieldOf("min_x_radius").orElse((Object)11).forGetter(config -> config.minXRadius), (App)Codec.INT.fieldOf("max_x_radius").orElse((Object)15).forGetter(config -> config.maxXRadius), (App)Codec.INT.fieldOf("min_y_radius").orElse((Object)15).forGetter(config -> config.minYRadius), (App)Codec.INT.fieldOf("max_y_radius").orElse((Object)15).forGetter(config -> config.maxYRadius), (App)Codec.INT.fieldOf("min_z_radius").orElse((Object)15).forGetter(config -> config.minZRadius), (App)Codec.INT.fieldOf("max_z_radius").orElse((Object)15).forGetter(config -> config.maxZRadius), (App)Codec.DOUBLE.fieldOf("radius_divisor_per_stack").orElse((Object)1.0).forGetter(config -> config.radiusDivisorPerStack), (App)Codec.DOUBLE.fieldOf("noise_frequency").orElse((Object)1.0).forGetter(config -> config.radiusDivisorPerStack)).apply((Applicative)codecRecorder, NoisyCaveSphereConfig::new));
    private final class_4651 blockProvider;
    private final class_4651 topBlockProvider;
    private final int minHeight;
    private final int maxHeight;
    private final int minXRadius;
    private final int maxXRadius;
    private final int minYRadius;
    private final int maxYRadius;
    private final int minZRadius;
    private final int maxZRadius;
    private final double radiusDivisorPerStack;
    private final double noiseFrequency;

    NoisyCaveSphereConfig(class_4651 blockProvider, class_4651 topBlockProvider, int minHeight, int maxHeight, int minXRadius, int maxXRadius, int minYRadius, int maxYRadius, int minZRadius, int maxZRadius, double radiusDivisorPerStack, double noiseFrequency) {
        this.blockProvider = blockProvider;
        this.topBlockProvider = topBlockProvider;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.minXRadius = minXRadius;
        this.maxXRadius = maxXRadius;
        this.minYRadius = minYRadius;
        this.maxYRadius = maxYRadius;
        this.minZRadius = minZRadius;
        this.maxZRadius = maxZRadius;
        this.radiusDivisorPerStack = radiusDivisorPerStack;
        this.noiseFrequency = noiseFrequency;
    }

    public class_4651 getBlockProvider() {
        return this.blockProvider;
    }

    public class_4651 getTopBlockProvider() {
        return this.topBlockProvider;
    }

    public int getMinHeight() {
        return Math.abs(this.minHeight);
    }

    public int getMaxHeight() {
        return Math.abs(this.maxHeight);
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue + 1;
    }

    public int getMinXRadius() {
        return Math.abs(this.minXRadius);
    }

    public int getMaxXRadius() {
        return Math.abs(this.maxXRadius);
    }

    public int getMinYRadius() {
        return this.minYRadius;
    }

    public int getMaxYRadius() {
        return this.maxYRadius;
    }

    public int getMinZRadius() {
        return this.minZRadius;
    }

    public int getMaxZRadius() {
        return this.maxZRadius;
    }

    public int getMaxPossibleXRadius() {
        int returnValue = this.maxXRadius - this.minXRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public int getMaxPossibleYRadius() {
        int returnValue = this.maxYRadius - this.minYRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public int getMaxPossibleZRadius() {
        int returnValue = this.maxZRadius - this.minZRadius;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return Math.abs(returnValue);
    }

    public int getRandomXRadius(Random rand) {
        return rand.nextInt(this.maxXRadius) + this.minXRadius;
    }

    public int getRandomYRadius(Random rand) {
        return rand.nextInt(this.maxYRadius) + this.minYRadius;
    }

    public int getRandomZRadius(Random rand) {
        return rand.nextInt(this.maxZRadius) + this.minZRadius;
    }

    public double getRadiusDivisorPerStack() {
        return this.radiusDivisorPerStack;
    }

    public double getNoiseFrequency() {
        return this.noiseFrequency;
    }

    public static class Builder {
        private class_4651 blockProvider = new class_4656(class_2246.field_10340.method_9564());
        private class_4651 topBlockProvider = new class_4656(class_2246.field_10340.method_9564());
        private int minStackHeight = 1;
        private int maxStackHeight = 1;
        private int minXRadius = 1;
        private int maxXRadius = 3;
        private int minYRadius = this.minXRadius;
        private int maxYRadius = this.maxXRadius;
        private int minZRadius = this.minXRadius;
        private int maxZRadius = this.maxXRadius;
        private double radiusDivisorPerStack = 1.0;
        private double noiseFrequency = 0.045;

        public Builder setBlock(class_2248 block) {
            this.blockProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_2680 state) {
            this.blockProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setBlock(class_4651 provider) {
            this.blockProvider = provider != null ? provider : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setTopBlock(class_2248 block) {
            this.topBlockProvider = block != null ? new class_4656(block.method_9564()) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setTopBlock(class_2680 state) {
            this.topBlockProvider = state != null ? new class_4656(state) : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setTopBlock(class_4651 provider) {
            this.topBlockProvider = provider != null ? provider : new class_4656(class_2246.field_10340.method_9564());
            return this;
        }

        public Builder setMinStackHeight(int minStackHeight) {
            this.minStackHeight = minStackHeight <= 0 ? 1 : minStackHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxStackHeight = maxPossibleHeight <= 0 ? this.minStackHeight + 1 : maxPossibleHeight;
            return this;
        }

        public Builder setMinXRadius(int minXRadius) {
            this.minXRadius = minXRadius <= 0 ? 1 : minXRadius;
            return this;
        }

        public Builder setMaxXRadius(int maxXRadius) {
            this.maxXRadius = maxXRadius <= 0 ? this.minXRadius + 1 : maxXRadius;
            return this;
        }

        public Builder setMinYRadius(int minYRadius) {
            this.minYRadius = minYRadius;
            return this;
        }

        public Builder setMaxYRadius(int maxYRadius) {
            this.maxYRadius = maxYRadius;
            return this;
        }

        public Builder setMinZRadius(int minZRadius) {
            this.minZRadius = minZRadius;
            return this;
        }

        public Builder setMaxZRadius(int maxZRadius) {
            this.maxZRadius = maxZRadius;
            return this;
        }

        public Builder setRadiusDivisor(double radiusDivisorPerStack) {
            this.radiusDivisorPerStack = radiusDivisorPerStack;
            return this;
        }

        public Builder setNoiseFrequency(double noiseFrequency) {
            this.noiseFrequency = noiseFrequency;
            return this;
        }

        public Builder copy(NoisyCaveSphereConfig config) {
            this.blockProvider = config.blockProvider;
            this.topBlockProvider = config.topBlockProvider;
            this.minStackHeight = config.minHeight;
            this.maxStackHeight = config.maxHeight;
            this.minXRadius = config.minXRadius;
            this.maxXRadius = config.maxXRadius;
            this.minYRadius = config.minYRadius;
            this.maxYRadius = config.maxYRadius;
            this.minZRadius = config.minZRadius;
            this.maxZRadius = config.maxZRadius;
            this.radiusDivisorPerStack = config.radiusDivisorPerStack;
            this.noiseFrequency = config.noiseFrequency;
            return this;
        }

        public NoisyCaveSphereConfig build() {
            return new NoisyCaveSphereConfig(this.blockProvider, this.topBlockProvider, this.minStackHeight, this.maxStackHeight, this.minXRadius / 2, this.maxXRadius / 2, this.minYRadius / 2, this.maxYRadius / 2, this.minZRadius / 2, this.maxZRadius / 2, this.radiusDivisorPerStack, this.noiseFrequency);
        }
    }
}

