/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.feature.config.BoulderConfig;
import corgiaoc.byg.util.FabricTags;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_5281;

public class StackableBoulders
extends class_3031<BoulderConfig> {
    protected long seed;
    protected static FastNoise fastNoise;
    public static int stopSpamInt;

    public StackableBoulders(Codec<BoulderConfig> configCodec) {
        super(configCodec);
    }

    public boolean generate(class_5281 world, class_2794 chunkGenerator, Random random, class_2338 position, BoulderConfig config) {
        this.setSeed(world.method_8412());
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)position.method_10087(2 + random.nextInt(10)));
        class_2338.class_2339 mutable2 = new class_2338.class_2339().method_10101((class_2382)mutable);
        int stackHeight = random.nextInt(config.getMaxPossibleHeight()) + config.getMinHeight();
        int radius = random.nextInt(config.getMaxPossibleRadius()) + config.getMinRadius();
        class_2680 blockStateDown = world.method_8320(position.method_10074());
        class_2680 blockStateAtPosition = world.method_8320(position);
        if (blockStateDown.method_26164((class_3494)class_3481.field_15503) || blockStateDown.method_26164((class_3494)class_3481.field_15475) || blockStateAtPosition.method_26164((class_3494)class_3481.field_15503) || blockStateAtPosition.method_26164((class_3494)class_3481.field_15475) || blockStateAtPosition.method_26207() == class_3614.field_15959) {
            return false;
        }
        for (int boulderIDX = 0; boulderIDX < stackHeight; ++boulderIDX) {
            int moveOnX = random.nextInt(4);
            if (random.nextInt(2) == 0) {
                moveOnX = -moveOnX;
            }
            int moveOnZ = random.nextInt(4);
            if (random.nextInt(2) == 1) {
                moveOnZ = -moveOnZ;
            }
            mutable.method_10100(moveOnX, (int)((float)random.nextInt(Math.abs(radius) + 1) * 0.2f + (float)radius * 0.8f) - 3 + -random.nextInt(5), moveOnZ);
            int yPositiveRadius = config.isTopBoulderFlat() && boulderIDX + 1 == stackHeight ? 0 : radius;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= yPositiveRadius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        class_2680 blockState;
                        int squaredDistance = x * x + y * y + z * z;
                        if (squaredDistance > radius * radius) continue;
                        mutable2.method_10101((class_2382)mutable).method_10100(x, y, z);
                        double boulderRoughnessNoise = fastNoise.GetNoise((float)mutable2.method_10263() * 0.04f, (float)mutable2.method_10264() * 0.01f, (float)mutable2.method_10260() * 0.04f);
                        if ((float)squaredDistance > (float)(radius * radius) * 0.8f && boulderRoughnessNoise > -0.3 && boulderRoughnessNoise < 0.3 || !this.canBlockPlaceHere(blockState = world.method_8320((class_2338)mutable2))) continue;
                        world.method_8652((class_2338)mutable2, config.getBlockProvider().method_23455(random, (class_2338)mutable2), 3);
                    }
                }
            }
            while (mutable.method_10264() < world.method_8322() && !world.method_8320((class_2338)mutable).method_26215()) {
                mutable.method_10098(class_2350.field_11036);
            }
            if (3 <= (radius = (int)((double)radius / config.getRadiusDivisorPerStack()))) continue;
            if (stopSpamInt != 0) break;
            BYG.LOGGER.debug("BYG: Boulder Radius is too small to continue stacking! Stack stopping at stack height: " + boulderIDX + "\nPlease lower the stack height or increase the boulder radius.");
            ++stopSpamInt;
            break;
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }

    private boolean canBlockPlaceHere(class_2680 state) {
        return state.method_26215() || state.method_26207() == class_3614.field_15941 || state.method_26207() == class_3614.field_15935 || state.method_26207() == class_3614.field_15956 || state.method_26207() == class_3614.field_15923 || state.method_26207() == class_3614.field_15916 || state.method_26207() == class_3614.field_15946 || state.method_26207() == class_3614.field_15925 || state.method_26207() == class_3614.field_15920 || state.method_26207() == class_3614.field_15922 || state.method_26164(FabricTags.DIRT);
    }

    static {
        stopSpamInt = 0;
    }
}

