/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.trees.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.FeatureUtil;
import corgiaoc.byg.common.world.feature.config.BYGTreeConfig;
import corgiaoc.byg.common.world.feature.overworld.trees.util.SaplingData;
import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.util.FabricTags;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_3746;
import net.minecraft.class_4970;
import net.minecraft.class_5281;

public abstract class BYGAbstractTreeFeature<TFC extends BYGTreeConfig>
extends class_3031<TFC> {
    protected static FastNoise fastNoise;
    protected long seed;
    public static final Map<class_2248, class_2248> SPREADABLE_TO_NON_SPREADABLE;

    public BYGAbstractTreeFeature(Codec<TFC> configCodec) {
        super(configCodec);
    }

    public static boolean canLogPlaceHere(class_3746 worldReader, class_2338 blockPos) {
        return worldReader.method_16358(blockPos, state -> state.method_26207() == class_3614.field_15959 || state.method_26207() == class_3614.field_15920) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean canLogPlaceHereWater(class_3746 worldReader, class_2338 blockPos) {
        return worldReader.method_16358(blockPos, state -> state.method_26207() == class_3614.field_15959 || state.method_26207() == class_3614.field_15920) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean canLogPlaceHereNether(class_3746 worldReader, class_2338 blockPos) {
        return worldReader.method_16358(blockPos, state -> state.method_26207() == class_3614.field_15959 || state.method_26207() == class_3614.field_15920 || state.method_26207() == class_3614.field_15922) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean isAnotherTreeHere(class_3746 worldReader, class_2338 blockPos) {
        return worldReader.method_16358(blockPos, state -> {
            class_2248 block = state.method_26204();
            return block.method_9525((class_3494)class_3481.field_15475) || block.method_9525((class_3494)class_3481.field_15503);
        });
    }

    public boolean isAnotherTreeLikeThisHere(class_3746 worldReader, class_2338 blockPos, class_2248 logBlock, class_2248 leafBlock) {
        return worldReader.method_16358(blockPos, state -> {
            class_2248 block = state.method_26204();
            return block == logBlock || block == leafBlock;
        });
    }

    public void placeTrunk(BYGTreeConfig config, Random random, Set<class_2338> blockSet, class_5281 reader, class_2338 pos, class_3341 boundingBox) {
        if (BYGAbstractTreeFeature.canLogPlaceHere((class_3746)reader, pos)) {
            this.setFinalBlockState(blockSet, (class_1945)reader, pos, config.getTrunkProvider().method_23455(random, pos), boundingBox);
        }
    }

    public void placeBranch(BYGTreeConfig config, Random random, Set<class_2338> blockSet, class_5281 reader, class_2338 pos, class_3341 boundingBox) {
        if (BYGAbstractTreeFeature.canLogPlaceHere((class_3746)reader, pos)) {
            this.setFinalBlockState(blockSet, (class_1945)reader, pos, config.getTrunkProvider().method_23455(random, pos), boundingBox);
        }
    }

    public void placeLeaves(BYGTreeConfig config, Random random, Set<class_2338> blockSet, class_5281 reader, class_2338 pos, class_3341 boundingBox) {
        if (BYGAbstractTreeFeature.isAir((class_3746)reader, pos)) {
            this.setFinalBlockState(blockSet, (class_1945)reader, pos, config.getLeavesProvider().method_23455(random, pos), boundingBox);
        }
    }

    public void placeLeaves(BYGTreeConfig config, Random random, class_5281 reader, int x, int y, int z, class_3341 boundingBox, Set<class_2338> blockPos) {
        class_2338 pos = new class_2338(x, y, z);
        if (BYGAbstractTreeFeature.isAir((class_3746)reader, pos)) {
            this.setFinalBlockState(blockPos, (class_1945)reader, pos, config.getLeavesProvider().method_23455(random, pos), boundingBox);
        }
    }

    public void placeNetherTrunk(BYGTreeConfig config, Random random, Set<class_2338> blockSet, class_5281 reader, class_2338 pos, class_3341 boundingBox) {
        if (this.canLogPlaceHereNether((class_3746)reader, pos)) {
            this.setFinalBlockState(blockSet, (class_1945)reader, pos, config.getTrunkProvider().method_23455(random, pos), boundingBox);
        }
    }

    public void placeNetherBranch(BYGTreeConfig config, Random random, Set<class_2338> blockSet, class_5281 reader, class_2338 pos, class_3341 boundingBox) {
        if (this.canLogPlaceHereNether((class_3746)reader, pos)) {
            this.setFinalBlockState(blockSet, (class_1945)reader, pos, config.getTrunkProvider().method_23455(random, pos), boundingBox);
        }
    }

    public boolean canSaplingGrowHere(class_3746 reader, class_2338 pos) {
        return reader.method_16358(pos, state -> {
            class_2248 block = state.method_26204();
            return block.method_9525((class_3494)class_3481.field_15475) || block.method_9525((class_3494)class_3481.field_15503) || state.method_26215() || state.method_26207() == class_3614.field_15935 || state.method_26207() == class_3614.field_15956 || state.method_26207() == class_3614.field_15947 || state.method_26207() == class_3614.field_15923 || state.method_26207() == class_3614.field_15941;
        });
    }

    public static boolean isAir(class_3746 reader, class_2338 pos) {
        return reader.method_16358(pos, class_4970.class_4971::method_26215);
    }

    public boolean isAirOrWater(class_3746 worldIn, class_2338 pos) {
        return worldIn.method_16358(pos, state -> state.method_26215() || state.method_26204() == class_2246.field_10382);
    }

    public static boolean isDesiredGroundwDirtTag(class_3746 reader, class_2338 pos, BYGTreeConfig config) {
        if (config.isPlacementForced()) {
            return true;
        }
        return reader.method_16358(pos, state -> {
            class_2248 block = state.method_26204();
            Iterator<class_2248> iterator = config.getWhitelist().iterator();
            if (iterator.hasNext()) {
                class_2248 block1 = iterator.next();
                return block.method_9525(FabricTags.DIRT) || block == block1;
            }
            return block.method_9525(FabricTags.DIRT);
        });
    }

    public static boolean isDesiredGroundwNetherTags(class_3746 reader, class_2338 pos, BYGTreeConfig config) {
        if (config.isPlacementForced()) {
            return true;
        }
        return reader.method_16358(pos, state -> {
            class_2248 block = state.method_26204();
            Iterator<class_2248> iterator = config.getWhitelist().iterator();
            if (iterator.hasNext()) {
                class_2248 block1 = iterator.next();
                return block.method_9525(FabricTags.NETHERRACK) || block.method_9525((class_3494)class_3481.field_21953) || block.method_9525((class_3494)class_3481.field_23119) || block == block1;
            }
            return block.method_9525(FabricTags.NETHERRACK) || block.method_9525((class_3494)class_3481.field_21953) || block.method_9525((class_3494)class_3481.field_23119);
        });
    }

    public static boolean isDesiredGroundwEndTags(class_3746 reader, class_2338 pos, BYGTreeConfig config) {
        if (config.isPlacementForced()) {
            return true;
        }
        return reader.method_16358(pos, state -> {
            class_2248 block = state.method_26204();
            Iterator<class_2248> iterator = config.getWhitelist().iterator();
            if (iterator.hasNext()) {
                class_2248 block1 = iterator.next();
                return block.method_9525(FabricTags.END_STONES) || block == block1;
            }
            return block.method_9525(FabricTags.END_STONES);
        });
    }

    public boolean isDesiredGround(class_3746 reader, class_2338 pos, class_2248 ... desiredGroundBlock) {
        return reader.method_16358(pos, state -> {
            class_2248 block = state.method_26204();
            int n = 0;
            class_2248[] class_2248Array = desiredGroundBlock;
            int n2 = class_2248Array.length;
            if (n < n2) {
                class_2248 block1 = class_2248Array[n];
                return block == block1;
            }
            return false;
        });
    }

    public boolean doesSaplingHaveSpaceToGrow(class_3746 reader, class_2338 pos, int treeHeight, int canopyStartHeight, int xDistance, int zDistance, boolean isSapling, class_2338 ... trunkPositions) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canSaplingGrowHere(reader, (class_2338)mutable.method_10103(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (class_2338 trunkPos : trunkPositions) {
                    if (this.canSaplingGrowHere(reader, (class_2338)mutable.method_10103(trunkPos.method_10263(), trunkPos.method_10264() + yOffSet, trunkPos.method_10260()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xDistance; xOffset <= xDistance; ++xOffset) {
                    for (int zOffset = -zDistance; zOffset <= zDistance; ++zOffset) {
                        if (this.canSaplingGrowHere(reader, (class_2338)mutable.method_10103(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean doesSaplingHaveSpaceToGrow(class_3746 reader, class_2338 pos, int treeHeight, int canopyStartHeight, int xNegativeDistance, int zNegativeDistance, int xPositiveDistance, int zPositiveDistance, boolean isSapling, class_2338 ... trunkPositions) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canSaplingGrowHere(reader, (class_2338)mutable.method_10103(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (class_2338 trunkPos : trunkPositions) {
                    if (this.canSaplingGrowHere(reader, (class_2338)mutable.method_10103(trunkPos.method_10263(), trunkPos.method_10264() + yOffSet, trunkPos.method_10260()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xNegativeDistance; xOffset <= xPositiveDistance; ++xOffset) {
                    for (int zOffset = -zNegativeDistance; zOffset <= zPositiveDistance; ++zOffset) {
                        if (this.canSaplingGrowHere(reader, (class_2338)mutable.method_10103(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherTreeNearby(class_3746 reader, class_2338 pos, int treeHeight, int distance, boolean isSapling) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherTreeHere(reader, (class_2338)mutable.method_10103(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherTreeLikeThisNearby(class_3746 reader, class_2338 pos, int treeHeight, int distance, class_2248 logBlock, class_2248 leafBlock, boolean isSapling) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherTreeLikeThisHere(reader, (class_2338)mutable.method_10103(x + xOffset, y + yOffset, z + zOffset), logBlock, leafBlock)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isCliff(class_3746 reader, class_2338 ... trunkPositions) {
        return this.isCliff(reader, 5, trunkPositions);
    }

    public boolean isCliff(class_3746 reader, int checkDownRange, class_2338 ... trunkPositions) {
        if (trunkPositions.length > 0) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (class_2338 trunkPos : trunkPositions) {
                mutable.method_10101((class_2382)trunkPos);
                for (int moveDown = 0; moveDown <= checkDownRange && (this.isAirOrWater(reader, (class_2338)mutable) || FeatureUtil.isPlant(reader, (class_2338)mutable)); ++moveDown) {
                    if (moveDown == checkDownRange) {
                        return true;
                    }
                    mutable.method_10098(class_2350.field_11033);
                }
            }
        }
        return false;
    }

    public static boolean isDesiredGroundwSandTag(class_3746 reader, class_2338 pos, BYGTreeConfig config) {
        if (config.isPlacementForced()) {
            return true;
        }
        return reader.method_16358(pos, state -> {
            class_2248 block = state.method_26204();
            Iterator<class_2248> iterator = config.getWhitelist().iterator();
            if (iterator.hasNext()) {
                class_2248 block1 = iterator.next();
                return block.method_9525(FabricTags.SAND) || block == block1;
            }
            return block.method_9525(FabricTags.SAND);
        });
    }

    public void setSoil(Set<class_2338> treeBlocksSet, class_3746 reader, BYGTreeConfig config, Random rand, class_3341 boundingBox, class_2338 ... trunkPositions) {
        if (trunkPositions.length > 0) {
            class_2338.class_2339 mutableTrunk = new class_2338.class_2339();
            for (class_2338 trunkPos : trunkPositions) {
                mutableTrunk.method_10101((class_2382)trunkPos);
                if (this.isDesiredGround(reader, (class_2338)mutableTrunk, config.getTrunkProvider().method_23455(rand, (class_2338)mutableTrunk).method_26204())) continue;
                this.setFinalBlockState(treeBlocksSet, (class_1945)reader, (class_2338)mutableTrunk.method_10098(class_2350.field_11033), config.getTrunkProvider().method_23455(rand, (class_2338)mutableTrunk), boundingBox);
            }
        }
    }

    public void setDisk(class_5281 world, Random random, class_2338 pos, BYGTreeConfig config) {
        if (config.isPlacementForced() || config.getDiskRadius() <= 0) {
            return;
        }
        this.setSeed(world.method_8412());
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)pos);
        int diskRadius = config.getDiskRadius();
        for (int x = -diskRadius; x <= diskRadius; ++x) {
            for (int z = -diskRadius; z <= diskRadius; ++z) {
                int squaredDistance = x * x + z * z;
                if (squaredDistance > diskRadius * diskRadius) continue;
                mutable.method_10101((class_2382)pos).method_10100(x, 0, z);
                double diskRoughnessNoise = fastNoise.GetNoise((float)mutable.method_10263() * 0.04f, (float)mutable.method_10264() * 0.01f, (float)mutable.method_10260() * 0.04f);
                if ((float)squaredDistance > (float)(diskRadius * diskRadius) * 0.8f && diskRoughnessNoise > -0.3 && diskRoughnessNoise < 0.3 || !FeatureUtil.isTerrainOrRock((class_3746)world, (class_2338)mutable) || !world.method_8320(mutable.method_10084()).method_26215() && !FeatureUtil.isPlant((class_3746)world, mutable.method_10084())) continue;
                world.method_8652((class_2338)mutable, config.getDiskProvider().method_23455(random, (class_2338)mutable), 2);
            }
        }
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }

    public final void setFinalBlockState(Set<class_2338> changedBlocks, class_1945 worldIn, class_2338 pos, class_2680 blockState, class_3341 boundingBox) {
        this.setBlockStateWithoutUpdates(worldIn, pos, blockState);
        boundingBox.method_14668(new class_3341((class_2382)pos, (class_2382)pos));
        if (class_3481.field_15475.method_15141((Object)blockState.method_26204())) {
            changedBlocks.add(pos.method_10062());
        }
    }

    public void setBlockStateWithoutUpdates(class_1945 worldWriter, class_2338 blockPos, class_2680 blockState) {
        worldWriter.method_8652(blockPos, blockState, 18);
    }

    protected void method_13153(class_1945 worldIn, class_2338 pos, class_2680 state) {
        this.setBlockStateWithoutUpdates(worldIn, pos, state);
    }

    public boolean generate(class_5281 worldIn, class_2794 generator, Random rand, class_2338 pos, TFC config) {
        return this.placeTree(worldIn, rand, pos, config);
    }

    public boolean placeTree(class_5281 worldIn, Random rand, class_2338 pos, TFC config) {
        HashSet set = Sets.newHashSet();
        class_3341 mutableboundingbox = class_3341.method_14665();
        boolean flag = this.generate(set, worldIn, rand, pos, mutableboundingbox, ((BYGTreeConfig)config).isPlacementForced(), config);
        if (mutableboundingbox.field_14381 > mutableboundingbox.field_14378) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        class_244 voxelshapepart = new class_244(mutableboundingbox.method_14660(), mutableboundingbox.method_14663(), mutableboundingbox.method_14664());
        try (PooledMutable blockPosPool = PooledMutable.get();){
            if (flag && !set.isEmpty()) {
                for (class_2338 blockpos : Lists.newArrayList((Iterable)set)) {
                    if (mutableboundingbox.method_14662((class_2382)blockpos)) {
                        voxelshapepart.method_1049(blockpos.method_10263() - mutableboundingbox.field_14381, blockpos.method_10264() - mutableboundingbox.field_14380, blockpos.method_10260() - mutableboundingbox.field_14379, true, true);
                    }
                    for (class_2350 direction : class_2350.values()) {
                        class_2680 blockstate;
                        blockPosPool.set((class_2382)blockpos).method_10098(direction);
                        if (set.contains(blockPosPool) || !(blockstate = worldIn.method_8320((class_2338)blockPosPool)).method_28498((class_2769)class_2741.field_12541)) continue;
                        ((Set)list.get(0)).add(blockPosPool.method_10062());
                        this.setBlockStateWithoutUpdates((class_1945)worldIn, (class_2338)blockPosPool, (class_2680)blockstate.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)));
                        if (!mutableboundingbox.method_14662((class_2382)blockPosPool)) continue;
                        voxelshapepart.method_1049(blockPosPool.method_10263() - mutableboundingbox.field_14381, blockPosPool.method_10264() - mutableboundingbox.field_14380, blockPosPool.method_10260() - mutableboundingbox.field_14379, true, true);
                    }
                }
            }
            for (int l = 1; l < 6; ++l) {
                Set set1 = (Set)list.get(l - 1);
                Set set2 = (Set)list.get(l);
                for (class_2338 blockpos1 : set1) {
                    if (mutableboundingbox.method_14662((class_2382)blockpos1)) {
                        voxelshapepart.method_1049(blockpos1.method_10263() - mutableboundingbox.field_14381, blockpos1.method_10264() - mutableboundingbox.field_14380, blockpos1.method_10260() - mutableboundingbox.field_14379, true, true);
                    }
                    for (class_2350 direction1 : class_2350.values()) {
                        int k;
                        class_2680 blockstate1;
                        blockPosPool.set((class_2382)blockpos1).method_10098(direction1);
                        if (set1.contains(blockPosPool) || set2.contains(blockPosPool) || !(blockstate1 = worldIn.method_8320((class_2338)blockPosPool)).method_28498((class_2769)class_2741.field_12541) || (k = ((Integer)blockstate1.method_11654((class_2769)class_2741.field_12541)).intValue()) <= l + 1) continue;
                        class_2680 blockstate2 = (class_2680)blockstate1.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(l + 1));
                        this.setBlockStateWithoutUpdates((class_1945)worldIn, (class_2338)blockPosPool, blockstate2);
                        if (mutableboundingbox.method_14662((class_2382)blockPosPool)) {
                            voxelshapepart.method_1049(blockPosPool.method_10263() - mutableboundingbox.field_14381, blockPosPool.method_10264() - mutableboundingbox.field_14380, blockPosPool.method_10260() - mutableboundingbox.field_14379, true, true);
                        }
                        set2.add(blockPosPool.method_10062());
                    }
                }
            }
        }
        class_3499.method_20532((class_1936)worldIn, (int)3, (class_251)voxelshapepart, (int)mutableboundingbox.field_14381, (int)mutableboundingbox.field_14380, (int)mutableboundingbox.field_14379);
        this.setDisk(worldIn, rand, pos.method_10074(), (BYGTreeConfig)config);
        return flag;
    }

    protected abstract boolean generate(Set<class_2338> var1, class_5281 var2, Random var3, class_2338 var4, class_3341 var5, boolean var6, TFC var7);

    @Nullable
    public SaplingData saplingData(class_2338 pos) {
        return new SaplingData(new HashSet<class_2338>(), 0);
    }

    public void buildTrunkBase(class_2338 centerPos, Set<class_2338> treeBlocksSet, class_5281 reader, BYGTreeConfig config, Random rand, class_3341 boundingBox, class_2338 ... trunkPositions) {
        if (config.isPlacementForced()) {
            return;
        }
        class_2680 ground = reader.method_8320(centerPos.method_10093(class_2350.field_11033));
        if (SPREADABLE_TO_NON_SPREADABLE.containsKey(ground.method_26204())) {
            ground = SPREADABLE_TO_NON_SPREADABLE.get(ground.method_26204()).method_9564();
        }
        if (trunkPositions.length > 0) {
            class_2338.class_2339 mutableTrunk = new class_2338.class_2339();
            for (class_2338 trunkPos : trunkPositions) {
                mutableTrunk.method_10101((class_2382)trunkPos);
                for (int fill = 1; fill <= 25; ++fill) {
                    if (BYGAbstractTreeFeature.canLogPlaceHere((class_3746)reader, (class_2338)mutableTrunk)) {
                        if (fill <= 15) {
                            this.setFinalBlockState(treeBlocksSet, (class_1945)reader, (class_2338)mutableTrunk, config.getTrunkProvider().method_23455(rand, (class_2338)mutableTrunk), boundingBox);
                        } else {
                            this.setFinalBlockState(treeBlocksSet, (class_1945)reader, (class_2338)mutableTrunk, ground, boundingBox);
                        }
                    } else {
                        if (!this.isDesiredGround((class_3746)reader, (class_2338)mutableTrunk, config.getTrunkProvider().method_23455(rand, (class_2338)mutableTrunk).method_26204())) {
                            this.setFinalBlockState(treeBlocksSet, (class_1945)reader, (class_2338)mutableTrunk, ground, boundingBox);
                        }
                        fill = 25;
                    }
                    mutableTrunk.method_10098(class_2350.field_11033);
                }
            }
        }
    }

    static {
        SPREADABLE_TO_NON_SPREADABLE = new HashMap<class_2248, class_2248>();
        SPREADABLE_TO_NON_SPREADABLE.put(class_2246.field_10219, class_2246.field_10566);
        SPREADABLE_TO_NON_SPREADABLE.put(class_2246.field_10402, class_2246.field_10566);
        SPREADABLE_TO_NON_SPREADABLE.put(class_2246.field_10194, class_2246.field_10566);
        SPREADABLE_TO_NON_SPREADABLE.put(class_2246.field_10520, class_2246.field_10566);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.OVERGROWN_DACITE, BYGBlocks.DACITE);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.PODZOL_DACITE, BYGBlocks.DACITE);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.OVERGROWN_STONE, class_2246.field_10340);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.OVERGROWN_CRIMSON_BLACKSTONE, class_2246.field_23869);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.OVERGROWN_NETHERRACK, class_2246.field_10515);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.SYTHIAN_NYLIUM, class_2246.field_10515);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.EMBUR_NYLIUM, BYGBlocks.BLUE_NETHERRACK);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.IVIS_PHYLIUM, class_2246.field_10471);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.NIGHTSHADE_PHYLIUM, class_2246.field_10471);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.SHULKREN_PHYLIUM, class_2246.field_10471);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.VERMILION_SCULK, BYGBlocks.ETHER_STONE);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.ETHER_PHYLIUM, BYGBlocks.ETHER_SOIL);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.MEADOW_GRASSBLOCK, BYGBlocks.MEADOW_DIRT);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.MEADOW_GRASS_PATH, BYGBlocks.MEADOW_DIRT);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.GLOWCELIUM, class_2246.field_10566);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.MYCELIUM_NETHERRACK, class_2246.field_10515);
    }

    public static final class PooledMutable
    extends class_2338.class_2339
    implements AutoCloseable {
        private boolean free;
        private static final List<PooledMutable> POOL = Lists.newArrayList();

        private PooledMutable(int x, int y, int z) {
            super(x, y, z);
        }

        public static PooledMutable get() {
            return PooledMutable.get(0, 0, 0);
        }

        public static PooledMutable get(double x, double y, double z) {
            return PooledMutable.get(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PooledMutable get(int x, int y, int z) {
            List<PooledMutable> list = POOL;
            synchronized (list) {
                PooledMutable pooledMutable;
                if (!POOL.isEmpty() && (pooledMutable = POOL.remove(POOL.size() - 1)) != null && pooledMutable.free) {
                    pooledMutable.free = false;
                    pooledMutable.set(x, y, z);
                    return pooledMutable;
                }
            }
            return new PooledMutable(x, y, z);
        }

        public PooledMutable set(int i, int j, int k) {
            return (PooledMutable)super.method_10103(i, j, k);
        }

        public PooledMutable set(double d, double e, double f) {
            return (PooledMutable)super.method_10102(d, e, f);
        }

        public PooledMutable set(class_2382 vec3i) {
            return (PooledMutable)super.method_10101(vec3i);
        }

        public PooledMutable setOffset(class_2350 direction) {
            return this.setOffset(direction, 1);
        }

        public PooledMutable setOffset(class_2350 direction, int distance) {
            return this.set(this.method_10263() + direction.method_10148() * distance, this.method_10264() + direction.method_10164() * distance, this.method_10260() + direction.method_10165() * distance);
        }

        public class_2338.class_2339 setOffset(int x, int y, int z) {
            return this.set(this.method_10263() + x, this.method_10264() + y, this.method_10260() + z);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List<PooledMutable> list = POOL;
            synchronized (list) {
                if (POOL.size() < 100) {
                    POOL.add(this);
                }
                this.free = true;
            }
        }
    }
}

