/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.biomedata;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import corgiaoc.byg.BYG;
import corgiaoc.byg.config.json.biomedata.BiomeData;
import corgiaoc.byg.config.json.biomedata.BiomeDataListHolder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.OverworldClimate;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_4131;
import net.minecraft.class_5458;

public class BiomeDataListHolderSerializer
implements JsonSerializer<BiomeDataListHolder>,
JsonDeserializer<BiomeDataListHolder> {
    public JsonElement serialize(BiomeDataListHolder Src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject biomes = new JsonObject();
        JsonObject biomeObject = new JsonObject();
        for (BiomeData biomeData : Src.getBiomeData()) {
            JsonArray weightedListArray = new JsonArray();
            JsonObject object = new JsonObject();
            if (biomeData.getBiomeWeightedList() != null) {
                for (class_4131.class_4132 biomeEntry : biomeData.getBiomeWeightedList().field_18397) {
                    JsonObject object2 = new JsonObject();
                    class_2960 biomeEntryKey = class_5458.field_25933.method_10221(biomeEntry.method_19035());
                    if (biomeEntryKey != null) {
                        object2.addProperty("name", biomeEntryKey.toString());
                        object2.addProperty("weight", (Number)biomeEntry.field_18401);
                        weightedListArray.add((JsonElement)object2);
                        continue;
                    }
                    BYG.LOGGER.error("One or more \"hills\" \"name\" value was null/incorrect.");
                }
            }
            object.addProperty("climate", biomeData.getBiomeType().toString().toUpperCase());
            object.addProperty("weight", (Number)biomeData.getBiomeWeight());
            class_2960 riverKey = class_5458.field_25933.method_10221((Object)biomeData.getRiverBiome());
            if (riverKey != null) {
                object.addProperty("river", riverKey.toString());
            } else {
                object.addProperty("river", "");
            }
            class_2960 beachKey = class_5458.field_25933.method_10221((Object)biomeData.getBeachBiome());
            if (beachKey != null) {
                object.addProperty("beach", beachKey.toString());
            } else {
                object.addProperty("beach", "");
            }
            class_2960 edgeKey = class_5458.field_25933.method_10221((Object)biomeData.getEdgeBiome());
            if (edgeKey != null) {
                object.addProperty("edge", edgeKey.toString());
            } else {
                object.addProperty("edge", "");
            }
            object.add("hills", (JsonElement)weightedListArray);
            class_2960 location = class_5458.field_25933.method_10221((Object)biomeData.getBiome());
            if (location != null) {
                biomeObject.add(location.toString(), (JsonElement)object);
                continue;
            }
            BYG.LOGGER.error("The Biome key was null! This should NEVER happen.");
        }
        biomes.add("biomes", (JsonElement)biomeObject);
        return biomes;
    }

    public BiomeDataListHolder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BYG.LOGGER.info("Reading json");
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayList<BiomeData> biomeData = new ArrayList<BiomeData>();
        Set entrySet = jsonObject.get("biomes").getAsJsonObject().entrySet();
        for (Map.Entry elementEntry : entrySet) {
            OverworldClimate biomeType;
            class_4131 weightedList = new class_4131();
            String biomeName = (String)elementEntry.getKey();
            JsonElement element = (JsonElement)elementEntry.getValue();
            JsonObject elementObject = element.getAsJsonObject();
            String climate = elementObject.get("climate").getAsString().toUpperCase();
            String edge = elementObject.get("edge").getAsString();
            String river = elementObject.get("river").getAsString();
            String beach = elementObject.get("beach").getAsString();
            int weight = elementObject.get("weight").getAsInt();
            List defaultClimates = Arrays.stream(OverworldClimate.values()).map(Enum::toString).collect(Collectors.toList());
            if (!defaultClimates.contains(climate)) {
                BYG.LOGGER.error((String)elementEntry.getKey() + "'s \"climate\" value is incorrect you put: \"" + climate + "\". Defaulting climate to temperate...");
                biomeType = OverworldClimate.TEMPERATE;
            } else {
                biomeType = OverworldClimate.valueOf((String)climate);
            }
            JsonArray hillLayerList = elementObject.get("hills").getAsJsonArray();
            for (JsonElement hillElement : hillLayerList) {
                class_2960 hillIdentifier;
                JsonObject hillObject = hillElement.getAsJsonObject();
                String hillBiomeName = hillObject.get("name").getAsString();
                Integer hillWeight = hillObject.get("weight").getAsInt();
                if (hillBiomeName == null || hillWeight == null || (hillIdentifier = new class_2960(hillBiomeName)) == null) continue;
                if (class_5458.field_25933.method_10235().contains(hillIdentifier)) {
                    weightedList.method_19031(Objects.requireNonNull(class_5458.field_25933.method_10223(hillIdentifier)), hillWeight.intValue());
                    continue;
                }
                BYG.LOGGER.error("Could not find: \"" + hillIdentifier.toString() + "\" in the biome registry!\nEntry will not be added. Skipping entry...");
            }
            class_2960 biomeKey = new class_2960(biomeName);
            if (class_5458.field_25933.method_10235().contains(biomeKey)) {
                if (biomeKey.method_12836().equals("byg")) {
                    biomeData.add(new BiomeData((class_1959)class_5458.field_25933.method_10223(biomeKey), weight, biomeType, (class_4131<class_1959>)weightedList, (class_1959)class_5458.field_25933.method_10223(new class_2960(edge)), (class_1959)class_5458.field_25933.method_10223(new class_2960(beach)), (class_1959)class_5458.field_25933.method_10223(new class_2960(river))));
                    continue;
                }
                BYG.LOGGER.error("Biome key: \"" + biomeName + "\" is illegal. The mod id for the biome key MUST be \"byg\". Skipping entry...");
                continue;
            }
            BYG.LOGGER.error("The biome key: \"" + biomeName + "\" was not found in the registry, skipping entry...");
        }
        return new BiomeDataListHolder(biomeData);
    }
}

