/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.endbiomedata;

import corgiaoc.byg.common.world.biome.BYGEndBiome;
import corgiaoc.byg.common.world.dimension.end.BYGEndBiomeProvider;
import corgiaoc.byg.config.json.endbiomedata.EndBiomeData;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4131;
import net.minecraft.class_5458;

public class EndBiomeDataListHolder {
    private final List<EndBiomeData> voidBiomeData;
    List<EndBiomeData> endBiomeData;

    public EndBiomeDataListHolder(List<EndBiomeData> endBiomeData, List<EndBiomeData> voidBiomeData) {
        this.endBiomeData = endBiomeData;
        this.voidBiomeData = voidBiomeData;
    }

    public static void createDefaults(class_2378<class_1959> biomeRegistry) {
        for (BYGEndBiome bygBiome : BYGEndBiome.BYG_END_BIOMES) {
            BYGEndBiome.endBiomeData.add(new EndBiomeData(class_5458.field_25933.method_10221((Object)bygBiome.getBiome()), bygBiome.getWeight(), bygBiome.getHills(), class_5458.field_25933.method_10221((Object)bygBiome.getEdge()), bygBiome.isVoid()));
        }
        for (class_2960 location2 : biomeRegistry.method_10235().stream().filter(location -> !location.toString().contains("byg") && !location.toString().equals("minecraft:the_end")).collect(Collectors.toSet())) {
            if (location2.toString().equals("minecraft:small_end_islands")) {
                BYGEndBiome.endBiomeData.add(new EndBiomeData(location2, 5, (class_4131<class_2960>)new class_4131(), null, true));
                continue;
            }
            if (location2.toString().equals("minecraft:end_barrens")) {
                BYGEndBiome.endBiomeData.add(new EndBiomeData(location2, 1, (class_4131<class_2960>)new class_4131(), null));
                continue;
            }
            if (((class_1959)biomeRegistry.method_17966(location2).get()).method_8688() != class_1959.class_1961.field_9360) continue;
            BYGEndBiome.endBiomeData.add(new EndBiomeData(location2, 5, (class_4131<class_2960>)new class_4131(), null));
        }
        BYGEndBiome.endBiomeData.removeIf(endBiomeData1 -> endBiomeData1.getBiome() == null);
        BYGEndBiome.endBiomeData.sort(Comparator.comparing(data -> data.getBiome().toString()));
    }

    public static void fillBiomeLists() {
        class_4131 end_biomes = new class_4131();
        class_4131 void_biomes = new class_4131();
        HashMap<class_2960, class_4131<class_2960>> biome_to_hills = new HashMap<class_2960, class_4131<class_2960>>();
        HashMap<class_2960, class_2960> biome_to_edge = new HashMap<class_2960, class_2960>();
        for (EndBiomeData endBiomeData : BYGEndBiome.endBiomeData) {
            if (endBiomeData.getBiomeWeightedList() != null) {
                biome_to_hills.put(endBiomeData.getBiome(), endBiomeData.getBiomeWeightedList());
            }
            if (endBiomeData.getEdgeBiome() != null) {
                biome_to_edge.put(endBiomeData.getBiome(), endBiomeData.getEdgeBiome());
            }
            end_biomes.method_19031((Object)endBiomeData.getBiome(), endBiomeData.getBiomeWeight());
        }
        for (EndBiomeData endBiomeData : BYGEndBiome.voidBiomeData) {
            if (endBiomeData.getBiomeWeightedList() != null) {
                biome_to_hills.put(endBiomeData.getBiome(), endBiomeData.getBiomeWeightedList());
            }
            if (endBiomeData.getEdgeBiome() != null) {
                biome_to_edge.put(endBiomeData.getBiome(), endBiomeData.getEdgeBiome());
            }
            void_biomes.method_19031((Object)endBiomeData.getBiome(), endBiomeData.getBiomeWeight());
        }
        biome_to_hills.entrySet().removeIf(Objects::isNull);
        biome_to_edge.entrySet().removeIf(Objects::isNull);
        end_biomes.field_18397.removeIf(Objects::isNull);
        void_biomes.field_18397.removeIf(Objects::isNull);
        BYGEndBiomeProvider.END_BIOMES = end_biomes;
        BYGEndBiomeProvider.VOID_BIOMES = void_biomes;
        BYGEndBiome.BIOME_TO_HILLS = biome_to_hills;
        BYGEndBiome.BIOME_TO_EDGE = biome_to_edge;
    }

    public List<EndBiomeData> getEndBiomeData() {
        return this.endBiomeData;
    }

    public List<EndBiomeData> getVoidBiomeData() {
        return this.voidBiomeData;
    }
}

