/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.endbiomedata;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import corgiaoc.byg.BYG;
import corgiaoc.byg.config.json.endbiomedata.EndBiomeData;
import corgiaoc.byg.config.json.endbiomedata.EndBiomeDataListHolder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_4131;

public class EndBiomeDataListHolderSerializer
implements JsonSerializer<EndBiomeDataListHolder>,
JsonDeserializer<EndBiomeDataListHolder> {
    public JsonElement serialize(EndBiomeDataListHolder Src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject biomes = new JsonObject();
        JsonObject endBiomeObject = new JsonObject();
        JsonObject voidBiomeObject = new JsonObject();
        for (EndBiomeData endBiomeData : Src.getEndBiomeData()) {
            JsonArray hillListArray = new JsonArray();
            JsonObject endBiome = new JsonObject();
            if (endBiomeData.getBiomeWeightedList() != null) {
                for (class_4131.class_4132 biomeEntry : endBiomeData.getBiomeWeightedList().field_18397) {
                    JsonObject object2 = new JsonObject();
                    class_2960 biomeEntryKey = (class_2960)biomeEntry.method_19035();
                    if (biomeEntryKey != null) {
                        object2.addProperty("name", biomeEntryKey.toString());
                        object2.addProperty("weight", (Number)biomeEntry.field_18401);
                        hillListArray.add((JsonElement)object2);
                        continue;
                    }
                    BYG.LOGGER.error("One or more \"hills\" \"name\" value was null/incorrect.");
                }
            }
            endBiome.addProperty("weight", (Number)endBiomeData.getBiomeWeight());
            class_2960 edgeKey = endBiomeData.getEdgeBiome();
            if (edgeKey != null) {
                endBiome.addProperty("edge", edgeKey.toString());
            } else {
                endBiome.addProperty("edge", "");
            }
            endBiome.add("hills", (JsonElement)hillListArray);
            class_2960 location = endBiomeData.getBiome();
            if (location != null) {
                if (endBiomeData.isVoid()) {
                    voidBiomeObject.add(location.toString(), (JsonElement)endBiome);
                    continue;
                }
                endBiomeObject.add(location.toString(), (JsonElement)endBiome);
                continue;
            }
            BYG.LOGGER.error("The Biome key was null! This should NEVER happen.");
        }
        biomes.add("biomes", (JsonElement)endBiomeObject);
        biomes.add("void-biomes", (JsonElement)voidBiomeObject);
        return biomes;
    }

    public EndBiomeDataListHolder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BYG.LOGGER.info("Reading json");
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayList<EndBiomeData> endBiomeData = new ArrayList<EndBiomeData>();
        ArrayList<EndBiomeData> voidBiomeData = new ArrayList<EndBiomeData>();
        this.extractElements(endBiomeData, jsonObject.get("biomes").getAsJsonObject().entrySet());
        this.extractElements(voidBiomeData, jsonObject.get("void-biomes").getAsJsonObject().entrySet());
        return new EndBiomeDataListHolder(endBiomeData, voidBiomeData);
    }

    private void extractElements(List<EndBiomeData> endBiomeData, Set<Map.Entry<String, JsonElement>> entrySet) {
        for (Map.Entry<String, JsonElement> elementEntry : entrySet) {
            class_4131 weightedList = new class_4131();
            String biomeName = elementEntry.getKey();
            JsonElement element = elementEntry.getValue();
            JsonObject elementObject = element.getAsJsonObject();
            String edge = elementObject.get("edge").getAsString();
            int weight = elementObject.get("weight").getAsInt();
            JsonArray hillLayerList = elementObject.get("hills").getAsJsonArray();
            for (JsonElement hillElement : hillLayerList) {
                class_2960 hillIdentifier;
                JsonObject hillObject = hillElement.getAsJsonObject();
                String hillBiomeName = hillObject.get("name").getAsString();
                Integer hillWeight = hillObject.get("weight").getAsInt();
                if (hillBiomeName == null || hillWeight == null || (hillIdentifier = new class_2960(hillBiomeName)) == null) continue;
                if (BYG.EARLY_BIOME_REGISTRY_ACCESS.method_10235().contains(hillIdentifier)) {
                    weightedList.method_19031((Object)hillIdentifier, hillWeight.intValue());
                    continue;
                }
                BYG.LOGGER.error("Could not find: \"" + hillIdentifier.toString() + "\" in the biome registry!\nEntry will not be added. Skipping entry...");
            }
            class_2960 biomeKey = new class_2960(biomeName);
            if (BYG.EARLY_BIOME_REGISTRY_ACCESS.method_10235().contains(biomeKey)) {
                endBiomeData.add(new EndBiomeData(biomeKey, weight, (class_4131<class_2960>)weightedList, new class_2960(edge)));
                continue;
            }
            BYG.LOGGER.error("The biome key: \"" + biomeName + "\" was not found in the registry, skipping entry...");
        }
    }
}

