/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.endbiomedata.sub;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import corgiaoc.byg.BYG;
import corgiaoc.byg.config.json.endbiomedata.sub.EndSubBiomeData;
import corgiaoc.byg.config.json.endbiomedata.sub.EndSubBiomeDataListHolder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_4131;

public class EndSubBiomeDataListHolderSerializer
implements JsonSerializer<EndSubBiomeDataListHolder>,
JsonDeserializer<EndSubBiomeDataListHolder> {
    public JsonElement serialize(EndSubBiomeDataListHolder Src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject biomes = new JsonObject();
        JsonObject endBiomeObject = new JsonObject();
        JsonObject voidBiomeObject = new JsonObject();
        for (EndSubBiomeData endSubBiomeData : Src.getEndSubBiomeData()) {
            JsonObject object = new JsonObject();
            class_2960 edgeKey = endSubBiomeData.getEdgeBiome();
            if (edgeKey != null) {
                object.addProperty("edge", edgeKey.toString());
            } else {
                object.addProperty("edge", "");
            }
            class_2960 location = endSubBiomeData.getBiome();
            if (location != null) {
                if (endSubBiomeData.isVoid()) {
                    voidBiomeObject.add(location.toString(), (JsonElement)object);
                    continue;
                }
                endBiomeObject.add(location.toString(), (JsonElement)object);
                continue;
            }
            BYG.LOGGER.error("The Biome key was null! This should NEVER happen.");
        }
        biomes.add("biomes", (JsonElement)endBiomeObject);
        biomes.add("void-biomes", (JsonElement)voidBiomeObject);
        return biomes;
    }

    public EndSubBiomeDataListHolder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BYG.LOGGER.info("Reading json");
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayList<EndSubBiomeData> endSubBiomeData = new ArrayList<EndSubBiomeData>();
        ArrayList<EndSubBiomeData> voidSubBiomeData = new ArrayList<EndSubBiomeData>();
        Set entrySet = jsonObject.get("biomes").getAsJsonObject().entrySet();
        Set voidEntrySet = jsonObject.get("void-biomes").getAsJsonObject().entrySet();
        this.extractElements(endSubBiomeData, entrySet);
        this.extractElements(endSubBiomeData, voidEntrySet);
        return new EndSubBiomeDataListHolder(endSubBiomeData, voidSubBiomeData);
    }

    private void extractElements(List<EndSubBiomeData> endSubBiomeData, Set<Map.Entry<String, JsonElement>> entrySet) {
        for (Map.Entry<String, JsonElement> elementEntry : entrySet) {
            class_4131 weightedList = new class_4131();
            String biomeName = elementEntry.getKey();
            JsonElement element = elementEntry.getValue();
            JsonObject elementObject = element.getAsJsonObject();
            String edge = elementObject.get("edge").getAsString();
            class_2960 biomeKey = new class_2960(biomeName);
            if (BYG.EARLY_BIOME_REGISTRY_ACCESS.method_10235().contains(biomeKey)) {
                endSubBiomeData.add(new EndSubBiomeData(biomeKey, new class_2960(edge)));
                continue;
            }
            BYG.LOGGER.error("The biome key: \"" + biomeName + "\" was not found in the dynamic registry, skipping entry...");
        }
    }
}

