/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.subbiomedata;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import corgiaoc.byg.BYG;
import corgiaoc.byg.config.json.subbiomedata.SubBiomeData;
import corgiaoc.byg.config.json.subbiomedata.SubBiomeDataListHolder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5458;

public class SubBiomeDataListHolderSerializer
implements JsonSerializer<SubBiomeDataListHolder>,
JsonDeserializer<SubBiomeDataListHolder> {
    public JsonElement serialize(SubBiomeDataListHolder Src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject biomes = new JsonObject();
        JsonObject biomeObject = new JsonObject();
        for (SubBiomeData biomeData : Src.getSubBiomeData()) {
            JsonObject object = new JsonObject();
            class_2960 riverKey = class_5458.field_25933.method_10221((Object)biomeData.getRiverBiome());
            if (riverKey != null) {
                object.addProperty("river", riverKey.toString());
            } else {
                object.addProperty("river", "");
            }
            class_2960 beachKey = class_5458.field_25933.method_10221((Object)biomeData.getBeachBiome());
            if (beachKey != null) {
                object.addProperty("beach", beachKey.toString());
            } else {
                object.addProperty("beach", "");
            }
            class_2960 edgeKey = class_5458.field_25933.method_10221((Object)biomeData.getEdgeBiome());
            if (edgeKey != null) {
                object.addProperty("edge", edgeKey.toString());
            } else {
                object.addProperty("edge", "");
            }
            class_2960 location = class_5458.field_25933.method_10221((Object)biomeData.getBiome());
            if (location != null) {
                biomeObject.add(location.toString(), (JsonElement)object);
                continue;
            }
            BYG.LOGGER.error("The Biome key was null! This should NEVER happen.");
        }
        biomes.add("sub-biomes", (JsonElement)biomeObject);
        return biomes;
    }

    public SubBiomeDataListHolder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BYG.LOGGER.info("Reading Sub-Biomes json");
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayList<SubBiomeData> biomeData = new ArrayList<SubBiomeData>();
        Set entrySet = jsonObject.get("sub-biomes").getAsJsonObject().entrySet();
        for (Map.Entry elementEntry : entrySet) {
            String biomeName = (String)elementEntry.getKey();
            JsonElement element = (JsonElement)elementEntry.getValue();
            JsonObject elementObject = element.getAsJsonObject();
            String edge = elementObject.get("edge").getAsString();
            String river = elementObject.get("river").getAsString();
            String beach = elementObject.get("beach").getAsString();
            class_2960 biomeKey = new class_2960(biomeName);
            if (class_5458.field_25933.method_10235().contains(biomeKey)) {
                if (biomeKey.method_12836().equals("byg")) {
                    biomeData.add(new SubBiomeData((class_1959)class_5458.field_25933.method_10223(biomeKey), (class_1959)class_5458.field_25933.method_10223(new class_2960(edge)), (class_1959)class_5458.field_25933.method_10223(new class_2960(beach)), (class_1959)class_5458.field_25933.method_10223(new class_2960(river))));
                    continue;
                }
                BYG.LOGGER.error("Biome key: \"" + biomeName + "\" is illegal. The mod id for the biome key MUST be \"byg\". Skipping entry...");
                continue;
            }
            BYG.LOGGER.error("The biome key: \"" + biomeName + "\" was not found in the registry, skipping entry...");
        }
        return new SubBiomeDataListHolder(biomeData);
    }
}

