/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.server.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3504;
import net.minecraft.class_3828;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5497;

public class GenDataCommand {
    public static void dataGenCommand(CommandDispatcher<class_2168> dispatcher) {
        String commandString = "gendata";
        ArrayList modIdList = new ArrayList();
        FabricLoader.getInstance().getAllMods().forEach(modContainer -> {
            String modId = modContainer.getMetadata().getId();
            if (!modId.contains("fabric")) {
                modIdList.add(modId);
            }
        });
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)commandString).then(class_2170.method_9244((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> class_2172.method_9264(modIdList.stream(), (SuggestionsBuilder)sb)).executes(cs -> {
            GenDataCommand.createBiomeDatapack((String)cs.getArgument("modid", String.class), (CommandContext<class_2168>)cs);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)commandString).redirect((CommandNode)source));
    }

    public static void createBiomeDatapack(String modId, CommandContext<class_2168> commandSource) {
        ArrayList<class_1959> biomeList = new ArrayList<class_1959>();
        boolean stopSpamFlag = false;
        Path dataPackPath = GenDataCommand.dataPackPath(((class_2168)commandSource.getSource()).method_9225().method_8503().method_27050(class_5218.field_24186), modId);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        class_5455 manager = ((class_2168)commandSource.getSource()).method_9211().method_30611();
        class_2385 biomeRegistry = manager.method_30530(class_2378.field_25114);
        class_2385 featuresRegistry = manager.method_30530(class_2378.field_25914);
        class_2385 structuresRegistry = manager.method_30530(class_2378.field_25915);
        class_2385 carverRegistry = manager.method_30530(class_2378.field_25913);
        class_2385 surfaceBuilderRegistry = manager.method_30530(class_2378.field_25912);
        class_2385 structureProcessorRegistry = manager.method_30530(class_2378.field_25916);
        GenDataCommand.createConfiguredSurfaceBuilderJson(modId, dataPackPath, gson, surfaceBuilderRegistry);
        GenDataCommand.createConfiguredFeatureJson(modId, dataPackPath, gson, featuresRegistry);
        GenDataCommand.createConfiguredCarverJson(modId, dataPackPath, gson, carverRegistry);
        GenDataCommand.createConfiguredStructureJson(modId, dataPackPath, gson, structuresRegistry);
        GenDataCommand.createProcessorListJson(modId, dataPackPath, gson, (class_2378<class_5497>)structureProcessorRegistry);
        GenDataCommand.createBiomeJsonAndPackMcMeta(modId, commandSource, biomeList, stopSpamFlag, dataPackPath, gson, (class_2378<class_1959>)biomeRegistry, featuresRegistry, structuresRegistry, carverRegistry, surfaceBuilderRegistry);
    }

    private static void createBiomeJsonAndPackMcMeta(String modId, CommandContext<class_2168> commandSource, List<class_1959> biomeList, boolean stopSpamFlag, Path dataPackPath, Gson gson, class_2378<class_1959> biomeRegistry, class_2378<class_2975<?, ?>> featuresRegistry, class_2378<class_5312<?, ?>> structuresRegistry, class_2378<class_2922<?>> carverRegistry, class_2378<class_3504<?>> surfaceBuilderRegistry) {
        for (Map.Entry entry : biomeRegistry.method_29722()) {
            String biomeKey = ((class_5321)Objects.requireNonNull(biomeRegistry.method_29113(entry.getValue())).get()).method_29177().toString();
            if (!biomeKey.contains(modId)) continue;
            biomeList.add((class_1959)entry.getValue());
        }
        if (biomeList.size() > 0) {
            for (class_1959 class_19592 : biomeList) {
                class_2960 key = biomeRegistry.method_10221((Object)class_19592);
                if (key == null) continue;
                Path biomeJsonPath = GenDataCommand.biomeJsonPath(dataPackPath, key, modId);
                Function biomeCodec = JsonOps.INSTANCE.withEncoder((Encoder)class_1959.field_24677);
                try {
                    Files.createDirectories(biomeJsonPath.getParent(), new FileAttribute[0]);
                    Optional optional = ((DataResult)biomeCodec.apply(() -> class_19592)).result();
                    if (!optional.isPresent()) continue;
                    JsonElement root = (JsonElement)optional.get();
                    JsonArray features = new JsonArray();
                    for (List list : class_19592.method_30970().method_30983()) {
                        class_2893.class_2894[] stage = new JsonArray();
                        for (Supplier feature : list) {
                            featuresRegistry.method_29113(feature.get()).ifPresent(arg_0 -> GenDataCommand.lambda$createBiomeJsonAndPackMcMeta$4((JsonArray)stage, arg_0));
                        }
                        features.add((JsonElement)stage);
                    }
                    root.getAsJsonObject().add("features", (JsonElement)features);
                    String surfaceBuilder = ((class_5321)surfaceBuilderRegistry.method_29113(class_19592.method_30970().method_30984().get()).get()).method_29177().toString();
                    root.getAsJsonObject().addProperty("surface_builder", surfaceBuilder);
                    JsonObject carvers = new JsonObject();
                    for (class_2893.class_2894 step : class_2893.class_2894.values()) {
                        JsonArray stage = new JsonArray();
                        for (Supplier carver : class_19592.method_30970().method_30976(step)) {
                            carverRegistry.method_29113(carver.get()).ifPresent(carverKey -> stage.add(carverKey.method_29177().toString()));
                        }
                        if (stage.size() <= 0) continue;
                        carvers.add(step.method_15434(), (JsonElement)stage);
                    }
                    root.getAsJsonObject().add("carvers", (JsonElement)carvers);
                    JsonArray starts = new JsonArray();
                    for (Supplier start : class_19592.method_30970().method_30975()) {
                        structuresRegistry.method_29113(start.get()).ifPresent(structureKey -> starts.add(structureKey.method_29177().toString()));
                    }
                    root.getAsJsonObject().add("starts", (JsonElement)starts);
                    Files.write(biomeJsonPath, gson.toJson(root).getBytes(), new OpenOption[0]);
                }
                catch (IOException e) {
                    if (stopSpamFlag) continue;
                    ((class_2168)commandSource.getSource()).method_9226((class_2561)new class_2588("commands.gendata.failed", new Object[]{modId}).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1061))), false);
                    stopSpamFlag = true;
                }
            }
            try {
                GenDataCommand.createPackMCMeta(dataPackPath, modId);
            }
            catch (IOException e) {
                ((class_2168)commandSource.getSource()).method_9226((class_2561)new class_2588("commands.gendata.mcmeta.failed", new Object[]{modId}).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1061))), false);
            }
            class_5250 filePathText = new class_2585(dataPackPath.toString()).method_27692(class_124.field_1073).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1060)).method_10958(new class_2558(class_2558.class_2559.field_11746, dataPackPath.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2588("commands.gendata.hovertext"))));
            ((class_2168)commandSource.getSource()).method_9226((class_2561)new class_2588("commands.gendata.success", new Object[]{commandSource.getArgument("modid", String.class), filePathText}), false);
        } else {
            ((class_2168)commandSource.getSource()).method_9226((class_2561)new class_2588("commands.gendata.listisempty", new Object[]{modId}).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1061))), false);
        }
    }

    private static void createConfiguredFeatureJson(String modId, Path dataPackPath, Gson gson, class_2378<class_2975<?, ?>> featuresRegistry) {
        for (Map.Entry feature : featuresRegistry.method_29722()) {
            Optional optional;
            Function featureCodec = JsonOps.INSTANCE.withEncoder((Encoder)class_2975.field_24833);
            class_2975 configuredFeature = (class_2975)feature.getValue();
            if (!((class_5321)feature.getKey()).method_29177().toString().contains(modId) || configuredFeature == null || !Objects.requireNonNull(featuresRegistry.method_29113((Object)configuredFeature)).toString().contains(modId) || !(optional = ((DataResult)featureCodec.apply(() -> configuredFeature)).result()).isPresent()) continue;
            try {
                Path cfPath = GenDataCommand.configuredFeatureJsonPath(dataPackPath, Objects.requireNonNull(featuresRegistry.method_10221((Object)configuredFeature)), modId);
                Files.createDirectories(cfPath.getParent(), new FileAttribute[0]);
                Files.write(cfPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static void createConfiguredSurfaceBuilderJson(String modId, Path dataPackPath, Gson gson, class_2378<class_3504<?>> surfaceBuildersRegistry) {
        for (Map.Entry surfaceBuilder : surfaceBuildersRegistry.method_29722()) {
            Optional optional;
            Function surfaceBuilderCodec = JsonOps.INSTANCE.withEncoder((Encoder)class_3504.field_25015);
            class_3504 configuredSurfaceBuilder = (class_3504)surfaceBuilder.getValue();
            if (!((class_5321)surfaceBuilder.getKey()).method_29177().toString().contains(modId) || configuredSurfaceBuilder == null || !Objects.requireNonNull(surfaceBuildersRegistry.method_29113((Object)configuredSurfaceBuilder)).toString().contains(modId) || !(optional = ((DataResult)surfaceBuilderCodec.apply(() -> configuredSurfaceBuilder)).result()).isPresent()) continue;
            try {
                Path sbPath = GenDataCommand.configuredSurfaceBuilderJsonPath(dataPackPath, Objects.requireNonNull(surfaceBuildersRegistry.method_10221((Object)configuredSurfaceBuilder)), modId);
                Files.createDirectories(sbPath.getParent(), new FileAttribute[0]);
                Files.write(sbPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static void createConfiguredCarverJson(String modId, Path dataPackPath, Gson gson, class_2378<class_2922<?>> carverRegistry) {
        for (Map.Entry carver : carverRegistry.method_29722()) {
            Optional optional;
            Function carverCodec = JsonOps.INSTANCE.withEncoder((Encoder)class_2922.field_24828);
            class_2922 configuredCarver = (class_2922)carver.getValue();
            if (!((class_5321)carver.getKey()).method_29177().toString().contains(modId) || configuredCarver == null || !Objects.requireNonNull(carverRegistry.method_29113((Object)configuredCarver)).toString().contains(modId) || !(optional = ((DataResult)carverCodec.apply(() -> configuredCarver)).result()).isPresent()) continue;
            try {
                Path carverPath = GenDataCommand.configuredCarverJsonPath(dataPackPath, Objects.requireNonNull(carverRegistry.method_10221((Object)configuredCarver)), modId);
                Files.createDirectories(carverPath.getParent(), new FileAttribute[0]);
                Files.write(carverPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static void createConfiguredStructureJson(String modId, Path dataPackPath, Gson gson, class_2378<class_5312<?, ?>> structureRegistry) {
        for (Map.Entry structure : structureRegistry.method_29722()) {
            Optional optional;
            Function structureCodec = JsonOps.INSTANCE.withEncoder((Encoder)class_5312.field_24834);
            class_5312 configuredStructure = (class_5312)structure.getValue();
            if (!((class_5321)structure.getKey()).method_29177().toString().contains(modId) || configuredStructure == null || !Objects.requireNonNull(structureRegistry.method_29113((Object)configuredStructure)).toString().contains(modId) || !(optional = ((DataResult)structureCodec.apply(() -> configuredStructure)).result()).isPresent()) continue;
            try {
                Path structurePath = GenDataCommand.configuredStructureFeatureJsonPath(dataPackPath, Objects.requireNonNull(structureRegistry.method_10221((Object)configuredStructure)), modId);
                Files.createDirectories(structurePath.getParent(), new FileAttribute[0]);
                Files.write(structurePath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static void createProcessorListJson(String modId, Path dataPackPath, Gson gson, class_2378<class_5497> structureProcessorRegistry) {
        for (Map.Entry processor : structureProcessorRegistry.method_29722()) {
            Optional optional;
            Function processorCodec = JsonOps.INSTANCE.withEncoder((Encoder)class_3828.field_25877);
            class_5497 processorList = (class_5497)processor.getValue();
            if (!((class_5321)processor.getKey()).method_29177().toString().contains(modId) || processorList == null || !Objects.requireNonNull(structureProcessorRegistry.method_29113((Object)processorList)).toString().contains(modId) || !(optional = ((DataResult)processorCodec.apply(() -> processorList)).result()).isPresent()) continue;
            try {
                Path processorListPath = GenDataCommand.configuredProceesorListPath(dataPackPath, Objects.requireNonNull(structureProcessorRegistry.method_10221((Object)processorList)), modId);
                Files.createDirectories(processorListPath.getParent(), new FileAttribute[0]);
                Files.write(processorListPath, gson.toJson((JsonElement)optional.get()).getBytes(), new OpenOption[0]);
            }
            catch (IOException iOException) {}
        }
    }

    private static Path configuredFeatureJsonPath(Path path, class_2960 identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/configured_feature/" + identifier.method_12832() + ".json");
    }

    private static Path configuredSurfaceBuilderJsonPath(Path path, class_2960 identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/configured_surface_builder/" + identifier.method_12832() + ".json");
    }

    private static Path configuredCarverJsonPath(Path path, class_2960 identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/configured_carver/" + identifier.method_12832() + ".json");
    }

    private static Path configuredStructureFeatureJsonPath(Path path, class_2960 identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/configured_structure_feature/" + identifier.method_12832() + ".json");
    }

    private static Path configuredProceesorListPath(Path path, class_2960 identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/processor_list/" + identifier.method_12832() + ".json");
    }

    private static Path biomeJsonPath(Path path, class_2960 identifier, String modId) {
        return path.resolve("data/" + modId + "/worldgen/biome/" + identifier.method_12832() + ".json");
    }

    private static Path dataPackPath(Path path, String modId) {
        return path.resolve("gendata/" + modId + "-custom");
    }

    private static void createPackMCMeta(Path dataPackPath, String modID) throws IOException {
        String fileString = "{\n\t\"pack\":{\n\t\t\"pack_format\": 6,\n\t\t\"description\": \"Custom biome datapack for " + modID + ".\"\n\t}\n}\n";
        Files.write(dataPackPath.resolve("pack.mcmeta"), fileString.getBytes(), new OpenOption[0]);
    }

    private static /* synthetic */ void lambda$createBiomeJsonAndPackMcMeta$4(JsonArray stage, class_5321 featureKey) {
        stage.add(featureKey.method_29177().toString());
    }
}

