/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg;

import com.mojang.brigadier.CommandDispatcher;
import corgiaoc.byg.client.textures.renders.BYGCutoutRenders;
import corgiaoc.byg.common.entity.boat.BYGBoatRenderer;
import corgiaoc.byg.common.entity.villager.BYGVillagerType;
import corgiaoc.byg.common.properties.BYGCreativeTab;
import corgiaoc.byg.common.properties.vanilla.BYGCarvableBlocks;
import corgiaoc.byg.common.properties.vanilla.BYGCompostables;
import corgiaoc.byg.common.properties.vanilla.BYGFlammables;
import corgiaoc.byg.common.properties.vanilla.BYGHoeables;
import corgiaoc.byg.common.properties.vanilla.BYGPaths;
import corgiaoc.byg.common.properties.vanilla.BYGStrippables;
import corgiaoc.byg.common.world.BYGWorldTypeThatIsntAWorldtype;
import corgiaoc.byg.common.world.dimension.end.BYGEndBiomeProvider;
import corgiaoc.byg.common.world.dimension.nether.BYGNetherBiomeProvider;
import corgiaoc.byg.common.world.feature.blockplacer.BYGBlockPlacerTypes;
import corgiaoc.byg.config.BYGWorldConfig;
import corgiaoc.byg.config.json.BYGJsonConfigHandler;
import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.core.BYGEntities;
import corgiaoc.byg.core.BYGItems;
import corgiaoc.byg.core.world.BYGBiomes;
import corgiaoc.byg.core.world.BYGDecorators;
import corgiaoc.byg.core.world.BYGFeatures;
import corgiaoc.byg.core.world.BYGStructures;
import corgiaoc.byg.core.world.BYGSurfaceBuilders;
import corgiaoc.byg.server.command.GenDataCommand;
import java.io.File;
import java.nio.file.Path;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockplacer.BlockPlacerType;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="byg")
public class BYG {
    public static final String MOD_ID = "byg";
    public static boolean isClient = false;
    public static Logger LOGGER = LogManager.getLogger();
    public static boolean isUsingMixin;
    public static String FILE_PATH;
    public static final Path CONFIG_PATH;
    public static Registry<Biome> EARLY_BIOME_REGISTRY_ACCESS;

    public BYG() {
        File dir = new File(CONFIG_PATH.toString());
        if (!dir.exists()) {
            dir.mkdir();
        }
        BYGWorldConfig.loadConfig(BYGWorldConfig.COMMON_CONFIG, CONFIG_PATH.resolve("byg-world.toml"));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEvents());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.debug("BYG: \"Common Setup\" Event Starting...");
        BYGCreativeTab.init();
        BYGJsonConfigHandler.handleOverWorldConfig(CONFIG_PATH);
        event.enqueueWork(() -> {
            Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation(MOD_ID, "bygnether"), BYGNetherBiomeProvider.BYGNETHERCODEC);
            Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation(MOD_ID, "bygend"), BYGEndBiomeProvider.BYGENDCODEC);
            BYGVillagerType.setVillagerForBYGBiomes();
            BYGBiomes.addBiomeEntries();
            BYGBiomes.fillBiomeDictionary();
        });
        LOGGER.info("BYG: \"Common Setup\" Event Complete!");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        isClient = true;
        LOGGER.debug("BYG: \"Client Setup\" Event Starting...");
        BYGCutoutRenders.renderCutOuts();
        RenderingRegistry.registerEntityRenderingHandler(BYGEntities.BOAT, BYGBoatRenderer::new);
        LOGGER.info("BYG: \"Client Setup\" Event Complete!");
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            LOGGER.debug("BYG: \"Load Complete Event\" Starting...");
            BYGCompostables.compostablesBYG();
            BYGHoeables.hoeablesBYG();
            BYGFlammables.flammablesBYG();
            BYGStrippables.strippableLogsBYG();
            BYGCarvableBlocks.addCarverBlocks();
            BYGPaths.addBYGPaths();
            BYG.cleanMemory();
            LOGGER.info("BYG: \"Load Complete\" Event Complete!");
        });
    }

    private static void cleanMemory() {
        LOGGER.debug("Cleaning memory...");
        BYGBlocks.flowerPotBlocks = null;
        FILE_PATH = null;
        LOGGER.debug("Cleaned memory!");
    }

    static {
        FILE_PATH = "yeet";
        CONFIG_PATH = new File(String.valueOf(FMLPaths.CONFIGDIR.get().resolve(MOD_ID))).toPath();
        EARLY_BIOME_REGISTRY_ACCESS = null;
    }

    public static class ForgeEvents {
        @SubscribeEvent
        public void commandRegisterEvent(FMLServerStartingEvent event) {
            LOGGER.debug("BYG: \"Server Starting\" Event Starting...");
            GenDataCommand.dataGenCommand((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
            LOGGER.info("BYG: \"Server Starting\" Event Complete!");
        }
    }

    @Mod.EventBusSubscriber(modid="byg", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class BYGWorldGenRegistries {
        @SubscribeEvent
        public static void registerBiomes(RegistryEvent.Register<Biome> event) {
            LOGGER.debug("BYG: Registering biomes...");
            BYGBiomes.init();
            BYGBiomes.biomeList.sort(Comparator.comparingInt(BYGBiomes.PreserveBiomeOrder::getOrderPosition));
            BYGBiomes.biomeList.forEach(preserveBiomeOrder -> event.getRegistry().register((IForgeRegistryEntry)preserveBiomeOrder.getBiome()));
            BYGBiomes.CANYON_KEY = BYGBiomes.CANYON.getKey();
            LOGGER.info("BYG: Biomes registered!");
        }

        @SubscribeEvent
        public static void registerDecorators(RegistryEvent.Register<Placement<?>> event) {
            LOGGER.debug("BYG: Registering decorators...");
            BYGDecorators.init();
            BYGDecorators.decorators.forEach(decorator -> event.getRegistry().register((IForgeRegistryEntry)decorator));
            LOGGER.info("BYG: Decorators registered!");
        }

        @SubscribeEvent
        public static void registerStructures(RegistryEvent.Register<Structure<?>> event) {
            LOGGER.debug("BYG: Registering structures...");
            BYGStructures.init();
            LOGGER.info("BYG: Structures registered!");
        }

        @SubscribeEvent
        public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            LOGGER.debug("BYG: Registering features...");
            OreFeatureConfig.FillerBlockType.field_241883_b = new TagMatchRuleTest((ITag)BlockTags.field_242173_aI);
            BYGFeatures.init();
            BYGFeatures.features.forEach(feature -> event.getRegistry().register((IForgeRegistryEntry)feature));
            LOGGER.info("BYG: Features registered!");
        }

        @SubscribeEvent
        public static void registerSurfaceBuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
            LOGGER.debug("BYG: Registering surface builders...");
            BYGSurfaceBuilders.init();
            BYGSurfaceBuilders.surfaceBuilders.forEach(surfaceBuilder -> event.getRegistry().register((IForgeRegistryEntry)surfaceBuilder));
            LOGGER.info("BYG: Surface builders Registered!");
        }

        @SubscribeEvent
        public static void registerBlockPlacerType(RegistryEvent.Register<BlockPlacerType<?>> event) {
            LOGGER.debug("BYG: Registering block placer types...");
            BYGBlockPlacerTypes.init();
            BYGBlockPlacerTypes.types.forEach(type -> event.getRegistry().register((IForgeRegistryEntry)type));
            LOGGER.info("BYG: Registering block placer types!");
        }

        @SubscribeEvent
        public static void registerWorldtype(RegistryEvent.Register<ForgeWorldType> event) {
            event.getRegistry().register(new BYGWorldTypeThatIsntAWorldtype().setRegistryName(new ResourceLocation(BYG.MOD_ID, "world")));
        }
    }

    @Mod.EventBusSubscriber(modid="byg", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class BYGRegistries {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            LOGGER.debug("BYG: Registering blocks...");
            BYGBlocks.init();
            BYGBlocks.blocksList.forEach(block -> event.getRegistry().register((IForgeRegistryEntry)block));
            BYGBlocks.flowerPotBlocks.forEach(block -> event.getRegistry().register((IForgeRegistryEntry)block));
            LOGGER.info("BYG: Blocks registered!");
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            LOGGER.debug("BYG: Registering items...");
            BYGItems.init();
            BYGItems.itemsList.forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
            LOGGER.info("BYG: Items registered!");
        }

        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            LOGGER.debug("BYG: Registering entities...");
            BYGEntities.init();
            BYGEntities.entities.forEach(entityType -> event.getRegistry().register((IForgeRegistryEntry)entityType));
            LOGGER.info("BYG: Entities registered!");
        }
    }
}

