/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.NoisySphereConfig;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class NoisyCaveSphere
extends Feature<NoisySphereConfig> {
    protected static FastNoise fastNoise;
    protected long seed;

    public NoisyCaveSphere(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoisySphereConfig config) {
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position.func_177979_c(2 + random.nextInt(10)));
        BlockPos.Mutable mutable2 = new BlockPos.Mutable().func_189533_g((Vector3i)mutable);
        int stackHeight = random.nextInt(config.getMaxPossibleHeight()) + config.getMinHeight();
        int xRadius = config.getRandomXRadius(random);
        int yRadius = config.getRandomYRadius(random);
        int zRadius = config.getRandomZRadius(random);
        for (int stackIDX = 0; stackIDX < stackHeight; ++stackIDX) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                for (int z = -zRadius; z <= zRadius; ++z) {
                    for (int y = -yRadius; y <= yRadius; ++y) {
                        mutable2.func_189533_g((Vector3i)mutable).func_196234_d(x, y, z);
                        IChunk chunk = world.func_217349_x((BlockPos)mutable2);
                        double equationResult = Math.pow(x, 2.0) / Math.pow(xRadius, 2.0) + Math.pow(y, 2.0) / Math.pow(yRadius, 2.0) + Math.pow(z, 2.0) / Math.pow(zRadius, 2.0);
                        double threshold = 1.0 + 0.7 * (double)fastNoise.GetNoise(mutable2.func_177958_n(), mutable2.func_177956_o(), mutable2.func_177952_p());
                        if (equationResult >= threshold || !world.func_180495_p((BlockPos)mutable2).func_200132_m()) continue;
                        int bitIndex = mutable2.func_177958_n() & 0xF | (mutable2.func_177952_p() & 0xF) << 4 | mutable2.func_177956_o() << 8;
                        if (mutable2.func_177956_o() <= 25) {
                            boolean isSolidAllAround = true;
                            for (Direction direction : Direction.values()) {
                                BlockState blockState;
                                if (direction == Direction.UP || (blockState = world.func_180495_p(mutable2.func_177972_a(direction))).func_185904_a() == Material.field_151587_i || blockState.func_200132_m()) continue;
                                isSolidAllAround = false;
                                break;
                            }
                            if (!isSolidAllAround) continue;
                            world.func_180501_a((BlockPos)mutable2, Blocks.field_150353_l.func_176223_P(), 2);
                            world.func_205219_F_().func_205360_a((BlockPos)mutable2, (Object)Fluids.field_204547_b, 0);
                            continue;
                        }
                        world.func_180501_a((BlockPos)mutable2, config.getBlockProvider().func_225574_a_(random, (BlockPos)mutable2), 2);
                    }
                    xRadius = (int)((double)xRadius / config.getRadiusDivisorPerStack());
                    yRadius = (int)((double)yRadius / config.getRadiusDivisorPerStack());
                    zRadius = (int)((double)zRadius / config.getRadiusDivisorPerStack());
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            fastNoise.SetFrequency(0.09f);
            this.seed = seed;
        }
    }
}

