/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.river;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.NoisyCaveSphereWater;
import corgiaoc.byg.common.world.feature.overworld.river.CanyonCache;
import corgiaoc.byg.common.world.feature.overworld.river.MegaChunk;
import corgiaoc.byg.common.world.feature.overworld.river.MegaChunkPos;
import corgiaoc.byg.common.world.feature.overworld.river.RiverGenerator;
import corgiaoc.byg.core.world.BYGBiomes;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CanyonRiverWorldGenerator
extends Feature<NoFeatureConfig> {
    private static final int MAX_RIVER_DISTANCE = 512;
    private static final int MAX_RIVER_DISTANCE_IN_MEGA_CHUNKS = -Math.floorDiv(-512, 256);
    private static long seed;
    private final Map<World, CanyonCache> worldToCanyonPoint = new WeakHashMap<World, CanyonCache>();
    public static FastNoise noise;

    public CanyonRiverWorldGenerator(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(ISeedReader worldRegion, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        CanyonRiverWorldGenerator.setupNoise(worldRegion.func_72905_C());
        NoisyCaveSphereWater.setSeed(worldRegion.func_72905_C());
        IChunk chunk = worldRegion.func_217349_x(pos);
        ChunkPos chunkPos = chunk.func_76632_l();
        CanyonCache canyonCache = this.worldToCanyonPoint.computeIfAbsent((World)worldRegion.func_201672_e(), world -> new CanyonCache(worldRegion.func_201672_e().func_72863_F().field_186029_c, Collections.singleton(worldRegion.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230516_a_(BYGBiomes.CANYON_KEY))));
        for (int xMegaScan = -MAX_RIVER_DISTANCE_IN_MEGA_CHUNKS; xMegaScan <= MAX_RIVER_DISTANCE_IN_MEGA_CHUNKS; ++xMegaScan) {
            for (int zMegaScan = -MAX_RIVER_DISTANCE_IN_MEGA_CHUNKS; zMegaScan <= MAX_RIVER_DISTANCE_IN_MEGA_CHUNKS; ++zMegaScan) {
                MegaChunkPos megaChunkPos = MegaChunkPos.fromBlockPos(pos).add(xMegaScan, zMegaScan);
                MegaChunk megaChunk = canyonCache.getMegaChunk(megaChunkPos);
                int count = megaChunk.getCount();
                if (count == 0) continue;
                RiverGenerator riverGenerator = megaChunk.getRiverGenerator();
                if (riverGenerator == null) {
                    if (!this.isMegaChunkWithMostCanyonChunks(megaChunk, canyonCache)) continue;
                    megaChunk.createRiverGeneratorStart(noise, worldRegion, worldRegion.func_72905_C(), 512);
                    riverGenerator = megaChunk.getRiverGenerator();
                }
                if (!riverGenerator.exists() || !riverGenerator.getNodeChunkPositions().contains(chunkPos)) continue;
                this.generateForChunk(worldRegion, chunkPos, riverGenerator);
            }
        }
        return true;
    }

    private void generateForChunk(ISeedReader worldRegion, ChunkPos chunkPos, RiverGenerator riverGenerator) {
        List<RiverGenerator.Node> nodes = riverGenerator.getNodesForChunk(chunkPos);
        for (int idx = 0; idx < nodes.size(); ++idx) {
            RiverGenerator.Node node = nodes.get(idx);
            RiverGenerator.Node prevNode = idx == 0 ? riverGenerator.getNodes().get(nodes.get(0).getIdx() - 1) : nodes.get(idx - 1);
            this.carveRiverNode(worldRegion, node, prevNode, riverGenerator);
        }
    }

    private void carveRiverNode(ISeedReader worldRegion, RiverGenerator.Node node, RiverGenerator.Node prevNode, RiverGenerator riverGenerator) {
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)node.getPos());
        BlockPos.Mutable prevMutable = new BlockPos.Mutable().func_189533_g((Vector3i)prevNode.getPos());
        int xRadius = 10;
        int yRadius = 10;
        int zRadius = 10;
        int minXRadius = -xRadius;
        int minZRadius = -zRadius;
        int maxXRadius = xRadius;
        int maxZRadius = zRadius;
        int xDiff = mutable.func_177958_n() - prevMutable.func_177958_n();
        int zDiff = mutable.func_177952_p() - prevMutable.func_177952_p();
        if (xDiff > 0) {
            maxXRadius += xDiff;
        }
        if (zDiff > 0) {
            maxZRadius += zDiff;
        }
        if (xDiff < 0) {
            minXRadius += xDiff;
        }
        if (zDiff < 0) {
            minZRadius += zDiff;
        }
        BlockPos.Mutable mutable2 = new BlockPos.Mutable().func_189533_g((Vector3i)mutable);
        int yDiff = prevMutable.func_177956_o() - mutable.func_177956_o();
        for (int x = minXRadius; x <= maxXRadius; ++x) {
            for (int z = minZRadius; z <= maxZRadius; ++z) {
                mutable2.func_189533_g((Vector3i)mutable).func_196234_d(x, -yRadius, z);
                int height = worldRegion.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, mutable2.func_177958_n(), mutable2.func_177952_p());
                if (height <= mutable2.func_177956_o() || yDiff >= 10 && height >= mutable2.func_177956_o()) continue;
                for (int y = -yRadius; y <= yRadius; ++y) {
                    mutable2.func_189533_g((Vector3i)mutable).func_196234_d(x, y, z);
                    double equationResult = Math.pow(x, 2.0) / Math.pow(xRadius, 2.0) + Math.pow(y, 2.0) / Math.pow(yRadius, 2.0) + Math.pow(z, 2.0) / Math.pow(zRadius, 2.0);
                    double threshold = 1.0 + 0.7 * (double)NoisyCaveSphereWater.fastNoise.GetNoise(mutable2.func_177958_n(), mutable2.func_177956_o(), mutable2.func_177952_p());
                    if (equationResult >= threshold) continue;
                    int sphereWaterY = -2;
                    if (node.getIdx() >= riverGenerator.getTotalNumberOfNodes() - 4) {
                        // empty if block
                    }
                    if (y <= sphereWaterY) {
                        worldRegion.func_180501_a((BlockPos)mutable2, Blocks.field_150355_j.func_176223_P(), 2);
                        worldRegion.func_205219_F_().func_205360_a((BlockPos)mutable2, (Object)Fluids.field_204546_a, 0);
                        continue;
                    }
                    worldRegion.func_180501_a((BlockPos)mutable2, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
    }

    public boolean isMegaChunkWithMostCanyonChunks(MegaChunk megaChunk, CanyonCache canyonCache) {
        for (int xNeighborScan = -1; xNeighborScan <= 1; ++xNeighborScan) {
            for (int zNeighborScan = -1; zNeighborScan <= 1; ++zNeighborScan) {
                MegaChunkPos neighbor;
                MegaChunk neighborMegaChunk;
                if (xNeighborScan == 0 && zNeighborScan == 0 || (neighborMegaChunk = canyonCache.getMegaChunk(neighbor = megaChunk.getMegaChunkPos().add(xNeighborScan, zNeighborScan))).getCount() < megaChunk.getCount()) continue;
                return false;
            }
        }
        return true;
    }

    public static void setupNoise(long serverSeed) {
        if (seed != serverSeed || noise == null) {
            seed = serverSeed;
            noise = new FastNoise((int)seed);
            noise.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
            noise.SetGradientPerturbAmp(1.0f);
            noise.SetFractalOctaves(5);
            noise.SetFractalGain(0.5f);
            noise.SetFrequency(0.015999999f);
        }
    }
}

