/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.trees.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.FeatureUtil;
import corgiaoc.byg.common.world.feature.config.BYGTreeConfig;
import corgiaoc.byg.common.world.feature.overworld.trees.util.SaplingData;
import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.Tags;

public abstract class BYGAbstractTreeFeature<TFC extends BYGTreeConfig>
extends Feature<TFC> {
    protected static FastNoise fastNoise;
    protected long seed;
    public static final Map<Block, Block> SPREADABLE_TO_NON_SPREADABLE;

    public BYGAbstractTreeFeature(Codec<TFC> configCodec) {
        super(configCodec);
    }

    public static boolean canLogPlaceHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> state.func_185904_a() == Material.field_151579_a || state.func_185904_a() == Material.field_151586_h) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean canLogPlaceHereWater(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> state.func_185904_a() == Material.field_151579_a || state.func_185904_a() == Material.field_151586_h) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean canLogPlaceHereNether(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> state.func_185904_a() == Material.field_151579_a || state.func_185904_a() == Material.field_151586_h || state.func_185904_a() == Material.field_151587_i) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean isAnotherTreeHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_206952_E);
        });
    }

    public boolean isAnotherTreeLikeThisHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos, Block logBlock, Block leafBlock) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block == logBlock || block == leafBlock;
        });
    }

    public void placeTrunk(BYGTreeConfig config, Random random, Set<BlockPos> blockSet, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (BYGAbstractTreeFeature.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(blockSet, (IWorldWriter)reader, pos, config.getTrunkProvider().func_225574_a_(random, pos), boundingBox);
        }
    }

    public void placeBranch(BYGTreeConfig config, Random random, Set<BlockPos> blockSet, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (BYGAbstractTreeFeature.canLogPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(blockSet, (IWorldWriter)reader, pos, config.getTrunkProvider().func_225574_a_(random, pos), boundingBox);
        }
    }

    public void placeLeaves(BYGTreeConfig config, Random random, Set<BlockPos> blockSet, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (BYGAbstractTreeFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(blockSet, (IWorldWriter)reader, pos, config.getLeavesProvider().func_225574_a_(random, pos), boundingBox);
        }
    }

    public void placeLeaves(BYGTreeConfig config, Random random, ISeedReader reader, int x, int y, int z, MutableBoundingBox boundingBox, Set<BlockPos> blockPos) {
        BlockPos pos = new BlockPos(x, y, z);
        if (BYGAbstractTreeFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(blockPos, (IWorldWriter)reader, pos, config.getLeavesProvider().func_225574_a_(random, pos), boundingBox);
        }
    }

    public void placeNetherTrunk(BYGTreeConfig config, Random random, Set<BlockPos> blockSet, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (this.canLogPlaceHereNether((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(blockSet, (IWorldWriter)reader, pos, config.getTrunkProvider().func_225574_a_(random, pos), boundingBox);
        }
    }

    public void placeNetherBranch(BYGTreeConfig config, Random random, Set<BlockPos> blockSet, ISeedReader reader, BlockPos pos, MutableBoundingBox boundingBox) {
        if (this.canLogPlaceHereNether((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState(blockSet, (IWorldWriter)reader, pos, config.getTrunkProvider().func_225574_a_(random, pos), boundingBox);
        }
    }

    public boolean canSaplingGrowHere(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_206952_E) || state.func_196958_f() || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l || state.func_185904_a() == Material.field_203243_f || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151578_c;
        });
    }

    public static boolean isAir(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
    }

    public boolean isAirOrWater(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_177230_c() == Blocks.field_150355_j);
    }

    public static boolean isDesiredGroundwDirtTag(IWorldGenerationBaseReader reader, BlockPos pos, BYGTreeConfig config) {
        if (config.isPlacementForced()) {
            return true;
        }
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            Iterator<Block> iterator = config.getWhitelist().iterator();
            if (iterator.hasNext()) {
                Block block1 = iterator.next();
                return block.func_203417_a((ITag)Tags.Blocks.DIRT) || block == block1;
            }
            return block.func_203417_a((ITag)Tags.Blocks.DIRT);
        });
    }

    public static boolean isDesiredGroundwNetherTags(IWorldGenerationBaseReader reader, BlockPos pos, BYGTreeConfig config) {
        if (config.isPlacementForced()) {
            return true;
        }
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            Iterator<Block> iterator = config.getWhitelist().iterator();
            if (iterator.hasNext()) {
                Block block1 = iterator.next();
                return block.func_203417_a((ITag)Tags.Blocks.NETHERRACK) || block.func_203417_a((ITag)BlockTags.field_232873_an_) || block.func_203417_a((ITag)BlockTags.field_232880_av_) || block == block1;
            }
            return block.func_203417_a((ITag)Tags.Blocks.NETHERRACK) || block.func_203417_a((ITag)BlockTags.field_232873_an_) || block.func_203417_a((ITag)BlockTags.field_232880_av_);
        });
    }

    public static boolean isDesiredGroundwEndTags(IWorldGenerationBaseReader reader, BlockPos pos, BYGTreeConfig config) {
        if (config.isPlacementForced()) {
            return true;
        }
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            Iterator<Block> iterator = config.getWhitelist().iterator();
            if (iterator.hasNext()) {
                Block block1 = iterator.next();
                return block.func_203417_a((ITag)Tags.Blocks.END_STONES) || block == block1;
            }
            return block.func_203417_a((ITag)Tags.Blocks.END_STONES);
        });
    }

    public static boolean isDesiredGroundwSandTag(IWorldGenerationBaseReader reader, BlockPos pos, BYGTreeConfig config) {
        if (config.isPlacementForced()) {
            return true;
        }
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            Iterator<Block> iterator = config.getWhitelist().iterator();
            if (iterator.hasNext()) {
                Block block1 = iterator.next();
                return block.func_203417_a((ITag)Tags.Blocks.SAND) || block == block1;
            }
            return block.func_203417_a((ITag)Tags.Blocks.SAND);
        });
    }

    public boolean isDesiredGround(IWorldGenerationBaseReader reader, BlockPos pos, Block ... desiredGroundBlock) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            int n = 0;
            Block[] blockArray = desiredGroundBlock;
            int n2 = blockArray.length;
            if (n < n2) {
                Block block1 = blockArray[n];
                return block == block1;
            }
            return false;
        });
    }

    public boolean doesSaplingHaveSpaceToGrow(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xDistance, int zDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(trunkPos.func_177958_n(), trunkPos.func_177956_o() + yOffSet, trunkPos.func_177952_p()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xDistance; xOffset <= xDistance; ++xOffset) {
                    for (int zOffset = -zDistance; zOffset <= zDistance; ++zOffset) {
                        if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean doesSaplingHaveSpaceToGrow(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xNegativeDistance, int zNegativeDistance, int xPositiveDistance, int zPositiveDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(trunkPos.func_177958_n(), trunkPos.func_177956_o() + yOffSet, trunkPos.func_177952_p()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xNegativeDistance; xOffset <= xPositiveDistance; ++xOffset) {
                    for (int zOffset = -zNegativeDistance; zOffset <= zPositiveDistance; ++zOffset) {
                        if (this.canSaplingGrowHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherTreeNearby(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int distance, boolean isSapling) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherTreeHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherTreeLikeThisNearby(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int distance, Block logBlock, Block leafBlock, boolean isSapling) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherTreeLikeThisHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset), logBlock, leafBlock)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isCliff(IWorldGenerationBaseReader reader, BlockPos ... trunkPositions) {
        return this.isCliff(reader, 5, trunkPositions);
    }

    public boolean isCliff(IWorldGenerationBaseReader reader, int checkDownRange, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutable.func_189533_g((Vector3i)trunkPos);
                for (int moveDown = 0; moveDown <= checkDownRange && (this.isAirOrWater(reader, (BlockPos)mutable) || FeatureUtil.isPlant(reader, (BlockPos)mutable)); ++moveDown) {
                    if (moveDown == checkDownRange) {
                        return true;
                    }
                    mutable.func_189536_c(Direction.DOWN);
                }
            }
        }
        return false;
    }

    public void buildTrunkBase(BlockPos centerPos, Set<BlockPos> treeBlocksSet, ISeedReader reader, BYGTreeConfig config, Random rand, MutableBoundingBox boundingBox, BlockPos ... trunkPositions) {
        if (config.isPlacementForced()) {
            return;
        }
        BlockState ground = reader.func_180495_p(centerPos.func_177972_a(Direction.DOWN));
        if (SPREADABLE_TO_NON_SPREADABLE.containsKey(ground.func_177230_c())) {
            ground = SPREADABLE_TO_NON_SPREADABLE.get(ground.func_177230_c()).func_176223_P();
        }
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutableTrunk = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.func_189533_g((Vector3i)trunkPos);
                for (int fill = 1; fill <= 25; ++fill) {
                    if (BYGAbstractTreeFeature.canLogPlaceHere((IWorldGenerationBaseReader)reader, (BlockPos)mutableTrunk)) {
                        if (fill <= 15) {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, config.getTrunkProvider().func_225574_a_(rand, (BlockPos)mutableTrunk), boundingBox);
                        } else {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, ground, boundingBox);
                        }
                    } else {
                        if (!this.isDesiredGround((IWorldGenerationBaseReader)reader, (BlockPos)mutableTrunk, config.getTrunkProvider().func_225574_a_(rand, (BlockPos)mutableTrunk).func_177230_c())) {
                            this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk, ground, boundingBox);
                        }
                        fill = 25;
                    }
                    mutableTrunk.func_189536_c(Direction.DOWN);
                }
            }
        }
    }

    public void setSoil(Set<BlockPos> treeBlocksSet, IWorldGenerationBaseReader reader, BYGTreeConfig config, Random rand, MutableBoundingBox boundingBox, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutableTrunk = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.func_189533_g((Vector3i)trunkPos);
                if (this.isDesiredGround(reader, (BlockPos)mutableTrunk, config.getTrunkProvider().func_225574_a_(rand, (BlockPos)mutableTrunk).func_177230_c())) continue;
                this.setFinalBlockState(treeBlocksSet, (IWorldWriter)reader, (BlockPos)mutableTrunk.func_189536_c(Direction.DOWN), config.getTrunkProvider().func_225574_a_(rand, (BlockPos)mutableTrunk), boundingBox);
            }
        }
    }

    public void setDisk(ISeedReader world, Random random, BlockPos pos, BYGTreeConfig config) {
        if (config.isPlacementForced() || config.getDiskRadius() <= 0) {
            return;
        }
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        int diskRadius = config.getDiskRadius();
        for (int x = -diskRadius; x <= diskRadius; ++x) {
            for (int z = -diskRadius; z <= diskRadius; ++z) {
                int squaredDistance = x * x + z * z;
                if (squaredDistance > diskRadius * diskRadius) continue;
                mutable.func_189533_g((Vector3i)pos).func_196234_d(x, 0, z);
                double diskRoughnessNoise = fastNoise.GetNoise((float)mutable.func_177958_n() * 0.04f, (float)mutable.func_177956_o() * 0.01f, (float)mutable.func_177952_p() * 0.04f);
                if ((float)squaredDistance > (float)(diskRadius * diskRadius) * 0.8f && diskRoughnessNoise > -0.3 && diskRoughnessNoise < 0.3 || !FeatureUtil.isTerrainOrRock((IWorldGenerationBaseReader)world, (BlockPos)mutable) || !world.func_180495_p(mutable.func_177984_a()).func_196958_f() && !FeatureUtil.isPlant((IWorldGenerationBaseReader)world, mutable.func_177984_a())) continue;
                world.func_180501_a((BlockPos)mutable, config.getDiskProvider().func_225574_a_(random, (BlockPos)mutable), 2);
            }
        }
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }

    public final void setFinalBlockState(Set<BlockPos> changedBlocks, IWorldWriter worldIn, BlockPos pos, BlockState blockState, MutableBoundingBox boundingBox) {
        this.setBlockStateWithoutUpdates(worldIn, pos, blockState);
        boundingBox.func_78888_b(new MutableBoundingBox((Vector3i)pos, (Vector3i)pos));
        if (BlockTags.field_200031_h.func_230235_a_((Object)blockState.func_177230_c())) {
            changedBlocks.add(pos.func_185334_h());
        }
    }

    public void setBlockStateWithoutUpdates(IWorldWriter worldWriter, BlockPos blockPos, BlockState blockState) {
        worldWriter.func_180501_a(blockPos, blockState, 18);
    }

    public void setBlockStateWithoutUpdates(IWorldWriter worldWriter, BlockPos blockPos, BlockState blockState, int flags) {
        worldWriter.func_180501_a(blockPos, blockState, flags);
    }

    protected void func_230367_a_(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        this.setBlockStateWithoutUpdates(worldIn, pos, state);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, TFC config) {
        return this.placeTree(worldIn, rand, pos, config);
    }

    public boolean placeTree(ISeedReader worldIn, Random rand, BlockPos pos, TFC config) {
        HashSet set = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.generate(set, worldIn, rand, pos, mutableboundingbox, ((BYGTreeConfig)config).isPlacementForced(), config);
        if (mutableboundingbox.field_78897_a > mutableboundingbox.field_78893_d) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(mutableboundingbox.func_78883_b(), mutableboundingbox.func_78882_c(), mutableboundingbox.func_78880_d());
        try (PooledMutable posInPool = PooledMutable.get();){
            if (flag && !set.isEmpty()) {
                for (BlockPos blockpos : Lists.newArrayList((Iterable)set)) {
                    if (mutableboundingbox.func_175898_b((Vector3i)blockpos)) {
                        voxelshapepart.func_199625_a(blockpos.func_177958_n() - mutableboundingbox.field_78897_a, blockpos.func_177956_o() - mutableboundingbox.field_78895_b, blockpos.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                    for (Direction direction : Direction.values()) {
                        BlockState blockstate;
                        posInPool.set((Vector3i)blockpos).func_189536_c(direction);
                        if (set.contains(posInPool) || !(blockstate = worldIn.func_180495_p((BlockPos)posInPool)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                        ((Set)list.get(0)).add(posInPool.func_185334_h());
                        this.setBlockStateWithoutUpdates((IWorldWriter)worldIn, (BlockPos)posInPool, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                        if (!mutableboundingbox.func_175898_b((Vector3i)posInPool)) continue;
                        voxelshapepart.func_199625_a(posInPool.func_177958_n() - mutableboundingbox.field_78897_a, posInPool.func_177956_o() - mutableboundingbox.field_78895_b, posInPool.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                }
            }
            for (int l = 1; l < 6; ++l) {
                Set set1 = (Set)list.get(l - 1);
                Set set2 = (Set)list.get(l);
                for (BlockPos blockpos1 : set1) {
                    if (mutableboundingbox.func_175898_b((Vector3i)blockpos1)) {
                        voxelshapepart.func_199625_a(blockpos1.func_177958_n() - mutableboundingbox.field_78897_a, blockpos1.func_177956_o() - mutableboundingbox.field_78895_b, blockpos1.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                    }
                    for (Direction direction1 : Direction.values()) {
                        int newDistance;
                        int currentDistance;
                        BlockState blockstate1;
                        posInPool.set((Vector3i)blockpos1).func_189536_c(direction1);
                        if (set1.contains(posInPool) || set2.contains(posInPool) || !(blockstate1 = worldIn.func_180495_p((BlockPos)posInPool)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (currentDistance = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= (newDistance = l + 1)) continue;
                        BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(newDistance));
                        if (newDistance >= 7) {
                            this.setBlockStateWithoutUpdates((IWorldWriter)worldIn, (BlockPos)posInPool, Blocks.field_150350_a.func_176223_P(), 2);
                        } else {
                            this.setBlockStateWithoutUpdates((IWorldWriter)worldIn, (BlockPos)posInPool, blockstate2);
                        }
                        if (mutableboundingbox.func_175898_b((Vector3i)posInPool)) {
                            voxelshapepart.func_199625_a(posInPool.func_177958_n() - mutableboundingbox.field_78897_a, posInPool.func_177956_o() - mutableboundingbox.field_78895_b, posInPool.func_177952_p() - mutableboundingbox.field_78896_c, true, true);
                        }
                        set2.add(posInPool.func_185334_h());
                    }
                }
            }
        }
        Template.func_222857_a((IWorld)worldIn, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
        this.setDisk(worldIn, rand, pos.func_177977_b(), (BYGTreeConfig)config);
        return flag;
    }

    protected abstract boolean generate(Set<BlockPos> var1, ISeedReader var2, Random var3, BlockPos var4, MutableBoundingBox var5, boolean var6, TFC var7);

    @Nullable
    public SaplingData saplingData(BlockPos pos) {
        return new SaplingData(new HashSet<BlockPos>(), 0);
    }

    static {
        SPREADABLE_TO_NON_SPREADABLE = new HashMap<Block, Block>();
        SPREADABLE_TO_NON_SPREADABLE.put(Blocks.field_196658_i, Blocks.field_150346_d);
        SPREADABLE_TO_NON_SPREADABLE.put(Blocks.field_150391_bh, Blocks.field_150346_d);
        SPREADABLE_TO_NON_SPREADABLE.put(Blocks.field_185774_da, Blocks.field_150346_d);
        SPREADABLE_TO_NON_SPREADABLE.put(Blocks.field_196661_l, Blocks.field_150346_d);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.OVERGROWN_DACITE, BYGBlocks.DACITE);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.PODZOL_DACITE, BYGBlocks.DACITE);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.OVERGROWN_STONE, Blocks.field_150348_b);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.OVERGROWN_CRIMSON_BLACKSTONE, Blocks.field_235406_np_);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.OVERGROWN_NETHERRACK, Blocks.field_150424_aL);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.SYTHIAN_NYLIUM, Blocks.field_150424_aL);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.EMBUR_NYLIUM, BYGBlocks.BLUE_NETHERRACK);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.IVIS_PHYLIUM, Blocks.field_150377_bs);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.NIGHTSHADE_PHYLIUM, Blocks.field_150377_bs);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.SHULKREN_PHYLIUM, Blocks.field_150377_bs);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.VERMILION_SCULK, BYGBlocks.ETHER_STONE);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.ETHER_PHYLIUM, BYGBlocks.ETHER_SOIL);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.MEADOW_GRASSBLOCK, BYGBlocks.MEADOW_DIRT);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.MEADOW_GRASS_PATH, BYGBlocks.MEADOW_DIRT);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.GLOWCELIUM, Blocks.field_150346_d);
        SPREADABLE_TO_NON_SPREADABLE.put(BYGBlocks.MYCELIUM_NETHERRACK, Blocks.field_150424_aL);
    }

    public static final class PooledMutable
    extends BlockPos.Mutable
    implements AutoCloseable {
        private boolean free;
        private static final List<PooledMutable> POOL = Lists.newArrayList();

        private PooledMutable(int x, int y, int z) {
            super(x, y, z);
        }

        public static PooledMutable get() {
            return PooledMutable.get(0, 0, 0);
        }

        public static PooledMutable get(double x, double y, double z) {
            return PooledMutable.get(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PooledMutable get(int x, int y, int z) {
            List<PooledMutable> list = POOL;
            synchronized (list) {
                PooledMutable pooledMutable;
                if (!POOL.isEmpty() && (pooledMutable = POOL.remove(POOL.size() - 1)) != null && pooledMutable.free) {
                    pooledMutable.free = false;
                    pooledMutable.set(x, y, z);
                    return pooledMutable;
                }
            }
            return new PooledMutable(x, y, z);
        }

        public PooledMutable set(int i, int j, int k) {
            return (PooledMutable)super.func_181079_c(i, j, k);
        }

        public PooledMutable set(double d, double e, double f) {
            return (PooledMutable)super.func_189532_c(d, e, f);
        }

        public PooledMutable set(Vector3i vec3i) {
            return (PooledMutable)super.func_189533_g(vec3i);
        }

        public PooledMutable setOffset(Direction direction) {
            return this.setOffset(direction, 1);
        }

        public PooledMutable setOffset(Direction direction, int distance) {
            return this.set(this.func_177958_n() + direction.func_82601_c() * distance, this.func_177956_o() + direction.func_96559_d() * distance, this.func_177952_p() + direction.func_82599_e() * distance);
        }

        public BlockPos.Mutable setOffset(int x, int y, int z) {
            return this.set(this.func_177958_n() + x, this.func_177956_o() + y, this.func_177952_p() + z);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List<PooledMutable> list = POOL;
            synchronized (list) {
                if (POOL.size() < 100) {
                    POOL.add(this);
                }
                this.free = true;
            }
        }
    }
}

