/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.biomedata;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.util.WeightedList;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public class BiomeData {
    private final Biome biome;
    private final WeightedList<Biome> biomeWeightedList;
    private final Biome edgeBiome;
    private final Biome beachBiome;
    private final Biome riverBiome;
    private final int biomeWeight;
    @Nullable
    private final BiomeManager.BiomeType biomeType;
    private final BiomeDictionary.Type[] dictionaryType;

    public BiomeData(Biome biome, int biomeWeight, @Nullable BiomeManager.BiomeType biomeType, BiomeDictionary.Type[] dictionary, WeightedList<Biome> biomeWeightedList, Biome edgeBiome, Biome beachBiome, Biome river) {
        this.biome = biome;
        this.biomeWeight = biomeWeight;
        this.biomeType = biomeType;
        this.dictionaryType = dictionary;
        this.biomeWeightedList = biomeWeightedList;
        this.edgeBiome = edgeBiome;
        this.beachBiome = beachBiome;
        this.riverBiome = river;
    }

    public Biome getBiome() {
        return this.biome;
    }

    public WeightedList<Biome> getBiomeWeightedList() {
        return this.biomeWeightedList;
    }

    public Biome getEdgeBiome() {
        return this.edgeBiome;
    }

    public Biome getBeachBiome() {
        return this.beachBiome;
    }

    public Biome getRiverBiome() {
        return this.riverBiome;
    }

    public int getBiomeWeight() {
        return this.biomeWeight;
    }

    @Nullable
    public BiomeManager.BiomeType getBiomeType() {
        if (!Arrays.stream(this.dictionaryType).collect(Collectors.toList()).contains(BiomeDictionary.Type.OCEAN) && this.biomeType == null) {
            throw new UnsupportedOperationException("The biome climate was null in a non ocean biome, this should NEVER happen!");
        }
        return this.biomeType;
    }

    public BiomeDictionary.Type[] getDictionaryTypes() {
        return this.dictionaryType;
    }
}

