/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.biomedata;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import corgiaoc.byg.BYG;
import corgiaoc.byg.config.json.biomedata.BiomeData;
import corgiaoc.byg.config.json.biomedata.BiomeDataListHolder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public class BiomeDataListHolderSerializer
implements JsonSerializer<BiomeDataListHolder>,
JsonDeserializer<BiomeDataListHolder> {
    public static List<BiomeDictionary.Type> defaultTypesList = new ArrayList<BiomeDictionary.Type>();
    public static List<BiomeDictionary.Type> stopSpamLoggerSpam;

    public JsonElement serialize(BiomeDataListHolder Src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject biomes = new JsonObject();
        JsonObject biomeObject = new JsonObject();
        for (BiomeData biomeData : Src.getBiomeData()) {
            JsonArray weightedListArray = new JsonArray();
            JsonObject object = new JsonObject();
            if (biomeData.getBiomeWeightedList() != null) {
                for (WeightedList.Entry biomeEntry : biomeData.getBiomeWeightedList().field_220658_a) {
                    JsonObject object2 = new JsonObject();
                    ResourceLocation biomeEntryKey = WorldGenRegistries.field_243657_i.func_177774_c(biomeEntry.func_220647_b());
                    if (biomeEntryKey != null) {
                        object2.addProperty("name", biomeEntryKey.toString());
                        object2.addProperty("weight", (Number)biomeEntry.field_220652_c);
                        weightedListArray.add((JsonElement)object2);
                        continue;
                    }
                    BYG.LOGGER.error("One or more \"hills\" \"name\" value was null/incorrect.");
                }
            }
            StringBuilder dictionaryString = new StringBuilder();
            for (WeightedList.Entry type : biomeData.getDictionaryTypes()) {
                if (!dictionaryString.toString().isEmpty()) {
                    dictionaryString.append(",");
                }
                dictionaryString.append(type.toString());
            }
            object.addProperty("climate", biomeData.getBiomeType().toString().toUpperCase());
            object.addProperty("dictionary", dictionaryString.toString().toUpperCase());
            object.addProperty("weight", (Number)biomeData.getBiomeWeight());
            ResourceLocation riverKey = WorldGenRegistries.field_243657_i.func_177774_c((Object)biomeData.getRiverBiome());
            if (riverKey != null) {
                object.addProperty("river", riverKey.toString());
            } else {
                object.addProperty("river", "");
            }
            ResourceLocation beachKey = WorldGenRegistries.field_243657_i.func_177774_c((Object)biomeData.getBeachBiome());
            if (beachKey != null) {
                object.addProperty("beach", beachKey.toString());
            } else {
                object.addProperty("beach", "");
            }
            ResourceLocation edgeKey = WorldGenRegistries.field_243657_i.func_177774_c((Object)biomeData.getEdgeBiome());
            if (edgeKey != null) {
                object.addProperty("edge", edgeKey.toString());
            } else {
                object.addProperty("edge", "");
            }
            object.add("hills", (JsonElement)weightedListArray);
            ResourceLocation location = WorldGenRegistries.field_243657_i.func_177774_c((Object)biomeData.getBiome());
            if (location != null) {
                biomeObject.add(location.toString(), (JsonElement)object);
                continue;
            }
            BYG.LOGGER.error("The Biome key was null! This should NEVER happen.");
        }
        biomes.add("biomes", (JsonElement)biomeObject);
        return biomes;
    }

    public BiomeDataListHolder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BYG.LOGGER.info("Reading json");
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayList<BiomeData> biomeData = new ArrayList<BiomeData>();
        Set entrySet = jsonObject.get("biomes").getAsJsonObject().entrySet();
        for (Map.Entry elementEntry : entrySet) {
            BiomeManager.BiomeType biomeType;
            WeightedList weightedList = new WeightedList();
            String biomeName = (String)elementEntry.getKey();
            JsonElement element = (JsonElement)elementEntry.getValue();
            JsonObject elementObject = element.getAsJsonObject();
            String climate = elementObject.get("climate").getAsString().toUpperCase();
            String edge = elementObject.get("edge").getAsString();
            String river = elementObject.get("river").getAsString();
            String beach = elementObject.get("beach").getAsString();
            int weight = elementObject.get("weight").getAsInt();
            ArrayList<String> defaultClimates = new ArrayList<String>();
            defaultClimates.add("ICY");
            defaultClimates.add("COOL");
            defaultClimates.add("WARM");
            defaultClimates.add("DESERT");
            defaultClimates.add("DESERT_LEGACY");
            if (!defaultClimates.contains(climate) && !climate.isEmpty()) {
                BYG.LOGGER.error((String)elementEntry.getKey() + "'s \"climate\" value is incorrect you put: \"" + climate + "\". Defaulting climate to warm...");
                biomeType = BiomeManager.BiomeType.WARM;
            } else {
                biomeType = !climate.isEmpty() ? BiomeManager.BiomeType.valueOf((String)climate) : null;
            }
            JsonArray hillLayerList = elementObject.get("hills").getAsJsonArray();
            String dictionary = elementObject.get("dictionary").getAsString();
            List<BiomeDictionary.Type> types = Arrays.stream(dictionary.trim().replace(" ", "").toUpperCase().split(",")).map(this::warnIfTagIsNotDefault).map(x$0 -> BiomeDictionary.Type.getType((String)x$0, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toList());
            BiomeDictionary.Type[] typesArray = new BiomeDictionary.Type[types.size()];
            typesArray = types.toArray(typesArray);
            if (types.size() == 0) {
                types.add(BiomeDictionary.Type.OVERWORLD);
                BYG.LOGGER.warn("No dictionary entries were read...defaulting to: \"OVERWORLD\"");
            }
            for (JsonElement hillElement : hillLayerList) {
                ResourceLocation hillResourceLocation;
                JsonObject hillObject = hillElement.getAsJsonObject();
                String hillBiomeName = hillObject.get("name").getAsString();
                Integer hillWeight = hillObject.get("weight").getAsInt();
                if (hillBiomeName == null || hillWeight == null || (hillResourceLocation = new ResourceLocation(hillBiomeName)) == null) continue;
                if (WorldGenRegistries.field_243657_i.func_148742_b().contains(hillResourceLocation)) {
                    weightedList.func_226313_a_(Objects.requireNonNull(WorldGenRegistries.field_243657_i.func_82594_a(hillResourceLocation)), hillWeight.intValue());
                    continue;
                }
                BYG.LOGGER.error("Could not find: \"" + hillResourceLocation.toString() + "\" in the biome registry!\nEntry will not be added. Skipping entry...");
            }
            ResourceLocation biomeKey = new ResourceLocation(biomeName);
            if (WorldGenRegistries.field_243657_i.func_148742_b().contains(biomeKey)) {
                if (biomeKey.func_110624_b().equals("byg")) {
                    biomeData.add(new BiomeData((Biome)WorldGenRegistries.field_243657_i.func_82594_a(biomeKey), weight, biomeType, typesArray, (WeightedList<Biome>)weightedList, (Biome)WorldGenRegistries.field_243657_i.func_82594_a(new ResourceLocation(edge)), (Biome)WorldGenRegistries.field_243657_i.func_82594_a(new ResourceLocation(beach)), (Biome)WorldGenRegistries.field_243657_i.func_82594_a(new ResourceLocation(river))));
                    continue;
                }
                BYG.LOGGER.error("Biome key: \"" + biomeName + "\" is illegal. The mod id for the biome key MUST be \"byg\". Skipping entry...");
                continue;
            }
            BYG.LOGGER.error("The biome key: \"" + biomeName + "\" was not found in the registry, skipping entry...");
        }
        return new BiomeDataListHolder(biomeData);
    }

    public String warnIfTagIsNotDefault(String string) {
        BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        if (!defaultTypesList.contains(type) && !stopSpamLoggerSpam.contains(type)) {
            BYG.LOGGER.warn(type.toString() + " is not a default dictionary value.\nIgnore this msg if using modded biome dictionary values.");
            stopSpamLoggerSpam.add(type);
        }
        return string;
    }

    static {
        defaultTypesList.add(BiomeDictionary.Type.HOT);
        defaultTypesList.add(BiomeDictionary.Type.COLD);
        defaultTypesList.add(BiomeDictionary.Type.SPARSE);
        defaultTypesList.add(BiomeDictionary.Type.DENSE);
        defaultTypesList.add(BiomeDictionary.Type.WET);
        defaultTypesList.add(BiomeDictionary.Type.DRY);
        defaultTypesList.add(BiomeDictionary.Type.SAVANNA);
        defaultTypesList.add(BiomeDictionary.Type.CONIFEROUS);
        defaultTypesList.add(BiomeDictionary.Type.JUNGLE);
        defaultTypesList.add(BiomeDictionary.Type.SPOOKY);
        defaultTypesList.add(BiomeDictionary.Type.DEAD);
        defaultTypesList.add(BiomeDictionary.Type.LUSH);
        defaultTypesList.add(BiomeDictionary.Type.MUSHROOM);
        defaultTypesList.add(BiomeDictionary.Type.MAGICAL);
        defaultTypesList.add(BiomeDictionary.Type.RARE);
        defaultTypesList.add(BiomeDictionary.Type.PLATEAU);
        defaultTypesList.add(BiomeDictionary.Type.MODIFIED);
        defaultTypesList.add(BiomeDictionary.Type.OCEAN);
        defaultTypesList.add(BiomeDictionary.Type.RIVER);
        defaultTypesList.add(BiomeDictionary.Type.WATER);
        defaultTypesList.add(BiomeDictionary.Type.MESA);
        defaultTypesList.add(BiomeDictionary.Type.FOREST);
        defaultTypesList.add(BiomeDictionary.Type.PLAINS);
        defaultTypesList.add(BiomeDictionary.Type.MOUNTAIN);
        defaultTypesList.add(BiomeDictionary.Type.HILLS);
        defaultTypesList.add(BiomeDictionary.Type.SWAMP);
        defaultTypesList.add(BiomeDictionary.Type.SANDY);
        defaultTypesList.add(BiomeDictionary.Type.SNOWY);
        defaultTypesList.add(BiomeDictionary.Type.WASTELAND);
        defaultTypesList.add(BiomeDictionary.Type.VOID);
        defaultTypesList.add(BiomeDictionary.Type.OVERWORLD);
        defaultTypesList.add(BiomeDictionary.Type.BEACH);
        defaultTypesList.add(BiomeDictionary.Type.NETHER);
        defaultTypesList.add(BiomeDictionary.Type.END);
        stopSpamLoggerSpam = new ArrayList<BiomeDictionary.Type>();
    }
}

