/*
 * Decompiled with CFR 0.152.
 */
package candlebackport.blocks;

import candlebackport.blocks.AbstractCandleBlock;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2272;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class CandleCakeBlock
extends AbstractCandleBlock {
    public static final class_2746 LIT = AbstractCandleBlock.LIT;
    protected static final class_265 CAKE_SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final class_265 CANDLE_SHAPE = class_2248.method_9541((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final class_265 SHAPE = class_259.method_1084((class_265)CAKE_SHAPE, (class_265)CANDLE_SHAPE);
    private static final Map<class_2248, CandleCakeBlock> CANDLES_TO_CANDLE_CAKES = Maps.newHashMap();
    private static final Iterable<class_243> PARTICLE_OFFSETS = ImmutableList.of((Object)new class_243(0.5, 1.0, 0.5));

    public CandleCakeBlock(class_2248 candle, class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
        CANDLES_TO_CANDLE_CAKES.put(candle, this);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected Iterable<class_243> getParticleOffsets(class_2680 state) {
        return PARTICLE_OFFSETS;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (item == class_1802.field_8884 && !((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            CandleCakeBlock.light((class_1936)world, state, pos);
            if (player instanceof class_3222) {
                itemStack.method_7956(1, (class_1309)player, p -> player.method_20236(hand));
            }
            world.method_8396((class_1657)null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (item == class_1802.field_8814 && !((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            CandleCakeBlock.light((class_1936)world, state, pos);
            if (player instanceof class_3222 && !player.method_7337()) {
                itemStack.method_7934(1);
            }
            world.method_8396((class_1657)null, pos, class_3417.field_15013, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (itemStack.method_7909() != class_1802.field_8884 && itemStack.method_7909() != class_1802.field_8814) {
            if (CandleCakeBlock.isHittingCandle(hit) && player.method_5998(hand).method_7960() && ((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
                CandleCakeBlock.extinguish(player, state, (class_1936)world, pos);
                return class_1269.method_29236((boolean)world.field_9236);
            }
            if (!player.method_5715() && (player.method_7337() || player.method_7332(false))) {
                class_1269 actionResult = this.tryEat((class_1936)world, pos, class_2246.field_10183.method_9564(), player);
                if (actionResult.method_23665()) {
                    CandleCakeBlock.method_9497((class_2680)state, (class_1937)world, (class_2338)pos);
                }
                return actionResult;
            }
            world.method_8501(pos, class_2246.field_10183.method_9564());
            CandleCakeBlock.method_9497((class_2680)state, (class_1937)world, (class_2338)pos);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private class_1269 tryEat(class_1936 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!player.method_7332(false)) {
            return class_1269.field_5811;
        }
        player.method_7281(class_3468.field_15369);
        player.method_7344().method_7585(2, 0.1f);
        int i = (Integer)state.method_11654((class_2769)class_2272.field_10739);
        if (i < 6) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2272.field_10739, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.method_8650(pos, false);
        }
        return class_1269.field_5812;
    }

    private static boolean isHittingCandle(class_3965 hitResult) {
        return hitResult.method_17784().field_1351 - (double)hitResult.method_17777().method_10264() > 0.5;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIT});
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)class_2246.field_10183);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return direction == class_2350.field_11033 && !state.method_26184((class_4538)world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_26207().method_15799();
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return (7 - (Integer)state.method_11654((class_2769)class_2272.field_10739)) * 2;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public static class_2680 getCandleCakeFromCandle(class_2248 candle) {
        return CANDLES_TO_CANDLE_CAKES.get(candle).method_9564();
    }

    public static boolean canBeLit(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)LIT) == false;
    }
}

