/*
 * Decompiled with CFR 0.152.
 */
package nerdhub.cardinal.components.api.util.sync;

import io.netty.buffer.Unpooled;
import nerdhub.cardinal.components.api.util.sync.BaseSyncedComponent;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.server.PlayerStream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.util.Identifier;
import net.minecraft.util.PacketByteBuf;
import net.minecraft.world.World;

public interface WorldSyncedComponent
extends BaseSyncedComponent {
    public static final Identifier PACKET_ID = new Identifier("cardinal-components", "world_sync");

    public World getWorld();

    default public void sync() {
        if (!this.getWorld().isClient) {
            PlayerStream.world((World)this.getWorld()).map(ServerPlayerEntity.class::cast).forEach(this::syncWith);
        }
    }

    default public void syncWith(ServerPlayerEntity player) {
        PacketByteBuf buf = new PacketByteBuf(Unpooled.buffer());
        buf.writeIdentifier(this.getComponentType().getId());
        this.writeToPacket(buf);
        ServerSidePacketRegistry.INSTANCE.sendToPlayer((PlayerEntity)player, PACKET_ID, buf);
    }

    default public void processPacket(PacketContext ctx, PacketByteBuf buf) {
        PacketByteBuf copy = new PacketByteBuf(buf.copy());
        ctx.getTaskQueue().execute(() -> {
            this.readFromPacket(copy);
            copy.release();
        });
    }
}

