/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.ce_foodstuffs.objects.block.block_entity;

import com.hugman.ce_foodstuffs.CEFoodstuffs;
import com.hugman.ce_foodstuffs.init.CEFBlocks;
import com.hugman.ce_foodstuffs.objects.item.TeaBagItem;
import com.hugman.ce_foodstuffs.objects.item.tea.TeaHelper;
import com.hugman.ce_foodstuffs.objects.item.tea.TeaType;
import com.hugman.ce_foodstuffs.objects.screen.handler.KettleScreenHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3000;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3922;

public class KettleBlockEntity
extends class_2624
implements class_1278,
class_3000 {
    private static final int[] TOP_SLOTS = new int[]{0};
    protected final class_3913 propertyDelegate;
    private class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private class_1792 itemBrewing;
    private int brewTime;
    private int fluidLevel;
    private int fluid = 0;
    private List<TeaType> teaTypes = new ArrayList<TeaType>();
    private boolean isHot;

    public KettleBlockEntity() {
        super(CEFBlocks.KETTLE_ENTITY);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                switch (index) {
                    case 0: {
                        return KettleBlockEntity.this.brewTime;
                    }
                    case 1: {
                        return KettleBlockEntity.this.fluidLevel;
                    }
                    case 2: {
                        return KettleBlockEntity.this.fluid;
                    }
                    case 3: {
                        return KettleBlockEntity.this.isHot ? 1 : 0;
                    }
                    case 4: {
                        return TeaHelper.getColor(KettleBlockEntity.this.teaTypes);
                    }
                }
                return 0;
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        KettleBlockEntity.this.brewTime = value;
                        break;
                    }
                    case 1: {
                        KettleBlockEntity.this.fluidLevel = value;
                        break;
                    }
                    case 2: {
                        KettleBlockEntity.this.fluid = value;
                        break;
                    }
                    case 3: {
                        KettleBlockEntity.this.isHot = value == 1;
                        break;
                    }
                }
            }

            public int method_17389() {
                return 5;
            }
        };
    }

    protected class_2561 method_17823() {
        return new class_2588("container." + CEFoodstuffs.MOD_DATA.getModName() + ".kettle");
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new KettleScreenHandler(syncId, playerInventory, (class_1263)this, this.propertyDelegate);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public int getFluid() {
        return this.fluid;
    }

    public boolean addWater(int amount) {
        byte fLevel = (byte)(this.fluidLevel + amount);
        if (fLevel <= 3) {
            this.fluid = 1;
            this.fluidLevel = fLevel;
            return true;
        }
        return false;
    }

    public boolean removeFluid(int amount) {
        byte fLevel = (byte)(this.fluidLevel - amount);
        if (fLevel >= 0) {
            this.fluidLevel = fLevel;
            if (fLevel == 0) {
                this.fluid = 0;
                this.teaTypes = new ArrayList<TeaType>();
            }
            return true;
        }
        return false;
    }

    public List<TeaType> getTeaTypes() {
        return this.teaTypes;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return slot >= 0 && slot < this.inventory.size() ? (class_1799)this.inventory.get(slot) : class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot >= 0 && slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)stack);
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (stack.method_7909() instanceof TeaBagItem) {
            return !TeaHelper.getTeaTypesByCompound(stack.method_7969()).isEmpty();
        }
        return false;
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11036) {
            return TOP_SLOTS;
        }
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.method_5437(slot, stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public void method_16896() {
        boolean isBrewing;
        class_1799 stack = (class_1799)this.inventory.get(0);
        this.isHot = this.isHot();
        boolean canBrew = this.canBrew(stack);
        boolean bl = isBrewing = this.brewTime > 0;
        if (isBrewing) {
            boolean isFinishedBrewing;
            --this.brewTime;
            boolean bl2 = isFinishedBrewing = this.brewTime == 0;
            if (canBrew && isFinishedBrewing) {
                this.brew(stack);
                this.method_5431();
            } else if (!canBrew) {
                this.brewTime = 0;
                this.method_5431();
            } else if (this.itemBrewing != stack.method_7909()) {
                this.brewTime = 0;
                this.method_5431();
            }
        } else if (canBrew) {
            this.brewTime = 800;
            this.itemBrewing = stack.method_7909();
            this.method_5431();
        }
        if (this.fluid != 0 && this.fluidLevel == 0) {
            this.fluid = 0;
            this.method_5431();
        }
    }

    public boolean isHot() {
        for (class_2350 direction : class_2350.values()) {
            if (!this.isHotBlock(this.method_11016().method_10093(direction))) continue;
            return true;
        }
        return this.field_11863.method_8597().method_27999();
    }

    public boolean isHotBlock(class_2338 pos) {
        class_2680 blockState = this.field_11863.method_8320(pos);
        return class_3922.method_23896((class_2680)blockState) || blockState.method_27852(class_2246.field_10092) || blockState.method_27852(class_2246.field_10164);
    }

    private boolean canBrew(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_7909() instanceof TeaBagItem) {
            return !TeaHelper.getTeaTypesByCompound(stack.method_7969()).isEmpty() && this.fluid == 1 && this.fluidLevel >= 1 && this.isHot;
        }
        return false;
    }

    private void brew(class_1799 stack) {
        this.fluid = 2;
        this.teaTypes = TeaHelper.getTeaTypesByCompound(stack.method_7969());
        stack.method_7934(1);
        class_2338 blockPos = this.method_11016();
        if (stack.method_7909().method_7857()) {
            class_1799 remainderStack = new class_1799((class_1935)stack.method_7909().method_7858());
            if (stack.method_7960()) {
                stack = remainderStack;
            } else if (!this.field_11863.field_9236) {
                class_1264.method_5449((class_1937)this.field_11863, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), (class_1799)remainderStack);
            }
        }
        this.field_11863.method_8396(null, this.field_11867, CEFBlocks.KETTLE_BREW_SOUND, class_3419.field_15245, 1.0f, 1.0f);
        this.inventory.set(0, (Object)stack);
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.inventory);
        tag.method_10575("BrewTime", (short)this.brewTime);
        tag.method_10567("Fluid", (byte)this.fluid);
        tag.method_10567("FluidLevel", (byte)this.fluidLevel);
        class_2499 listTag = new class_2499();
        for (TeaType teaType : this.teaTypes) {
            class_2487 typeTag = new class_2487();
            typeTag.method_10582("Flavor", teaType.getFlavor().getName());
            typeTag.method_10582("Strength", teaType.getStrength().getName());
            listTag.add((Object)typeTag);
        }
        tag.method_10566("TeaTypes", (class_2520)listTag);
        return tag;
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        super.method_11014(state, tag);
        this.inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.inventory);
        this.brewTime = tag.method_10568("BrewTime");
        this.fluid = tag.method_10571("Fluid");
        this.fluidLevel = tag.method_10571("FluidLevel");
        class_2499 teaTypeList = tag.method_10554("TeaTypes", 10);
        if (!teaTypeList.isEmpty()) {
            for (int i = 0; i < teaTypeList.size(); ++i) {
                class_2487 typeTag = teaTypeList.method_10602(i);
                TeaType teaType = new TeaType(typeTag.method_10558("Strength"), typeTag.method_10558("Flavor"));
                if (!teaType.isCorrect()) continue;
                this.teaTypes.add(teaType);
            }
        }
    }
}

