/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.ce_foodstuffs.objects.item.tea;

import com.hugman.ce_foodstuffs.CEFoodstuffs;
import com.hugman.ce_foodstuffs.objects.item.tea.TeaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class TeaHelper {
    @Environment(value=EnvType.CLIENT)
    public static void appendTeaTooltip(List<class_2561> tooltips, List<TeaType> teaTypes) {
        for (TeaType teaType : teaTypes) {
            tooltips.add((class_2561)new class_2588("tea_type." + CEFoodstuffs.MOD_DATA.getModName() + "." + teaType.getFlavor().getName() + "." + teaType.getStrength().getName()).method_27692(class_124.field_1080));
        }
    }

    public static class_1799 appendTeaType(class_1799 stack, TeaType teaTypes) {
        return TeaHelper.appendTeaTypes(stack, new ArrayList<TeaType>(Collections.singleton(teaTypes)));
    }

    public static class_1799 appendTeaTypes(class_1799 stack, List<TeaType> teaTypes) {
        class_2499 listTag = new class_2499();
        for (TeaType teaType : teaTypes) {
            class_2487 typeTag = new class_2487();
            typeTag.method_10582("Flavor", teaType.getFlavor().getName());
            typeTag.method_10582("Strength", teaType.getStrength().getName());
            listTag.add((Object)typeTag);
        }
        class_2487 compoundTag = stack.method_7948();
        compoundTag.method_10566("TeaTypes", (class_2520)listTag);
        return stack;
    }

    public static List<TeaType> getIngredientTypes(class_1799 stack) {
        ArrayList<TeaType> teaTypes = new ArrayList<TeaType>();
        for (TeaType teaType : TeaHelper.getAllTypes()) {
            if (!class_1856.method_8106(teaType.getTag()).method_8093(stack)) continue;
            teaTypes.add(teaType);
        }
        return teaTypes;
    }

    public static List<TeaType> getAllTypes() {
        ArrayList<TeaType> teaTypes = new ArrayList<TeaType>();
        for (TeaType.Flavor flavor : TeaType.Flavor.values()) {
            for (TeaType.Strength strength : TeaType.Strength.values()) {
                teaTypes.add(new TeaType(strength, flavor));
            }
        }
        return teaTypes;
    }

    public static List<TeaType> getTeaTypesByCompound(class_2487 compoundTag) {
        class_2499 teaTypeList;
        ArrayList<TeaType> list = new ArrayList<TeaType>();
        if (compoundTag != null && compoundTag.method_10545("TeaTypes") && !(teaTypeList = compoundTag.method_10554("TeaTypes", 10)).isEmpty()) {
            for (int i = 0; i < teaTypeList.size(); ++i) {
                class_2487 typeTag = teaTypeList.method_10602(i);
                TeaType teaType = new TeaType(typeTag.method_10558("Strength"), typeTag.method_10558("Flavor"));
                if (!teaType.isCorrect()) continue;
                list.add(teaType);
            }
        }
        return list;
    }

    public static int getColor(class_1799 stack) {
        return TeaHelper.getColor(TeaHelper.getTeaTypesByCompound(stack.method_7969()));
    }

    public static int getColor(List<TeaType> teaTypes) {
        if (teaTypes.isEmpty()) {
            return 15112486;
        }
        float f = 0.0f;
        float g = 0.0f;
        float h = 0.0f;
        int j = 0;
        for (TeaType teaType : teaTypes) {
            int k = teaType.getFlavor().getColor();
            int l = teaType.getStrength().getPotency() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            g += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            h += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        g = g / (float)j * 255.0f;
        h = h / (float)j * 255.0f;
        return (int)f << 16 | (int)g << 8 | (int)h;
    }
}

