/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.ce_foodstuffs.objects.item.tea;

import com.hugman.ce_foodstuffs.init.CEFEffects;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

public class TeaType {
    private final Strength strength;
    private final Flavor flavor;

    public TeaType(String strength, String flavor) {
        this(Strength.byName(strength), Flavor.byName(flavor));
    }

    public TeaType(Strength strength, Flavor flavor) {
        this.strength = strength;
        this.flavor = flavor;
    }

    public boolean isCorrect() {
        return this.getStrength() != null && this.getFlavor() != null;
    }

    public Strength getStrength() {
        return this.strength;
    }

    public Flavor getFlavor() {
        return this.flavor;
    }

    public class_3494<class_1792> getTag() {
        return TagRegistry.item((class_2960)new class_2960("c", "tea_ingredients/" + this.getFlavor().getName() + "/" + this.getStrength().getName()));
    }

    public String toString() {
        return "TeaType{strength=" + (Object)((Object)this.strength) + ", flavor=" + (Object)((Object)this.flavor) + '}';
    }

    public static enum Strength {
        WEAK("weak", 1),
        NORMAL("normal", 2),
        STRONG("strong", 3);

        private final String name;
        private final int potency;

        private Strength(String name, int potency) {
            this.name = name;
            this.potency = potency;
        }

        public static Strength byName(String name) {
            for (Strength strength : Strength.values()) {
                if (!strength.getName().equals(name)) continue;
                return strength;
            }
            return null;
        }

        public static Strength byPotency(int potency) {
            for (Strength strength : Strength.values()) {
                if (strength.getPotency() != potency) continue;
                return strength;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public int getPotency() {
            return this.potency;
        }
    }

    public static enum Flavor {
        SWEET("sweet", 9523743, CEFEffects.FULFILLMENT),
        UMAMI("umami", 10059295, class_1294.field_5907),
        SALTY("salty", 10251038, CEFEffects.GUARD),
        SOUR("sour", 7238946, CEFEffects.POISON_RESISTANCE),
        BITTER("bitter", 5057061, CEFEffects.FORESIGHT),
        SHINING("shining", 16759902, class_1294.field_5912),
        GLOOPY("gloopy", 9332621);

        private final String name;
        private final class_1291 effect;
        private final int color;

        private Flavor(String name, int color) {
            this(name, color, null);
        }

        private Flavor(String name, int color, class_1291 effect) {
            this.name = name;
            this.effect = effect;
            this.color = color;
        }

        public static Flavor byName(String name) {
            for (Flavor flavor : Flavor.values()) {
                if (!flavor.getName().equals(name)) continue;
                return flavor;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public class_1291 getEffect() {
            return this.effect;
        }

        public int getColor() {
            return this.color;
        }
    }
}

