/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.ce_foodstuffs.objects.recipe;

import com.hugman.ce_foodstuffs.init.CEFItems;
import com.hugman.ce_foodstuffs.objects.item.tea.TeaHelper;
import com.hugman.ce_foodstuffs.objects.item.tea.TeaType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

public class TeaBagMakingRecipe
extends class_1852 {
    private static final class_1856 PAPER = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8407});
    private static final class_1856 STRING = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8276});

    public TeaBagMakingRecipe(class_2960 id) {
        super(id);
    }

    public class_1865<?> method_8119() {
        return CEFItems.TEA_BAG_MAKING;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 3;
    }

    public boolean matches(class_1715 inv, class_1937 world) {
        boolean hasPaper = false;
        boolean hasString = false;
        ArrayList<TeaType> bagTeaTypes = new ArrayList<TeaType>();
        for (int j = 0; j < inv.method_5439(); ++j) {
            class_1799 stack = inv.method_5438(j);
            if (stack.method_7960()) continue;
            if (PAPER.method_8093(stack)) {
                if (hasPaper) {
                    return false;
                }
                hasPaper = true;
                continue;
            }
            if (STRING.method_8093(stack)) {
                if (hasString) {
                    return false;
                }
                hasString = true;
                continue;
            }
            List<TeaType> ingredientTeaTypes = TeaHelper.getIngredientTypes(stack);
            if (ingredientTeaTypes.isEmpty()) {
                return false;
            }
            for (TeaType teaType1 : ingredientTeaTypes) {
                if (bagTeaTypes.stream().anyMatch(teaType2 -> teaType1.getFlavor() == teaType2.getFlavor())) {
                    TeaType teaType22 = bagTeaTypes.stream().filter(t -> t.getFlavor() == teaType1.getFlavor()).findFirst().get();
                    TeaType newTeaType = new TeaType(TeaType.Strength.byPotency(teaType1.getStrength().getPotency() + teaType22.getStrength().getPotency()), teaType1.getFlavor());
                    if (newTeaType.isCorrect()) {
                        bagTeaTypes.remove(teaType22);
                        bagTeaTypes.add(newTeaType);
                        continue;
                    }
                    return false;
                }
                bagTeaTypes.add(teaType1);
            }
        }
        int totalStrength = 0;
        for (TeaType teaType : bagTeaTypes) {
            totalStrength += teaType.getStrength().getPotency();
        }
        return hasPaper && hasString && totalStrength >= 1 && totalStrength <= 3 && bagTeaTypes.size() <= 2;
    }

    public class_1799 craft(class_1715 inv) {
        class_1799 givenStack = new class_1799((class_1935)CEFItems.TEA_BAG);
        ArrayList<TeaType> bagTeaTypes = new ArrayList<TeaType>();
        for (int j = 0; j < inv.method_5439(); ++j) {
            List<TeaType> ingredientTeaTypes;
            class_1799 stack = inv.method_5438(j);
            if (stack.method_7960() || (ingredientTeaTypes = TeaHelper.getIngredientTypes(stack)).isEmpty()) continue;
            for (TeaType teaType1 : ingredientTeaTypes) {
                if (bagTeaTypes.stream().anyMatch(teaType2 -> teaType1.getFlavor() == teaType2.getFlavor())) {
                    TeaType teaType22 = bagTeaTypes.stream().filter(t -> t.getFlavor() == teaType1.getFlavor()).findFirst().get();
                    TeaType.Strength strength = TeaType.Strength.byPotency(teaType1.getStrength().getPotency() + teaType22.getStrength().getPotency());
                    bagTeaTypes.remove(teaType22);
                    bagTeaTypes.add(new TeaType(strength, teaType1.getFlavor()));
                    continue;
                }
                bagTeaTypes.add(teaType1);
            }
        }
        givenStack = TeaHelper.appendTeaTypes(givenStack, bagTeaTypes);
        return givenStack;
    }
}

