/*
 * Decompiled with CFR 0.152.
 */
package com.freeranger.choruswarps.items;

import com.freeranger.choruswarps.blocks.EnderLinkBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ChorusFruitItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class GoldenChorusFruitItem
extends ChorusFruitItem {
    public GoldenChorusFruitItem(Item.Properties builder) {
        super(builder);
    }

    public boolean func_219971_r() {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (this.func_219971_r()) {
            ItemStack itemstack = playerIn.func_184586_b(handIn);
            CompoundNBT nbt = itemstack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            boolean isLinked = nbt.func_74764_b("linked_x");
            Vector3d blockVector = Minecraft.func_71410_x().field_71476_x.func_216347_e();
            double bX = blockVector.func_82615_a();
            double bY = blockVector.func_82617_b();
            double bZ = blockVector.func_82616_c();
            double pX = Minecraft.func_71410_x().field_71439_g.func_226277_ct_();
            double pY = Minecraft.func_71410_x().field_71439_g.func_226278_cu_();
            double pZ = Minecraft.func_71410_x().field_71439_g.func_226281_cx_();
            if (bX == Math.floor(bX) && bX <= pX) {
                bX -= 1.0;
            }
            if (bY == Math.floor(bY) && bY <= pY + 1.0) {
                bY -= 1.0;
            }
            if (bZ == Math.floor(bZ) && bZ <= pZ) {
                bZ -= 1.0;
            }
            BlockPos pos = new BlockPos(bX, bY, bZ);
            if (isLinked && !(worldIn.func_180495_p(pos).func_177230_c() instanceof EnderLinkBlock)) {
                playerIn.func_184598_c(handIn);
                BlockPos linkedBlockPos = new BlockPos((double)nbt.func_74760_g("linked_x"), (double)nbt.func_74760_g("linked_y"), (double)nbt.func_74760_g("linked_z"));
                RegistryKey blockDimension = null;
                ItemStack stack = playerIn.func_184586_b(handIn);
                if (stack.func_77978_p().func_74762_e("dim") == 0) {
                    blockDimension = World.field_234918_g_;
                } else if (stack.func_77978_p().func_74762_e("dim") == -1) {
                    blockDimension = World.field_234919_h_;
                } else if (stack.func_77978_p().func_74762_e("dim") == 1) {
                    blockDimension = World.field_234920_i_;
                }
                if (worldIn.func_175623_d(linkedBlockPos) && blockDimension != null && playerIn.field_70170_p.func_234923_W_() == blockDimension) {
                    nbt.func_82580_o("linked_x");
                    nbt.func_82580_o("linked_y");
                    nbt.func_82580_o("linked_z");
                    nbt.func_82580_o("dim");
                    playerIn.func_184185_a(SoundEvents.field_204781_bf, 2.0f, 1.0f);
                    return ActionResult.func_226251_d_((Object)itemstack);
                }
                Block linkedBlock = worldIn.func_180495_p(linkedBlockPos).func_177230_c();
                if (!(linkedBlock instanceof EnderLinkBlock) && blockDimension != null && playerIn.field_70170_p.func_234923_W_() == blockDimension) {
                    nbt.func_82580_o("linked_x");
                    nbt.func_82580_o("linked_y");
                    nbt.func_82580_o("linked_z");
                    nbt.func_82580_o("dim");
                    playerIn.func_184185_a(SoundEvents.field_204781_bf, 2.0f, 1.0f);
                    return ActionResult.func_226251_d_((Object)itemstack);
                }
                return ActionResult.func_226249_b_((Object)itemstack);
            }
            if (Minecraft.func_71410_x().field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK && worldIn.func_180495_p(pos).func_177230_c() instanceof EnderLinkBlock) {
                nbt.func_74776_a("linked_x", (float)pos.func_177958_n());
                nbt.func_74776_a("linked_y", (float)pos.func_177956_o());
                nbt.func_74776_a("linked_z", (float)pos.func_177952_p());
                if (worldIn.func_234923_W_() == World.field_234918_g_) {
                    nbt.func_74768_a("dim", 0);
                } else if (worldIn.func_234923_W_() == World.field_234919_h_) {
                    nbt.func_74768_a("dim", -1);
                } else if (worldIn.func_234923_W_() == World.field_234920_i_) {
                    nbt.func_74768_a("dim", 1);
                } else {
                    nbt.func_74768_a("dim", 9999);
                }
                nbt.func_74757_a("linked", true);
                itemstack.func_77982_d(nbt);
                playerIn.func_184185_a(SoundEvents.field_187665_Y, 2.0f, 1.0f);
            }
            if (!nbt.func_74764_b("linked_x")) {
                playerIn.func_184185_a(SoundEvents.field_204781_bf, 2.0f, 1.0f);
            }
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (tooltip.size() > 1) {
            tooltip.remove(1);
        }
        String notLinked = new TranslationTextComponent("tooltip.choruswarps.not_linked").getString();
        String linkedTo = new TranslationTextComponent("tooltip.choruswarps.linked_to").getString();
        String overworld = new TranslationTextComponent("tooltip.choruswarps.overworld").getString();
        String nether = new TranslationTextComponent("tooltip.choruswarps.nether").getString();
        String end = new TranslationTextComponent("tooltip.choruswarps.end").getString();
        String invalidDimension = new TranslationTextComponent("tooltip.choruswarps.invalid_dimension").getString();
        if (stack.func_77978_p() != null) {
            if (stack.func_77978_p().func_74764_b("linked_x") && stack.func_77978_p().func_74764_b("dim")) {
                int dim = stack.func_77978_p().func_74762_e("dim");
                String dimension = dim == 0 ? overworld : (dim == -1 ? nether : (dim == 1 ? end : invalidDimension));
                tooltip.add((ITextComponent)new StringTextComponent("\u00a7f" + linkedTo + " \u00a7e" + stack.func_77978_p().func_74760_g("linked_x") + " " + stack.func_77978_p().func_74760_g("linked_y") + " " + stack.func_77978_p().func_74760_g("linked_z") + " \u00a7f(\u00a7e" + dimension + "\u00a7f)"));
            } else if (tooltip.size() > 1) {
                tooltip.set(1, (ITextComponent)new StringTextComponent("\u00a7f" + notLinked));
            } else {
                tooltip.add(1, (ITextComponent)new StringTextComponent("\u00a7f" + notLinked));
            }
        } else if (tooltip.size() > 1) {
            tooltip.set(1, (ITextComponent)new StringTextComponent("\u00a7f" + notLinked));
        } else {
            tooltip.add(1, (ITextComponent)new StringTextComponent("\u00a7f" + notLinked));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        RegistryKey blockDimension;
        if (!(entityLiving instanceof ServerPlayerEntity)) {
            return stack;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entityLiving;
        if (entityLiving.func_184218_aH()) {
            entityLiving.func_184210_p();
        }
        float targetX = stack.func_77978_p().func_74760_g("linked_x");
        float targetY = stack.func_77978_p().func_74760_g("linked_y");
        float targetZ = stack.func_77978_p().func_74760_g("linked_z");
        if (stack.func_77978_p().func_74762_e("dim") == 0) {
            blockDimension = World.field_234918_g_;
        } else if (stack.func_77978_p().func_74762_e("dim") == -1) {
            blockDimension = World.field_234919_h_;
        } else if (stack.func_77978_p().func_74762_e("dim") == 1) {
            blockDimension = World.field_234920_i_;
        } else {
            return stack;
        }
        if (player.field_70170_p.func_234923_W_() != blockDimension) {
            return stack;
        }
        boolean hasTeleported = this.safeTeleport((PlayerEntity)player, targetX, targetY, targetZ);
        ((ServerPlayerEntity)entityLiving).func_184811_cZ().func_185145_a((Item)this, 80);
        return hasTeleported ? this.returnIfTeleportSuccessful(entityLiving, worldIn, stack) : stack;
    }

    ItemStack returnIfTeleportSuccessful(LivingEntity entityLiving, World worldIn, ItemStack stack) {
        return entityLiving.func_213357_a(worldIn, stack);
    }

    boolean safeTeleport(PlayerEntity player, float x, float y, float z) {
        BlockPos[] positions = new BlockPos[]{new BlockPos((double)x, (double)y, (double)z), new BlockPos((double)x, (double)(y + 1.0f), (double)z), new BlockPos((double)x, (double)(y + 2.0f), (double)z), new BlockPos((double)(x + 1.0f), (double)y, (double)z), new BlockPos((double)(x - 1.0f), (double)y, (double)z), new BlockPos((double)x, (double)y, (double)(z + 1.0f)), new BlockPos((double)x, (double)y, (double)(z - 1.0f)), new BlockPos((double)x, (double)(y - 1.0f), (double)z), new BlockPos((double)x, (double)(y - 2.0f), (double)z)};
        positions[8] = new BlockPos((double)x, (double)(y - 3.0f), (double)z);
        for (BlockPos pos : positions) {
            BlockPos originPos = player.func_233580_cy_();
            if (!player.func_213373_a((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), true)) continue;
            SoundEvent soundevent = SoundEvents.field_187544_ad;
            player.field_70170_p.func_184148_a(null, (double)originPos.func_177958_n(), (double)originPos.func_177956_o(), (double)originPos.func_177952_p(), soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
            player.field_70170_p.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
            player.func_184185_a(soundevent, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

