/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractTextFieldListListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LongListListEntry
extends AbstractTextFieldListListEntry<Long, LongListCell, LongListListEntry> {
    private long minimum = Long.MIN_VALUE;
    private long maximum = Long.MAX_VALUE;

    @Deprecated
    @ApiStatus.Internal
    public LongListListEntry(class_2561 fieldName, List<Long> value, boolean defaultExpanded, Supplier<Optional<class_2561[]>> tooltipSupplier, Consumer<List<Long>> saveConsumer, Supplier<List<Long>> defaultValue, class_2561 resetButtonKey) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public LongListListEntry(class_2561 fieldName, List<Long> value, boolean defaultExpanded, Supplier<Optional<class_2561[]>> tooltipSupplier, Consumer<List<Long>> saveConsumer, Supplier<List<Long>> defaultValue, class_2561 resetButtonKey, boolean requiresRestart) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, true, true);
    }

    @Deprecated
    @ApiStatus.Internal
    public LongListListEntry(class_2561 fieldName, List<Long> value, boolean defaultExpanded, Supplier<Optional<class_2561[]>> tooltipSupplier, Consumer<List<Long>> saveConsumer, Supplier<List<Long>> defaultValue, class_2561 resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, LongListCell::new);
    }

    public LongListListEntry setMaximum(long maximum) {
        this.maximum = maximum;
        return this;
    }

    public LongListListEntry setMinimum(long minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public LongListListEntry self() {
        return this;
    }

    public static class LongListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Long, LongListCell, LongListListEntry> {
        public LongListCell(Long value, LongListListEntry listListEntry) {
            super(value, listListEntry);
        }

        @Override
        @Nullable
        protected Long substituteDefault(@Nullable Long value) {
            if (value == null) {
                return 0L;
            }
            return value;
        }

        @Override
        protected boolean isValidText(@NotNull String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45);
        }

        @Override
        public Long getValue() {
            try {
                return Long.valueOf(this.widget.method_1882());
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }

        @Override
        public Optional<class_2561> getError() {
            try {
                long l = Long.parseLong(this.widget.method_1882());
                if (l > ((LongListListEntry)this.listListEntry).maximum) {
                    return Optional.of(new class_2588("text.cloth-config.error.too_large", new Object[]{((LongListListEntry)this.listListEntry).maximum}));
                }
                if (l < ((LongListListEntry)this.listListEntry).minimum) {
                    return Optional.of(new class_2588("text.cloth-config.error.too_small", new Object[]{((LongListListEntry)this.listListEntry).minimum}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(new class_2588("text.cloth-config.error.not_valid_number_long"));
            }
            return Optional.empty();
        }
    }
}

