/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.api;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public abstract class ScrollingContainer {
    public double scrollAmount;
    public double scrollTarget;
    public long start;
    public long duration;
    public boolean draggingScrollBar = false;

    public abstract Rectangle getBounds();

    public Rectangle getScissorBounds() {
        Rectangle bounds = this.getBounds();
        if (this.hasScrollBar()) {
            return new Rectangle(bounds.x, bounds.y, bounds.width - 6, bounds.height);
        }
        return bounds;
    }

    public int getScrollBarX() {
        return this.hasScrollBar() ? this.getBounds().getMaxX() - 6 : this.getBounds().getMaxX();
    }

    public boolean hasScrollBar() {
        return this.getMaxScrollHeight() > this.getBounds().height;
    }

    public abstract int getMaxScrollHeight();

    public final int getMaxScroll() {
        return Math.max(0, this.getMaxScrollHeight() - this.getBounds().height);
    }

    public final double clamp(double v) {
        return this.clamp(v, 200.0);
    }

    public final double clamp(double v, double clampExtension) {
        return MathHelper.func_151237_a((double)v, (double)(-clampExtension), (double)((double)this.getMaxScroll() + clampExtension));
    }

    public final void offset(double value, boolean animated) {
        this.scrollTo(this.scrollTarget + value, animated);
    }

    public final void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public final void scrollTo(double value, boolean animated, long duration) {
        this.scrollTarget = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scrollAmount = this.scrollTarget;
        }
    }

    public void updatePosition(float delta) {
        double[] target = new double[]{this.scrollTarget};
        this.scrollAmount = ScrollingContainer.handleScrollingPosition(target, this.scrollAmount, this.getMaxScroll(), delta, this.start, this.duration);
        this.scrollTarget = target[0];
    }

    public static double handleScrollingPosition(double[] target, double scroll, double maxScroll, float delta, double start, double duration) {
        return ScrollingContainer.handleScrollingPosition(target, scroll, maxScroll, delta, start, duration, ClothConfigInitializer.getBounceBackMultiplier(), ClothConfigInitializer.getEasingMethod());
    }

    public static double handleScrollingPosition(double[] target, double scroll, double maxScroll, float delta, double start, double duration, double bounceBackMultiplier, EasingMethod easingMethod) {
        if (bounceBackMultiplier >= 0.0) {
            target[0] = ScrollingContainer.clampExtension(target[0], maxScroll);
            if (target[0] < 0.0) {
                target[0] = target[0] - target[0] * (1.0 - bounceBackMultiplier) * (double)delta / 3.0;
            } else if (target[0] > maxScroll) {
                target[0] = (target[0] - maxScroll) * (1.0 - (1.0 - bounceBackMultiplier) * (double)delta / 3.0) + maxScroll;
            }
        } else {
            target[0] = ScrollingContainer.clampExtension(target[0], maxScroll, 0.0);
        }
        return ScrollingContainer.ease(scroll, target[0], Math.min(((double)System.currentTimeMillis() - start) / duration * (double)delta * 3.0, 1.0), easingMethod);
    }

    public static double ease(double start, double end, double amount, EasingMethod easingMethod) {
        return start + (end - start) * easingMethod.apply(amount);
    }

    public static double clampExtension(double value, double maxScroll) {
        return ScrollingContainer.clampExtension(value, maxScroll, 200.0);
    }

    public static double clampExtension(double v, double maxScroll, double clampExtension) {
        return MathHelper.func_151237_a((double)v, (double)(-clampExtension), (double)(maxScroll + clampExtension));
    }

    public void renderScrollBar() {
        this.renderScrollBar(0, 1.0f, 1.0f);
    }

    public void renderScrollBar(int background, float alpha, float scrollBarAlphaOffset) {
        if (this.hasScrollBar()) {
            Rectangle bounds = this.getBounds();
            int maxScroll = this.getMaxScroll();
            int height = bounds.height * bounds.height / this.getMaxScrollHeight();
            height = MathHelper.func_76125_a((int)height, (int)32, (int)bounds.height);
            height = (int)((double)height - Math.min((double)(this.scrollAmount < 0.0 ? (int)(-this.scrollAmount) : (this.scrollAmount > (double)maxScroll ? (int)this.scrollAmount - maxScroll : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.scrollAmount * (bounds.height - height) / maxScroll + bounds.y, bounds.y), bounds.getMaxY() - height);
            int scrollbarPositionMinX = this.getScrollBarX();
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse());
            float bottomC = (hovered ? 0.67f : 0.5f) * scrollBarAlphaOffset;
            float topC = (hovered ? 0.87f : 0.67f) * scrollBarAlphaOffset;
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.shadeModel((int)7425);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            float a = (float)(background >> 24 & 0xFF) / 255.0f;
            float r = (float)(background >> 16 & 0xFF) / 255.0f;
            float g = (float)(background >> 8 & 0xFF) / 255.0f;
            float b = (float)(background & 0xFF) / 255.0f;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_225582_a_((double)scrollbarPositionMinX, (double)bounds.getMaxY(), 0.0).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)scrollbarPositionMaxX, (double)bounds.getMaxY(), 0.0).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)scrollbarPositionMaxX, (double)bounds.y, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)scrollbarPositionMinX, (double)bounds.y, 0.0).func_227885_a_(r, g, b, a).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_225582_a_((double)scrollbarPositionMinX, (double)(minY + height), 0.0).func_227885_a_(bottomC, bottomC, bottomC, alpha).func_181675_d();
            buffer.func_225582_a_((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).func_227885_a_(bottomC, bottomC, bottomC, alpha).func_181675_d();
            buffer.func_225582_a_((double)scrollbarPositionMaxX, (double)minY, 0.0).func_227885_a_(bottomC, bottomC, bottomC, alpha).func_181675_d();
            buffer.func_225582_a_((double)scrollbarPositionMinX, (double)minY, 0.0).func_227885_a_(bottomC, bottomC, bottomC, alpha).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_225582_a_((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).func_227885_a_(topC, topC, topC, alpha).func_181675_d();
            buffer.func_225582_a_((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).func_227885_a_(topC, topC, topC, alpha).func_181675_d();
            buffer.func_225582_a_((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).func_227885_a_(topC, topC, topC, alpha).func_181675_d();
            buffer.func_225582_a_((double)scrollbarPositionMinX, (double)minY, 0.0).func_227885_a_(topC, topC, topC, alpha).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        return this.mouseDragged(mouseX, mouseY, button, dx, dy, false, 0.0);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy, boolean snapToRows, double rowSize) {
        if (button == 0 && this.draggingScrollBar) {
            float height = this.getMaxScrollHeight();
            Rectangle bounds = this.getBounds();
            int actualHeight = bounds.height;
            if (mouseY >= (double)bounds.y && mouseY <= (double)bounds.getMaxY()) {
                double maxScroll = Math.max(1, this.getMaxScroll());
                double int_3 = MathHelper.func_151237_a((double)((double)(actualHeight * actualHeight) / (double)height), (double)32.0, (double)(actualHeight - 8));
                double double_6 = Math.max(1.0, maxScroll / ((double)actualHeight - int_3));
                float to = MathHelper.func_76131_a((float)((float)(this.scrollAmount + dy * double_6)), (float)0.0f, (float)this.getMaxScroll());
                if (snapToRows) {
                    double nearestRow = (double)Math.round((double)to / rowSize) * rowSize;
                    this.scrollTo(nearestRow, false);
                } else {
                    this.scrollTo(to, false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean updateDraggingState(double mouseX, double mouseY, int button) {
        double scrollbarPositionMinX;
        if (!this.hasScrollBar()) {
            return false;
        }
        double height = this.getMaxScroll();
        Rectangle bounds = this.getBounds();
        int actualHeight = bounds.height;
        if (height > (double)actualHeight && mouseY >= (double)bounds.y && mouseY <= (double)bounds.getMaxY() && mouseX >= (scrollbarPositionMinX = (double)this.getScrollBarX()) - 1.0 & mouseX <= scrollbarPositionMinX + 8.0) {
            this.draggingScrollBar = true;
            return true;
        }
        this.draggingScrollBar = false;
        return false;
    }
}

