/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Properties;
import me.shedaniel.forge.clothconfig2.api.ConfigBuilder;
import me.shedaniel.forge.clothconfig2.api.ConfigCategory;
import me.shedaniel.forge.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.forge.clothconfig2.impl.EasingMethod;
import me.shedaniel.forge.clothconfig2.impl.EasingMethods;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClothConfigInitializer {
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"ClothConfig");
    private static EasingMethod easingMethod = EasingMethod.EasingMethodImpl.QUART;
    private static long scrollDuration = 1000L;
    private static double scrollStep = 16.0;
    private static double bounceBackMultiplier = 0.84;

    public ClothConfigInitializer() {
        ClothConfigInitializer.loadConfig();
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (client, parent) -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen((Screen)parent).setTitle("Cloth Mod Config Config");
            builder.setDefaultBackgroundTexture(new ResourceLocation("minecraft:textures/block/oak_planks.png"));
            ConfigCategory scrolling = builder.getOrCreateCategory("Scrolling");
            ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
            scrolling.addEntry(entryBuilder.startSelector("Easing Method", EasingMethods.getMethods().toArray(new EasingMethod[0]), easingMethod).setDefaultValue(EasingMethod.EasingMethodImpl.QUART).setSaveConsumer(o -> {
                easingMethod = (EasingMethod)o;
            }).build());
            scrolling.addEntry(entryBuilder.startLongSlider("Scroll Duration", scrollDuration, 0L, 5000L).setTextGetter(integer -> integer <= 0L ? "Value: Disabled" : (integer > 1500L ? String.format("Value: %.1fs", Float.valueOf((float)integer.longValue() / 1000.0f)) : "Value: " + integer + "ms")).setDefaultValue(1000L).setSaveConsumer(i -> {
                scrollDuration = i;
            }).build());
            scrolling.addEntry(entryBuilder.startDoubleField("Scroll Step", scrollStep).setDefaultValue(16.0).setSaveConsumer(i -> {
                scrollStep = i;
            }).build());
            scrolling.addEntry(entryBuilder.startDoubleField("Bounce Multiplier", bounceBackMultiplier).setDefaultValue(0.84).setSaveConsumer(i -> {
                bounceBackMultiplier = i;
            }).build());
            builder.setSavingRunnable(() -> ClothConfigInitializer.saveConfig());
            return builder.build();
        });
    }

    public static EasingMethod getEasingMethod() {
        return easingMethod;
    }

    public static long getScrollDuration() {
        return scrollDuration;
    }

    public static double getScrollStep() {
        return scrollStep;
    }

    public static double getBounceBackMultiplier() {
        return bounceBackMultiplier;
    }

    private static void loadConfig() {
        File file = new File(FMLPaths.CONFIGDIR.get().toFile(), "cloth-config2/config.properties");
        try {
            file.getParentFile().mkdirs();
            easingMethod = EasingMethod.EasingMethodImpl.QUART;
            scrollDuration = 1000L;
            scrollStep = 16.0;
            bounceBackMultiplier = 0.84;
            if (!file.exists()) {
                ClothConfigInitializer.saveConfig();
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            String easing = properties.getProperty("easingMethod", "QUART");
            for (EasingMethod value : EasingMethods.getMethods()) {
                if (!value.toString().equalsIgnoreCase(easing)) continue;
                easingMethod = value;
                break;
            }
            scrollDuration = Long.parseLong(properties.getProperty("scrollDuration", "1000"));
            scrollStep = Double.parseDouble(properties.getProperty("scrollStep", "16"));
            bounceBackMultiplier = Double.parseDouble(properties.getProperty("bounceBackMultiplier1", "0.84"));
        }
        catch (Exception e) {
            e.printStackTrace();
            easingMethod = EasingMethod.EasingMethodImpl.QUART;
            scrollDuration = 1000L;
            scrollStep = 16.0;
            bounceBackMultiplier = 0.84;
            try {
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ClothConfigInitializer.saveConfig();
        }
    }

    private static void saveConfig() {
        File file = new File(FMLPaths.CONFIGDIR.get().toFile(), "cloth-config2/config.properties");
        try {
            FileWriter writer = new FileWriter(file, false);
            Properties properties = new Properties();
            properties.setProperty("easingMethod", easingMethod.toString());
            properties.setProperty("scrollDuration", scrollDuration + "");
            properties.setProperty("scrollStep", scrollStep + "");
            properties.setProperty("bounceBackMultiplier1", bounceBackMultiplier + "");
            properties.store(writer, null);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            easingMethod = EasingMethod.EasingMethodImpl.QUART;
            scrollDuration = 1000L;
            scrollStep = 16.0;
            bounceBackMultiplier = 0.84;
        }
    }
}

