/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.forge.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.forge.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.forge.clothconfig2.api.QueuedTooltip;
import me.shedaniel.forge.clothconfig2.gui.ClothConfigTabButton;
import me.shedaniel.forge.clothconfig2.gui.ClothRequiresRestartScreen;
import me.shedaniel.forge.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.forge.math.api.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ClothConfigScreen
extends Screen {
    private static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
    private final List<QueuedTooltip> queuedTooltips = Lists.newArrayList();
    public int nextTabIndex;
    public int selectedTabIndex;
    public double tabsScrollVelocity = 0.0;
    public double tabsScrollProgress = 0.0;
    public ListWidget listWidget;
    private Screen parent;
    private LinkedHashMap<String, List<AbstractConfigEntry>> tabbedEntries;
    private List<Pair<String, Integer>> tabs;
    private boolean edited;
    private boolean requiresRestart;
    private boolean confirmSave;
    private Widget buttonQuit;
    private Widget buttonSave;
    private Widget buttonLeftTab;
    private Widget buttonRightTab;
    private Rectangle tabsBounds;
    private Rectangle tabsLeftBounds;
    private Rectangle tabsRightBounds;
    private String title;
    private double tabsMaximumScrolled = -1.0;
    private boolean displayErrors;
    private List<ClothConfigTabButton> tabButtons;
    private boolean smoothScrollingTabs = true;
    private boolean smoothScrollingList = true;
    private ResourceLocation defaultBackgroundLocation;
    private Map<String, ResourceLocation> categoryBackgroundLocation;

    public ClothConfigScreen(Screen parent, String title, Map<String, List<Pair<String, Object>>> o) {
        this(parent, title, o, true, true);
    }

    public ClothConfigScreen(Screen parent, String title, Map<String, List<Pair<String, Object>>> o, boolean confirmSave, boolean displayErrors) {
        this(parent, title, o, confirmSave, displayErrors, true, AbstractGui.BACKGROUND_LOCATION);
    }

    public ClothConfigScreen(Screen parent, String title, Map<String, List<Pair<String, Object>>> o, boolean confirmSave, boolean displayErrors, boolean smoothScrollingList, ResourceLocation defaultBackgroundLocation) {
        this(parent, title, o, confirmSave, displayErrors, smoothScrollingList, defaultBackgroundLocation, Maps.newHashMap());
    }

    public ClothConfigScreen(Screen parent, String title, Map<String, List<Pair<String, Object>>> o, boolean confirmSave, boolean displayErrors, boolean smoothScrollingList, ResourceLocation defaultBackgroundLocation, Map<String, ResourceLocation> categoryBackgroundLocation) {
        super((ITextComponent)new StringTextComponent(""));
        this.parent = parent;
        this.title = title;
        this.tabbedEntries = Maps.newLinkedHashMap();
        this.smoothScrollingList = smoothScrollingList;
        this.defaultBackgroundLocation = defaultBackgroundLocation;
        o.forEach((tab, pairs) -> {
            ArrayList list = Lists.newArrayList();
            for (Pair pair : pairs) {
                if (pair.getSecond() instanceof AbstractConfigListEntry) {
                    list.add((AbstractConfigListEntry)((Object)((Object)pair.getSecond())));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported Type (" + (String)pair.getFirst() + "): " + pair.getSecond().getClass().getSimpleName());
            }
            list.forEach(entry -> entry.setScreen(this));
            this.tabbedEntries.put((String)tab, list);
        });
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.tabs = this.tabbedEntries.keySet().stream().map(s -> new Pair(s, (Object)(fontRenderer.func_78256_a(I18n.func_135052_a((String)s, (Object[])new Object[0])) + 8))).collect(Collectors.toList());
        this.nextTabIndex = 0;
        this.selectedTabIndex = 0;
        for (int i = 0; i < this.tabs.size(); ++i) {
            Pair<String, Integer> pair = this.tabs.get(i);
            if (!((String)pair.getFirst()).equals(this.getFallbackCategory())) continue;
            this.nextTabIndex = i;
            this.selectedTabIndex = i;
            break;
        }
        this.confirmSave = confirmSave;
        this.edited = false;
        this.requiresRestart = false;
        this.tabsScrollProgress = 0.0;
        this.tabButtons = Lists.newArrayList();
        this.displayErrors = displayErrors;
        this.categoryBackgroundLocation = categoryBackgroundLocation;
    }

    public String getFallbackCategory() {
        return (String)this.tabs.get(0).getFirst();
    }

    public void tick() {
        super.tick();
        for (IGuiEventListener child : this.children()) {
            if (!(child instanceof ITickable)) continue;
            ((ITickable)child).func_110550_d();
        }
    }

    public ResourceLocation getBackgroundLocation() {
        if (this.categoryBackgroundLocation.containsKey(Lists.newArrayList(this.tabbedEntries.keySet()).get(this.selectedTabIndex))) {
            return this.categoryBackgroundLocation.get(Lists.newArrayList(this.tabbedEntries.keySet()).get(this.selectedTabIndex));
        }
        return this.defaultBackgroundLocation;
    }

    public boolean isSmoothScrollingList() {
        return this.smoothScrollingList;
    }

    public void setSmoothScrollingList(boolean smoothScrollingList) {
        this.smoothScrollingList = smoothScrollingList;
    }

    public boolean isSmoothScrollingTabs() {
        return this.smoothScrollingTabs;
    }

    public void setSmoothScrollingTabs(boolean smoothScrolling) {
        this.smoothScrollingTabs = smoothScrolling;
    }

    public boolean isEdited() {
        return this.edited;
    }

    @Deprecated
    public void setEdited(boolean edited) {
        this.edited = edited;
        this.buttonQuit.setMessage(edited ? I18n.func_135052_a((String)"text.cloth-config.cancel_discard", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        this.buttonSave.active = edited;
    }

    public void setEdited(boolean edited, boolean requiresRestart) {
        this.setEdited(edited);
        if (!this.requiresRestart && requiresRestart) {
            this.requiresRestart = requiresRestart;
        }
    }

    protected void init() {
        super.init();
        this.children.clear();
        this.tabButtons.clear();
        if (this.listWidget != null) {
            this.tabbedEntries.put((String)this.tabs.get(this.selectedTabIndex).getFirst(), this.listWidget.children());
        }
        this.selectedTabIndex = this.nextTabIndex;
        this.listWidget = new ListWidget(this.minecraft, this.width, this.height, 70, this.height - 32, this.getBackgroundLocation());
        this.children.add(this.listWidget);
        this.listWidget.setSmoothScrolling(this.smoothScrollingList);
        if (this.tabbedEntries.size() > this.selectedTabIndex) {
            ((List)Lists.newArrayList(this.tabbedEntries.values()).get(this.selectedTabIndex)).forEach(entry -> this.listWidget.children().add((AbstractConfigEntry)((Object)entry)));
        }
        this.buttonQuit = new Button(this.width / 2 - 154, this.height - 26, 150, 20, this.edited ? I18n.func_135052_a((String)"text.cloth-config.cancel_discard", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), widget -> {
            if (this.confirmSave && this.edited) {
                this.minecraft.func_147108_a((Screen)new ConfirmScreen((BooleanConsumer)new QuitSaveConsumer(), (ITextComponent)new TranslationTextComponent("text.cloth-config.quit_config", new Object[0]), (ITextComponent)new TranslationTextComponent("text.cloth-config.quit_config_sure", new Object[0]), I18n.func_135052_a((String)"text.cloth-config.quit_discard", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
            } else {
                this.minecraft.func_147108_a(this.parent);
            }
        });
        this.addButton(this.buttonQuit);
        this.buttonSave = new AbstractButton(this.width / 2 + 4, this.height - 26, 150, 20, ""){

            public void onPress() {
                LinkedHashMap map = Maps.newLinkedHashMap();
                ClothConfigScreen.this.tabbedEntries.forEach((s, abstractListEntries) -> {
                    List list = abstractListEntries.stream().map(entry -> new Pair((Object)entry.getFieldName(), entry.getValue())).collect(Collectors.toList());
                    map.put(s, list);
                });
                for (List entries : Lists.newArrayList(ClothConfigScreen.this.tabbedEntries.values())) {
                    for (AbstractConfigEntry entry : entries) {
                        entry.save();
                    }
                }
                ClothConfigScreen.this.onSave(map);
                if (ClothConfigScreen.this.requiresRestart) {
                    ClothConfigScreen.this.minecraft.func_147108_a((Screen)new ClothRequiresRestartScreen(ClothConfigScreen.this.parent));
                } else {
                    ClothConfigScreen.this.minecraft.func_147108_a(ClothConfigScreen.this.parent);
                }
            }

            public void render(int int_1, int int_2, float float_1) {
                boolean hasErrors = false;
                if (ClothConfigScreen.this.displayErrors) {
                    for (List entries : Lists.newArrayList(ClothConfigScreen.this.tabbedEntries.values())) {
                        for (AbstractConfigEntry entry : entries) {
                            if (!entry.getConfigError().isPresent()) continue;
                            hasErrors = true;
                            break;
                        }
                        if (!hasErrors) continue;
                        break;
                    }
                }
                this.active = ClothConfigScreen.this.edited && !hasErrors;
                this.setMessage(ClothConfigScreen.this.displayErrors && hasErrors ? I18n.func_135052_a((String)"text.cloth-config.error_cannot_save", (Object[])new Object[0]) : I18n.func_135052_a((String)"text.cloth-config.save_and_done", (Object[])new Object[0]));
                super.render(int_1, int_2, float_1);
            }
        };
        this.addButton(this.buttonSave);
        this.buttonSave.active = this.edited;
        this.tabsBounds = new Rectangle(0, 41, this.width, 24);
        this.tabsLeftBounds = new Rectangle(0, 41, 18, 24);
        this.tabsRightBounds = new Rectangle(this.width - 18, 41, 18, 24);
        this.buttonLeftTab = new AbstractButton(4, 44, 12, 18, ""){

            public void onPress() {
                ClothConfigScreen.this.tabsScrollProgress = -2.147483648E9;
                ClothConfigScreen.this.tabsScrollVelocity = 0.0;
                ClothConfigScreen.this.clampTabsScrolled();
            }

            public void renderButton(int int_1, int int_2, float float_1) {
                ClothConfigScreen.this.minecraft.func_110434_K().func_110577_a(CONFIG_TEX);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                int int_3 = this.getYImage(this.isHovered());
                GlStateManager.enableBlend();
                GlStateManager.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                GlStateManager.blendFunc((int)770, (int)771);
                this.blit(this.x, this.y, 12, 18 * int_3, this.width, this.height);
            }
        };
        this.children.add(this.buttonLeftTab);
        int j = 0;
        for (Pair<String, Integer> tab : this.tabs) {
            this.tabButtons.add(new ClothConfigTabButton(this, j, -100, 43, (Integer)tab.getSecond(), 20, I18n.func_135052_a((String)((String)tab.getFirst()), (Object[])new Object[0])));
            ++j;
        }
        this.tabButtons.forEach(this.children::add);
        this.buttonRightTab = new AbstractButton(this.width - 16, 44, 12, 18, ""){

            public void onPress() {
                ClothConfigScreen.this.tabsScrollProgress = 2.147483647E9;
                ClothConfigScreen.this.tabsScrollVelocity = 0.0;
                ClothConfigScreen.this.clampTabsScrolled();
            }

            public void renderButton(int int_1, int int_2, float float_1) {
                ClothConfigScreen.this.minecraft.func_110434_K().func_110577_a(CONFIG_TEX);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                int int_3 = this.getYImage(this.isHovered());
                GlStateManager.enableBlend();
                GlStateManager.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                GlStateManager.blendFunc((int)770, (int)771);
                this.blit(this.x, this.y, 0, 18 * int_3, this.width, this.height);
            }
        };
        this.children.add(this.buttonRightTab);
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (this.tabsBounds.contains(double_1, double_2) && !this.tabsLeftBounds.contains(double_1, double_2) && !this.tabsRightBounds.contains(double_1, double_2) && double_3 != 0.0) {
            if (double_3 < 0.0) {
                this.tabsScrollVelocity += 16.0;
            }
            if (double_3 > 0.0) {
                this.tabsScrollVelocity -= 16.0;
            }
            return true;
        }
        return super.mouseScrolled(double_1, double_2, double_3);
    }

    public double getTabsMaximumScrolled() {
        if (this.tabsMaximumScrolled == -1.0) {
            AtomicDouble d = new AtomicDouble();
            this.tabs.forEach(pair -> d.addAndGet((double)((Integer)pair.getSecond() + 2)));
            this.tabsMaximumScrolled = d.get();
        }
        return this.tabsMaximumScrolled;
    }

    public void resetTabsMaximumScrolled() {
        this.tabsMaximumScrolled = -1.0;
        this.tabsScrollVelocity = 0.0;
    }

    public void clampTabsScrolled() {
        int xx = 0;
        for (ClothConfigTabButton tabButton : this.tabButtons) {
            xx += tabButton.getWidth() + 2;
        }
        this.tabsScrollProgress = xx > this.width - 40 ? MathHelper.func_151237_a((double)this.tabsScrollProgress, (double)0.0, (double)(this.getTabsMaximumScrolled() - (double)this.width + 40.0)) : 0.0;
    }

    public void render(int int_1, int int_2, float float_1) {
        if (this.smoothScrollingTabs) {
            double change = this.tabsScrollVelocity * (double)0.2f;
            if (change != 0.0) {
                if (change > 0.0 && change < 0.2) {
                    change = 0.2;
                } else if (change < 0.0 && change > -0.2) {
                    change = -0.2;
                }
                this.tabsScrollProgress += change;
                this.tabsScrollVelocity -= change;
                if (change > 0.0 == this.tabsScrollVelocity < 0.0) {
                    this.tabsScrollVelocity = 0.0;
                }
                this.clampTabsScrolled();
            }
        } else {
            this.tabsScrollProgress += this.tabsScrollVelocity;
            this.tabsScrollVelocity = 0.0;
            this.clampTabsScrolled();
        }
        int xx = 20 - (int)this.tabsScrollProgress;
        for (ClothConfigTabButton tabButton : this.tabButtons) {
            tabButton.x = xx;
            xx += tabButton.getWidth() + 2;
        }
        this.buttonLeftTab.active = this.tabsScrollProgress > 0.0;
        this.buttonRightTab.active = this.tabsScrollProgress < this.getTabsMaximumScrolled() - (double)this.width + 40.0;
        this.renderDirtBackground(0);
        this.listWidget.render(int_1, int_2, float_1);
        this.overlayBackground(this.tabsBounds, 32, 32, 32, 255, 255);
        this.drawCenteredString(this.minecraft.field_71466_p, this.title, this.width / 2, 18, -1);
        this.tabButtons.forEach(widget -> widget.render(int_1, int_2, float_1));
        this.overlayBackground(this.tabsLeftBounds, 64, 64, 64, 255, 255);
        this.overlayBackground(this.tabsRightBounds, 64, 64, 64, 255, 255);
        this.drawShades();
        this.buttonLeftTab.render(int_1, int_2, float_1);
        this.buttonRightTab.render(int_1, int_2, float_1);
        if (this.displayErrors && this.isEditable()) {
            ArrayList errors = Lists.newArrayList();
            for (List entries : Lists.newArrayList(this.tabbedEntries.values())) {
                for (AbstractConfigEntry entry : entries) {
                    if (!entry.getConfigError().isPresent()) continue;
                    errors.add(entry.getConfigError().get());
                }
            }
            if (errors.size() > 0) {
                this.minecraft.func_110434_K().func_110577_a(CONFIG_TEX);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.blit(10, 10, 0, 54, 3, 11);
                if (errors.size() == 1) {
                    this.drawString(this.minecraft.field_71466_p, "\u00a7c" + (String)errors.get(0), 18, 12, -1);
                } else {
                    this.drawString(this.minecraft.field_71466_p, "\u00a7c" + I18n.func_135052_a((String)"text.cloth-config.multi_error", (Object[])new Object[0]), 18, 12, -1);
                }
            }
        } else if (!this.isEditable()) {
            this.minecraft.func_110434_K().func_110577_a(CONFIG_TEX);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.blit(10, 10, 0, 54, 3, 11);
            this.drawString(this.minecraft.field_71466_p, "\u00a7c" + I18n.func_135052_a((String)"text.cloth-config.not_editable", (Object[])new Object[0]), 18, 12, -1);
        }
        super.render(int_1, int_2, float_1);
        this.queuedTooltips.forEach(queuedTooltip -> this.renderTooltip(queuedTooltip.getText(), queuedTooltip.getX(), queuedTooltip.getY()));
        this.queuedTooltips.clear();
    }

    public void queueTooltip(QueuedTooltip queuedTooltip) {
        this.queuedTooltips.add(queuedTooltip);
    }

    private void drawShades() {
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        GlStateManager.disableAlphaTest();
        GlStateManager.shadeModel((int)7425);
        GlStateManager.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)(this.tabsBounds.getMinX() + 20), (double)(this.tabsBounds.getMinY() + 4), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)(this.tabsBounds.getMaxX() - 20), (double)(this.tabsBounds.getMinY() + 4), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)(this.tabsBounds.getMaxX() - 20), (double)this.tabsBounds.getMinY(), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b((double)(this.tabsBounds.getMinX() + 20), (double)this.tabsBounds.getMinY(), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)(this.tabsBounds.getMinX() + 20), (double)this.tabsBounds.getMaxY(), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b((double)(this.tabsBounds.getMaxX() - 20), (double)this.tabsBounds.getMaxY(), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b((double)(this.tabsBounds.getMaxX() - 20), (double)(this.tabsBounds.getMaxY() - 4), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)(this.tabsBounds.getMinX() + 20), (double)(this.tabsBounds.getMaxY() - 4), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.enableAlphaTest();
        GlStateManager.disableBlend();
    }

    protected void overlayBackground(Rectangle rect, int red, int green, int blue, int startAlpha, int endAlpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(this.getBackgroundLocation());
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)rect.getMinX(), (double)rect.getMaxY(), 0.0).func_187315_a((double)rect.getMinX() / 32.0, (double)rect.getMaxY() / 32.0).func_181669_b(red, green, blue, endAlpha).func_181675_d();
        buffer.func_181662_b((double)rect.getMaxX(), (double)rect.getMaxY(), 0.0).func_187315_a((double)rect.getMaxX() / 32.0, (double)rect.getMaxY() / 32.0).func_181669_b(red, green, blue, endAlpha).func_181675_d();
        buffer.func_181662_b((double)rect.getMaxX(), (double)rect.getMinY(), 0.0).func_187315_a((double)rect.getMaxX() / 32.0, (double)rect.getMinY() / 32.0).func_181669_b(red, green, blue, startAlpha).func_181675_d();
        buffer.func_181662_b((double)rect.getMinX(), (double)rect.getMinY(), 0.0).func_187315_a((double)rect.getMinX() / 32.0, (double)rect.getMinY() / 32.0).func_181669_b(red, green, blue, startAlpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 256 && this.shouldCloseOnEsc()) {
            if (this.confirmSave && this.edited) {
                this.minecraft.func_147108_a((Screen)new ConfirmScreen((BooleanConsumer)new QuitSaveConsumer(), (ITextComponent)new TranslationTextComponent("text.cloth-config.quit_config", new Object[0]), (ITextComponent)new TranslationTextComponent("text.cloth-config.quit_config_sure", new Object[0]), I18n.func_135052_a((String)"text.cloth-config.quit_discard", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
            } else {
                this.minecraft.func_147108_a(this.parent);
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public abstract void onSave(Map<String, List<Pair<String, Object>>> var1);

    public boolean isEditable() {
        return true;
    }

    public class ListWidget
    extends DynamicElementListWidget {
        public ListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
            this.visible = false;
        }

        @Override
        public int getItemWidth() {
            return this.width - 80;
        }

        public ClothConfigScreen getScreen() {
            return ClothConfigScreen.this;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.width - 36;
        }

        protected final void clearStuff() {
            this.clearItems();
        }
    }

    private class QuitSaveConsumer
    implements BooleanConsumer {
        private QuitSaveConsumer() {
        }

        public void accept(boolean t) {
            if (!t) {
                ClothConfigScreen.this.minecraft.func_147108_a((Screen)ClothConfigScreen.this);
            } else {
                ClothConfigScreen.this.minecraft.func_147108_a(ClothConfigScreen.this.parent);
            }
        }
    }
}

