/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.forge.clothconfig2.gui.entries.BaseListCell;
import me.shedaniel.forge.clothconfig2.gui.entries.BaseListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;

public class DoubleListListEntry
extends BaseListEntry<Double, DoubleListCell> {
    private double minimum = -1.7976931348623157E308;
    private double maximum = Double.MAX_VALUE;
    private Function<Double, Optional<String>> cellErrorSupplier;

    @Deprecated
    public DoubleListListEntry(String fieldName, List<Double> value, boolean defaultExpended, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Double>> saveConsumer, Supplier<List<Double>> defaultValue, String resetButtonKey) {
        this(fieldName, value, defaultExpended, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    public DoubleListListEntry(String fieldName, List<Double> value, boolean defaultExpended, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Double>> saveConsumer, Supplier<List<Double>> defaultValue, String resetButtonKey, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, defaultValue, (BaseListEntry baseListEntry) -> new DoubleListCell(0.0, (DoubleListListEntry)((Object)baseListEntry)), saveConsumer, resetButtonKey, requiresRestart);
        for (Double f : value) {
            this.cells.add(new DoubleListCell(f, this));
        }
        this.widgets.addAll(this.cells);
        this.expended = defaultExpended;
    }

    public Function<Double, Optional<String>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public void setCellErrorSupplier(Function<Double, Optional<String>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
    }

    @Override
    public List<Double> getValue() {
        return this.cells.stream().map(DoubleListCell::getValue).collect(Collectors.toList());
    }

    public DoubleListListEntry setMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public DoubleListListEntry setMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    protected DoubleListCell getFromValue(Double value) {
        return new DoubleListCell(value, this);
    }

    public static class DoubleListCell
    extends BaseListCell {
        private Function<String, String> stripCharacters = s -> {
            StringBuilder stringBuilder_1 = new StringBuilder();
            char[] var2 = s.toCharArray();
            int var3 = var2.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                if (!Character.isDigit(var2[var4]) && var2[var4] != '-' && var2[var4] != '.') continue;
                stringBuilder_1.append(var2[var4]);
            }
            return stringBuilder_1.toString();
        };
        private TextFieldWidget widget;
        private boolean isSelected;
        private DoubleListListEntry listListEntry;

        public DoubleListCell(double value, DoubleListListEntry listListEntry) {
            this.listListEntry = listListEntry;
            this.setErrorSupplier(() -> listListEntry.cellErrorSupplier == null ? Optional.empty() : listListEntry.getCellErrorSupplier().apply(this.getValue()));
            this.widget = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, 100, 18, ""){

                public void render(int int_1, int int_2, float Double_1) {
                    boolean f = this.isFocused();
                    this.setFocused(isSelected);
                    widget.func_146193_g(this.getPreferredTextColor());
                    super.render(int_1, int_2, Double_1);
                    this.setFocused(f);
                }

                public void func_146191_b(String string_1) {
                    super.func_146191_b((String)stripCharacters.apply(string_1));
                }
            };
            this.widget.func_146203_f(999999);
            this.widget.func_146185_a(false);
            this.widget.func_146180_a(value + "");
            this.widget.func_212954_a(s -> {
                if (!(value + "").equalsIgnoreCase((String)s)) {
                    listListEntry.getScreen().setEdited(true, listListEntry.isRequiresRestart());
                }
            });
        }

        public double getValue() {
            try {
                return Double.valueOf(this.widget.func_146179_b());
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @Override
        public Optional<String> getError() {
            try {
                double i = Double.valueOf(this.widget.func_146179_b());
                if (i > this.listListEntry.maximum) {
                    return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_large", (Object[])new Object[]{this.listListEntry.maximum}));
                }
                if (i < this.listListEntry.minimum) {
                    return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_small", (Object[])new Object[]{this.listListEntry.minimum}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.not_valid_number_double", (Object[])new Object[0]));
            }
            return Optional.empty();
        }

        @Override
        public int getCellHeight() {
            return 20;
        }

        @Override
        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.widget.setWidth(entryWidth - 12);
            this.widget.x = x;
            this.widget.y = y + 1;
            this.widget.func_146184_c(this.listListEntry.isEditable());
            this.isSelected = isSelected;
            this.widget.render(mouseX, mouseY, delta);
            if (isSelected && this.listListEntry.isEditable()) {
                DoubleListCell.fill((int)x, (int)(y + 12), (int)(x + entryWidth - 12), (int)(y + 13), (int)(this.getConfigError().isPresent() ? -43691 : -2039584));
            }
        }

        public List<? extends IGuiEventListener> children() {
            return Collections.singletonList(this.widget);
        }
    }
}

