/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.forge.clothconfig2.gui.entries.TextFieldListEntry;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;

public class LongListEntry
extends TextFieldListEntry<Long> {
    private static Function<String, String> stripCharacters = s -> {
        StringBuilder stringBuilder_1 = new StringBuilder();
        char[] var2 = s.toCharArray();
        int var3 = var2.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            if (!Character.isDigit(var2[var4]) && var2[var4] != '-') continue;
            stringBuilder_1.append(var2[var4]);
        }
        return stringBuilder_1.toString();
    };
    private long minimum = -9223372036854775807L;
    private long maximum = Long.MAX_VALUE;
    private Consumer<Long> saveConsumer;

    public LongListEntry(String fieldName, Long value, String resetButtonKey, Supplier<Long> defaultValue, Consumer<Long> saveConsumer, Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveConsumer = saveConsumer;
    }

    @Override
    protected String stripAddText(String s) {
        return stripCharacters.apply(s);
    }

    @Override
    protected void textFieldPreRender(TextFieldWidget widget) {
        try {
            double i = Long.valueOf(this.textFieldWidget.func_146179_b()).longValue();
            if (i < (double)this.minimum || i > (double)this.maximum) {
                widget.func_146193_g(0xFF5555);
            } else {
                widget.func_146193_g(0xE0E0E0);
            }
        }
        catch (NumberFormatException ex) {
            widget.func_146193_g(0xFF5555);
        }
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        return this.getDefaultValue().isPresent() ? text.equals(((Long)this.defaultValue.get()).toString()) : false;
    }

    public LongListEntry setMinimum(long minimum) {
        this.minimum = minimum;
        return this;
    }

    public LongListEntry setMaximum(long maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public Long getValue() {
        try {
            return Long.valueOf(this.textFieldWidget.func_146179_b());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public Optional<String> getError() {
        try {
            long i = Long.valueOf(this.textFieldWidget.func_146179_b());
            if (i > this.maximum) {
                return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_large", (Object[])new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_small", (Object[])new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.not_valid_number_long", (Object[])new Object[0]));
        }
        return super.getError();
    }
}

