/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.forge.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;

public class LongSliderEntry
extends TooltipListEntry<Long> {
    protected Slider sliderWidget;
    protected Button resetButton;
    protected AtomicLong value;
    private long minimum;
    private long maximum;
    private Consumer<Long> saveConsumer;
    private Supplier<Long> defaultValue;
    private Function<Long, String> textGetter = value -> String.format("Value: %d", value);
    private List<IGuiEventListener> widgets;

    @Deprecated
    public LongSliderEntry(String fieldName, long minimum, long maximum, long value2, Consumer<Long> saveConsumer, String resetButtonKey, Supplier<Long> defaultValue, Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.value = new AtomicLong(value2);
        this.saveConsumer = saveConsumer;
        this.maximum = maximum;
        this.minimum = minimum;
        this.sliderWidget = new Slider(0, 0, 152, 20, ((double)this.value.get() - (double)minimum) / (double)Math.abs(maximum - minimum));
        this.resetButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)resetButtonKey, (Object[])new Object[0])) + 6, 20, I18n.func_135052_a((String)resetButtonKey, (Object[])new Object[0]), widget -> {
            this.sliderWidget.setValue((double)(MathHelper.func_76131_a((float)this.defaultValue.get().longValue(), (float)minimum, (float)maximum) - (float)minimum) / (double)Math.abs(maximum - minimum));
            this.value.set(Math.min(Math.max(this.defaultValue.get(), minimum), maximum));
            this.sliderWidget.updateMessage();
            this.getScreen().setEdited(true, this.isRequiresRestart());
        });
        this.sliderWidget.setMessage(this.textGetter.apply(this.value.get()));
        this.widgets = Lists.newArrayList((Object[])new IGuiEventListener[]{this.sliderWidget, this.resetButton});
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public Function<Long, String> getTextGetter() {
        return this.textGetter;
    }

    public LongSliderEntry setTextGetter(Function<Long, String> textGetter) {
        this.textGetter = textGetter;
        this.sliderWidget.setMessage(textGetter.apply(this.value.get()));
        return this;
    }

    @Override
    public Long getValue() {
        return this.value.get();
    }

    @Override
    public Optional<Long> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public List<? extends IGuiEventListener> children() {
        return this.widgets;
    }

    public LongSliderEntry setMaximum(long maximum) {
        this.maximum = maximum;
        return this;
    }

    public LongSliderEntry setMinimum(long minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        MainWindow window = Minecraft.func_71410_x().field_195558_d;
        this.resetButton.active = this.isEditable() && this.getDefaultValue().isPresent() && this.defaultValue.get().longValue() != this.value.get();
        this.resetButton.y = y;
        this.sliderWidget.active = this.isEditable();
        this.sliderWidget.y = y;
        if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]), (float)(window.func_198107_o() - x - Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]))), (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x;
            this.sliderWidget.x = x + this.resetButton.getWidth() + 1;
            this.sliderWidget.setWidth(150 - this.resetButton.getWidth() - 2);
        } else {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]), (float)x, (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x + entryWidth - this.resetButton.getWidth();
            this.sliderWidget.x = x + entryWidth - 150;
            this.sliderWidget.setWidth(150 - this.resetButton.getWidth() - 2);
        }
        this.resetButton.render(mouseX, mouseY, delta);
        this.sliderWidget.render(mouseX, mouseY, delta);
    }

    private class Slider
    extends AbstractSlider {
        protected Slider(int int_1, int int_2, int int_3, int int_4, double double_1) {
            super(int_1, int_2, int_3, int_4, double_1);
        }

        public void updateMessage() {
            this.setMessage((String)LongSliderEntry.this.textGetter.apply(LongSliderEntry.this.value.get()));
        }

        protected void applyValue() {
            LongSliderEntry.this.value.set((long)((double)LongSliderEntry.this.minimum + (double)Math.abs(LongSliderEntry.this.maximum - LongSliderEntry.this.minimum) * this.value));
            LongSliderEntry.this.getScreen().setEdited(true, LongSliderEntry.this.isRequiresRestart());
        }

        public boolean keyPressed(int int_1, int int_2, int int_3) {
            if (!LongSliderEntry.this.isEditable()) {
                return false;
            }
            return super.keyPressed(int_1, int_2, int_3);
        }

        public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
            if (!LongSliderEntry.this.isEditable()) {
                return false;
            }
            return super.mouseDragged(double_1, double_2, int_1, double_3, double_4);
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double integer) {
            this.value = integer;
        }
    }
}

