/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.forge.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;

public abstract class TextFieldListEntry<T>
extends TooltipListEntry<T> {
    protected TextFieldWidget textFieldWidget;
    protected Button resetButton;
    protected Supplier<T> defaultValue;
    protected T original;
    protected List<IGuiEventListener> widgets;

    protected TextFieldListEntry(String fieldName, T original, String resetButtonKey, Supplier<T> defaultValue, Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.original = original;
        this.textFieldWidget = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, 148, 18, ""){

            public void render(int int_1, int int_2, float float_1) {
                boolean f = this.isFocused();
                this.setFocused(TextFieldListEntry.this.getParent().getFocused() == TextFieldListEntry.this && TextFieldListEntry.this.getFocused() == this);
                TextFieldListEntry.this.textFieldPreRender(this);
                super.render(int_1, int_2, float_1);
                this.setFocused(f);
            }

            public void func_146191_b(String string_1) {
                super.func_146191_b(TextFieldListEntry.this.stripAddText(string_1));
            }
        };
        this.textFieldWidget.func_146203_f(999999);
        this.textFieldWidget.func_146180_a(String.valueOf(original));
        this.textFieldWidget.func_212954_a(s -> {
            if (!original.equals(s)) {
                this.getScreen().setEdited(true, this.isRequiresRestart());
            }
        });
        this.resetButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)resetButtonKey, (Object[])new Object[0])) + 6, 20, I18n.func_135052_a((String)resetButtonKey, (Object[])new Object[0]), widget -> {
            this.textFieldWidget.func_146180_a(String.valueOf(defaultValue.get()));
            this.getScreen().setEdited(true, this.isRequiresRestart());
        });
        this.widgets = Lists.newArrayList((Object[])new IGuiEventListener[]{this.textFieldWidget, this.resetButton});
    }

    protected static void setTextFieldWidth(TextFieldWidget widget, int width) {
        widget.setWidth(width);
    }

    protected String stripAddText(String s) {
        return s;
    }

    protected void textFieldPreRender(TextFieldWidget widget) {
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        MainWindow window = Minecraft.func_71410_x().field_195558_d;
        this.resetButton.active = this.isEditable() && this.getDefaultValue().isPresent() && !this.isMatchDefault(this.textFieldWidget.func_146179_b());
        this.resetButton.y = y;
        this.textFieldWidget.func_146184_c(this.isEditable());
        this.textFieldWidget.y = y + 1;
        if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]), (float)(window.func_198107_o() - x - Minecraft.func_71410_x().field_71466_p.func_78256_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]))), (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x;
            this.textFieldWidget.x = x + this.resetButton.getWidth();
            TextFieldListEntry.setTextFieldWidth(this.textFieldWidget, 148 - this.resetButton.getWidth() - 4);
        } else {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)this.getFieldName(), (Object[])new Object[0]), (float)x, (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.x = x + entryWidth - this.resetButton.getWidth();
            this.textFieldWidget.x = x + entryWidth - 148;
            TextFieldListEntry.setTextFieldWidth(this.textFieldWidget, 148 - this.resetButton.getWidth() - 4);
        }
        this.resetButton.render(mouseX, mouseY, delta);
        this.textFieldWidget.render(mouseX, mouseY, delta);
    }

    protected abstract boolean isMatchDefault(String var1);

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public List<? extends IGuiEventListener> children() {
        return this.widgets;
    }
}

