/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class DynamicEntryListWidget<E extends Entry<E>>
extends FocusableGui
implements IRenderable {
    protected static final int DRAG_OUTSIDE = -2;
    protected final Minecraft client;
    private final List<E> entries = new Entries();
    protected int width;
    protected int height;
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    protected boolean verticallyCenter = true;
    protected int yDrag = -2;
    protected boolean visible = true;
    protected boolean renderSelection;
    protected int headerHeight;
    protected double scroll;
    protected boolean scrolling;
    protected E selectedItem;
    protected ResourceLocation backgroundLocation;

    public DynamicEntryListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
        this.backgroundLocation = backgroundLocation;
    }

    public void setRenderSelection(boolean boolean_1) {
        this.visible = boolean_1;
    }

    protected void setRenderHeader(boolean boolean_1, int headerHeight) {
        this.renderSelection = boolean_1;
        this.headerHeight = headerHeight;
        if (!boolean_1) {
            this.headerHeight = 0;
        }
    }

    public int getItemWidth() {
        return 220;
    }

    public E getSelectedItem() {
        return this.selectedItem;
    }

    public void selectItem(E item) {
        this.selectedItem = item;
    }

    public E getFocused() {
        return (E)((Object)((Entry)super.getFocused()));
    }

    public final List<E> children() {
        return this.entries;
    }

    protected final void clearItems() {
        this.entries.clear();
    }

    protected E getItem(int index) {
        return (E)((Object)((Entry)((Object)this.children().get(index))));
    }

    protected int addItem(E item) {
        this.entries.add(item);
        return this.entries.size() - 1;
    }

    protected int getItemCount() {
        return this.children().size();
    }

    protected boolean isSelected(int index) {
        return Objects.equals(this.getSelectedItem(), this.children().get(index));
    }

    protected final E getItemAtPosition(double mouseX, double mouseY) {
        int listMiddleX = this.left + this.width / 2;
        int minX = listMiddleX - this.getItemWidth() / 2;
        int maxX = listMiddleX + this.getItemWidth() / 2;
        int currentY = MathHelper.func_76128_c((double)(mouseY - (double)this.top)) - this.headerHeight + (int)this.getScroll() - 4;
        int itemY = 0;
        int itemIndex = -1;
        for (int i = 0; i < this.entries.size(); ++i) {
            E item = this.getItem(i);
            if ((itemY += ((Entry)((Object)item)).getItemHeight()) <= currentY) continue;
            itemIndex = i;
            break;
        }
        return (E)((Object)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && itemIndex >= 0 && currentY >= 0 && itemIndex < this.getItemCount() ? (Entry)((Object)this.children().get(itemIndex)) : null));
    }

    public void updateSize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setLeftPos(int left) {
        this.left = left;
        this.right = left + this.width;
    }

    protected int getMaxScrollPosition() {
        int i = this.headerHeight;
        for (Entry entry : this.entries) {
            i += entry.getItemHeight();
        }
        return i;
    }

    protected void clickedHeader(int int_1, int int_2) {
    }

    protected void renderHeader(int int_1, int int_2, Tessellator tessellator) {
    }

    protected void drawBackground() {
    }

    protected void renderDecorations(int int_1, int int_2) {
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.drawBackground();
        int scrollbarPosition = this.getScrollbarPosition();
        int int_4 = scrollbarPosition + 6;
        GlStateManager.disableLighting();
        GlStateManager.disableFog();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.client.func_110434_K().func_110577_a(this.backgroundLocation);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float float_2 = 32.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)this.left, (double)this.bottom, 0.0).func_187315_a((double)((float)this.left / 32.0f), (double)((float)(this.bottom + (int)this.getScroll()) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.right, (double)this.bottom, 0.0).func_187315_a((double)((float)this.right / 32.0f), (double)((float)(this.bottom + (int)this.getScroll()) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.right, (double)this.top, 0.0).func_187315_a((double)((float)this.right / 32.0f), (double)((float)(this.top + (int)this.getScroll()) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.left, (double)this.top, 0.0).func_187315_a((double)((float)this.left / 32.0f), (double)((float)(this.top + (int)this.getScroll()) / 32.0f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        tessellator.func_78381_a();
        int rowLeft = this.getRowLeft();
        int startY = this.top + 4 - (int)this.getScroll();
        if (this.renderSelection) {
            this.renderHeader(rowLeft, startY, tessellator);
        }
        this.renderList(rowLeft, startY, mouseX, mouseY, delta);
        GlStateManager.disableDepthTest();
        this.renderHoleBackground(0, this.top, 255, 255);
        this.renderHoleBackground(this.bottom, this.height, 255, 255);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.disableAlphaTest();
        GlStateManager.shadeModel((int)7425);
        GlStateManager.disableTexture();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)this.left, (double)(this.top + 4), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)this.right, (double)(this.top + 4), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)this.right, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b((double)this.left, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)this.left, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b((double)this.right, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        buffer.func_181662_b((double)this.right, (double)(this.bottom - 4), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        buffer.func_181662_b((double)this.left, (double)(this.bottom - 4), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        int maxScroll = this.getMaxScroll();
        this.renderScrollBar(tessellator, buffer, maxScroll, scrollbarPosition, int_4);
        this.renderDecorations(mouseX, mouseY);
        GlStateManager.enableTexture();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.enableAlphaTest();
        GlStateManager.disableBlend();
    }

    protected void renderScrollBar(Tessellator tessellator, BufferBuilder buffer, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (maxScroll > 0) {
            int int_9 = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            int_9 = MathHelper.func_76125_a((int)int_9, (int)32, (int)(this.bottom - this.top - 8));
            int int_10 = (int)this.getScroll() * (this.bottom - this.top - int_9) / maxScroll + this.top;
            if (int_10 < this.top) {
                int_10 = this.top;
            }
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)(int_10 + int_9), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)(int_10 + int_9), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)int_10, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)int_10, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)(int_10 + int_9 - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            buffer.func_181662_b((double)(scrollbarPositionMaxX - 1), (double)(int_10 + int_9 - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            buffer.func_181662_b((double)(scrollbarPositionMaxX - 1), (double)int_10, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)int_10, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    protected void centerScrollOn(E item) {
        double d = (this.bottom - this.top) / -2;
        for (int i = 0; i < this.children().indexOf(item) && i < this.getItemCount(); ++i) {
            d += (double)((Entry)((Object)this.getItem(i))).getItemHeight();
        }
        this.capYPosition(d);
    }

    protected void ensureVisible(E item) {
        int int_3;
        int rowTop = this.getRowTop(this.children().indexOf(item));
        int int_2 = rowTop - this.top - 4 - ((Entry)((Object)item)).getItemHeight();
        if (int_2 < 0) {
            this.scroll(int_2);
        }
        if ((int_3 = this.bottom - rowTop - ((Entry)((Object)item)).getItemHeight() * 2) < 0) {
            this.scroll(-int_3);
        }
    }

    protected void scroll(int int_1) {
        this.capYPosition(this.getScroll() + (double)int_1);
        this.yDrag = -2;
    }

    public double getScroll() {
        return this.scroll;
    }

    public void capYPosition(double double_1) {
        this.scroll = MathHelper.func_151237_a((double)double_1, (double)0.0, (double)this.getMaxScroll());
    }

    protected int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - (this.bottom - this.top - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScroll() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        this.scrolling = int_1 == 0 && double_1 >= (double)this.getScrollbarPosition() && double_1 < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        this.updateScrollingState(double_1, double_2, int_1);
        if (!this.isMouseOver(double_1, double_2)) {
            return false;
        }
        E item = this.getItemAtPosition(double_1, double_2);
        if (item != null) {
            if (item.mouseClicked(double_1, double_2, int_1)) {
                this.setFocused((IGuiEventListener)item);
                this.setDragging(true);
                return true;
            }
        } else if (int_1 == 0) {
            this.clickedHeader((int)(double_1 - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(double_2 - (double)this.top) + (int)this.getScroll() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean mouseReleased(double double_1, double double_2, int int_1) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(double_1, double_2, int_1);
        }
        return false;
    }

    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (super.mouseDragged(double_1, double_2, int_1, double_3, double_4)) {
            return true;
        }
        if (int_1 == 0 && this.scrolling) {
            if (double_2 < (double)this.top) {
                this.capYPosition(0.0);
            } else if (double_2 > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = MathHelper.func_76125_a((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(this.getScroll() + double_4 * double_6);
            }
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        this.capYPosition(this.getScroll() - double_3 * (double)(this.getMaxScroll() / this.getItemCount()) / 2.0);
        return true;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (super.keyPressed(int_1, int_2, int_3)) {
            return true;
        }
        if (int_1 == 264) {
            this.moveSelection(1);
            return true;
        }
        if (int_1 == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int int_1) {
        if (!this.children().isEmpty()) {
            int int_2 = this.children().indexOf(this.getSelectedItem());
            int int_3 = MathHelper.func_76125_a((int)(int_2 + int_1), (int)0, (int)(this.getItemCount() - 1));
            Entry itemListWidget$Item_1 = (Entry)((Object)this.children().get(int_3));
            this.selectItem(itemListWidget$Item_1);
            this.ensureVisible(itemListWidget$Item_1);
        }
    }

    public boolean isMouseOver(double double_1, double double_2) {
        return double_2 >= (double)this.top && double_2 <= (double)this.bottom && double_1 >= (double)this.left && double_1 <= (double)this.right;
    }

    protected void renderList(int startX, int startY, int int_3, int int_4, float float_1) {
        int itemCount = this.getItemCount();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        for (int renderIndex = 0; renderIndex < itemCount; ++renderIndex) {
            E item = this.getItem(renderIndex);
            int itemY = startY + this.headerHeight;
            for (int i = 0; i < this.entries.size() && i < renderIndex; ++i) {
                itemY += ((Entry)((Object)this.entries.get(i))).getItemHeight();
            }
            int itemHeight = ((Entry)((Object)item)).getItemHeight() - 4;
            int itemWidth = this.getItemWidth();
            if (this.visible && this.isSelected(renderIndex)) {
                int itemMinX = this.left + this.width / 2 - itemWidth / 2;
                int itemMaxX = itemMinX + itemWidth;
                GlStateManager.disableTexture();
                float float_2 = this.isFocused() ? 1.0f : 0.5f;
                GlStateManager.color4f((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                buffer.func_181662_b((double)itemMinX, (double)(itemY + itemHeight + 2), 0.0).func_181675_d();
                buffer.func_181662_b((double)itemMaxX, (double)(itemY + itemHeight + 2), 0.0).func_181675_d();
                buffer.func_181662_b((double)itemMaxX, (double)(itemY - 2), 0.0).func_181675_d();
                buffer.func_181662_b((double)itemMinX, (double)(itemY - 2), 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                buffer.func_181662_b((double)(itemMinX + 1), (double)(itemY + itemHeight + 1), 0.0).func_181675_d();
                buffer.func_181662_b((double)(itemMaxX - 1), (double)(itemY + itemHeight + 1), 0.0).func_181675_d();
                buffer.func_181662_b((double)(itemMaxX - 1), (double)(itemY - 1), 0.0).func_181675_d();
                buffer.func_181662_b((double)(itemMinX + 1), (double)(itemY - 1), 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.enableTexture();
            }
            int y = this.getRowTop(renderIndex);
            int x = this.getRowLeft();
            RenderHelper.func_74518_a();
            ((Entry)((Object)item)).render(renderIndex, y, x, itemWidth, itemHeight, int_3, int_4, this.isMouseOver(int_3, int_4) && Objects.equals(this.getItemAtPosition(int_3, int_4), item), float_1);
        }
    }

    protected int getRowLeft() {
        return this.left + this.width / 2 - this.getItemWidth() / 2 + 2;
    }

    protected int getRowTop(int index) {
        int integer = this.top + 4 - (int)this.getScroll() + this.headerHeight;
        for (int i = 0; i < this.entries.size() && i < index; ++i) {
            integer += ((Entry)((Object)this.entries.get(i))).getItemHeight();
        }
        return integer;
    }

    protected boolean isFocused() {
        return false;
    }

    protected void renderHoleBackground(int int_1, int int_2, int int_3, int int_4) {
        Tessellator tessellator_1 = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder_1 = tessellator_1.func_178180_c();
        this.client.func_110434_K().func_110577_a(this.backgroundLocation);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float float_1 = 32.0f;
        bufferBuilder_1.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferBuilder_1.func_181662_b((double)this.left, (double)int_2, 0.0).func_187315_a(0.0, (double)((float)int_2 / 32.0f)).func_181669_b(64, 64, 64, int_4).func_181675_d();
        bufferBuilder_1.func_181662_b((double)(this.left + this.width), (double)int_2, 0.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)int_2 / 32.0f)).func_181669_b(64, 64, 64, int_4).func_181675_d();
        bufferBuilder_1.func_181662_b((double)(this.left + this.width), (double)int_1, 0.0).func_187315_a((double)((float)this.width / 32.0f), (double)((float)int_1 / 32.0f)).func_181669_b(64, 64, 64, int_3).func_181675_d();
        bufferBuilder_1.func_181662_b((double)this.left, (double)int_1, 0.0).func_187315_a(0.0, (double)((float)int_1 / 32.0f)).func_181669_b(64, 64, 64, int_3).func_181675_d();
        tessellator_1.func_78381_a();
    }

    protected E remove(int int_1) {
        Entry itemListWidget$Item_1 = (Entry)((Object)this.entries.get(int_1));
        return (E)((Object)(this.removeEntry((Entry)((Object)this.entries.get(int_1))) ? itemListWidget$Item_1 : null));
    }

    protected boolean removeEntry(E itemListWidget$Item_1) {
        boolean boolean_1 = this.entries.remove(itemListWidget$Item_1);
        if (boolean_1 && itemListWidget$Item_1 == this.getSelectedItem()) {
            this.selectItem(null);
        }
        return boolean_1;
    }

    @OnlyIn(value=Dist.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final ArrayList<E> items = Lists.newArrayList();

        private Entries() {
        }

        @Override
        public void clear() {
            this.items.clear();
        }

        @Override
        public E get(int int_1) {
            return (Object)((Entry)((Object)this.items.get(int_1)));
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public E set(int int_1, E itemListWidget$Item_1) {
            Entry itemListWidget$Item_2 = (Entry)((Object)this.items.set(int_1, itemListWidget$Item_1));
            ((Entry)((Object)itemListWidget$Item_1)).parent = DynamicEntryListWidget.this;
            return (Object)itemListWidget$Item_2;
        }

        @Override
        public void add(int int_1, E itemListWidget$Item_1) {
            this.items.add(int_1, itemListWidget$Item_1);
            ((Entry)((Object)itemListWidget$Item_1)).parent = DynamicEntryListWidget.this;
        }

        @Override
        public E remove(int int_1) {
            return (Object)((Entry)((Object)this.items.remove(int_1)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry<E extends Entry<E>>
    extends AbstractGui
    implements IGuiEventListener {
        @Deprecated
        DynamicEntryListWidget<E> parent;

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public boolean isMouseOver(double double_1, double double_2) {
            return Objects.equals(this.parent.getItemAtPosition(double_1, double_2), (Object)this);
        }

        public DynamicEntryListWidget<E> getParent() {
            return this.parent;
        }

        public void setParent(DynamicEntryListWidget<E> parent) {
            this.parent = parent;
        }

        public abstract int getItemHeight();
    }

    public static final class SmoothScrollingSettings {
        public static final double CLAMP_EXTENSION = 200.0;

        private SmoothScrollingSettings() {
        }
    }
}

