/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.widget;

import me.shedaniel.forge.clothconfig2.ClothConfigInitializer;
import me.shedaniel.forge.clothconfig2.api.RunSixtyTimesEverySec;
import me.shedaniel.forge.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.forge.math.api.Rectangle;
import me.shedaniel.forge.math.impl.PointHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public abstract class DynamicNewSmoothScrollingEntryListWidget<E extends DynamicEntryListWidget.Entry<E>>
extends DynamicEntryListWidget<E> {
    protected double target;
    protected boolean smoothScrolling = true;
    protected long start;
    protected long duration;
    protected RunSixtyTimesEverySec clamper = () -> {
        this.target = this.clamp(this.target);
        if (this.target < 0.0) {
            this.target *= ClothConfigInitializer.getBounceBackMultiplier();
        } else if (this.target > (double)this.getMaxScroll()) {
            this.target = (this.target - (double)this.getMaxScroll()) * ClothConfigInitializer.getBounceBackMultiplier() + (double)this.getMaxScroll();
        } else {
            this.unregisterClamper();
        }
    };

    public DynamicNewSmoothScrollingEntryListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    protected void unregisterClamper() {
        this.clamper.unregisterTick();
    }

    public final double clamp(double v) {
        return this.clamp(v, 200.0);
    }

    public final double clamp(double v, double clampExtension) {
        return MathHelper.func_151237_a((double)v, (double)(-clampExtension), (double)((double)this.getMaxScroll() + clampExtension));
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        this.smoothScrolling = smoothScrolling;
    }

    @Override
    public void capYPosition(double double_1) {
        if (!this.smoothScrolling) {
            this.scroll = MathHelper.func_151237_a((double)double_1, (double)0.0, (double)this.getMaxScroll());
        } else {
            this.scroll = this.clamp(double_1);
            this.target = this.clamp(double_1);
        }
    }

    @Override
    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (!this.smoothScrolling) {
            return super.mouseDragged(double_1, double_2, int_1, double_3, double_4);
        }
        if (this.getFocused() != null && this.isDragging() && int_1 == 0 && this.getFocused().mouseDragged(double_1, double_2, int_1, double_3, double_4)) {
            return true;
        }
        if (int_1 == 0 && this.scrolling) {
            if (double_2 < (double)this.top) {
                this.capYPosition(0.0);
            } else if (double_2 > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = MathHelper.func_76125_a((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(MathHelper.func_151237_a((double)(this.getScroll() + double_4 * double_6), (double)0.0, (double)this.getMaxScroll()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (!this.smoothScrolling) {
            this.scroll += 16.0 * -double_3;
            this.scroll = MathHelper.func_151237_a((double)double_1, (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
        return true;
    }

    public void offset(double value, boolean animated) {
        this.scrollTo(this.target + value, animated);
    }

    public void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public void scrollTo(double value, boolean animated, long duration) {
        this.target = this.clamp(value);
        if (animated) {
            this.start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            this.scroll = this.target;
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        this.updatePosition(delta);
        super.render(mouseX, mouseY, delta);
    }

    private void updatePosition(float delta) {
        this.target = this.clamp(this.target);
        if ((this.target < 0.0 || this.target > (double)this.getMaxScroll()) && !this.clamper.isRegistered()) {
            this.clamper.registerTick();
        }
        this.scroll = !Precision.almostEquals(this.scroll, this.target, (double)0.001f) ? (double)((float)Interpolation.expoEase(this.scroll, this.target, Math.min((double)(System.currentTimeMillis() - this.start) / (double)this.duration, 1.0))) : this.target;
    }

    @Override
    protected void renderScrollBar(Tessellator tessellator, BufferBuilder buffer, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (!this.smoothScrolling) {
            super.renderScrollBar(tessellator, buffer, maxScroll, scrollbarPositionMinX, scrollbarPositionMaxX);
        } else if (maxScroll > 0) {
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            height = MathHelper.func_76125_a((int)height, (int)32, (int)(this.bottom - this.top - 8));
            height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)this.getMaxScroll() ? (int)this.scroll - this.getMaxScroll() : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top, this.top), this.bottom - height);
            int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse()) ? 168 : 128;
            int topc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.fromMouse()) ? 222 : 172;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)(minY + height), 0.0).func_187315_a(0.0, 1.0).func_181669_b(bottomc, bottomc, bottomc, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).func_187315_a(1.0, 1.0).func_181669_b(bottomc, bottomc, bottomc, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMaxX, (double)minY, 0.0).func_187315_a(1.0, 0.0).func_181669_b(bottomc, bottomc, bottomc, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)minY, 0.0).func_187315_a(0.0, 0.0).func_181669_b(bottomc, bottomc, bottomc, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(topc, topc, topc, 255).func_181675_d();
            buffer.func_181662_b((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(topc, topc, topc, 255).func_181675_d();
            buffer.func_181662_b((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).func_187315_a(1.0, 0.0).func_181669_b(topc, topc, topc, 255).func_181675_d();
            buffer.func_181662_b((double)scrollbarPositionMinX, (double)minY, 0.0).func_187315_a(0.0, 0.0).func_181669_b(topc, topc, topc, 255).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    public static class Precision {
        public static final float FLOAT_EPSILON = 0.001f;
        public static final double DOUBLE_EPSILON = 1.0E-7;

        public static boolean almostEquals(float value1, float value2, float acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }

        public static boolean almostEquals(double value1, double value2, double acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }
    }

    public static class Interpolation {
        public static double expoEase(double start, double end, double amount) {
            return start + (end - start) * ClothConfigInitializer.getEasingMethod().apply(amount);
        }
    }
}

