/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.shedaniel.forge.clothconfig2.api.ConfigBuilder;
import me.shedaniel.forge.clothconfig2.api.ConfigCategory;
import me.shedaniel.forge.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.forge.clothconfig2.impl.ConfigCategoryImpl;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class ConfigBuilderImpl
implements ConfigBuilder {
    private Runnable savingRunnable;
    private Screen parent;
    private String title = "text.cloth-config.config";
    private boolean editable = true;
    private boolean tabsSmoothScroll = true;
    private boolean listSmoothScroll = true;
    private boolean doesProcessErrors = true;
    private boolean doesConfirmSave = true;
    private ResourceLocation defaultBackground = AbstractGui.BACKGROUND_LOCATION;
    private Consumer<Screen> afterInitConsumer = screen -> {};
    private Map<String, ResourceLocation> categoryBackground = Maps.newHashMap();
    private Map<String, List<Pair<String, Object>>> dataMap = Maps.newLinkedHashMap();
    private String fallbackCategory = null;

    @Deprecated
    public ConfigBuilderImpl() {
    }

    @Override
    public ConfigBuilder setAfterInitConsumer(Consumer<Screen> afterInitConsumer) {
        this.afterInitConsumer = afterInitConsumer;
        return this;
    }

    @Override
    public ConfigBuilder setFallbackCategory(ConfigCategory fallbackCategory) {
        this.fallbackCategory = Objects.requireNonNull(fallbackCategory).getCategoryKey();
        return this;
    }

    @Override
    public Screen getParentScreen() {
        return this.parent;
    }

    @Override
    public ConfigBuilder setParentScreen(Screen parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public ConfigBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public ConfigBuilder setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    @Override
    public ConfigCategory getOrCreateCategory(String categoryKey) {
        if (this.dataMap.containsKey(categoryKey)) {
            return new ConfigCategoryImpl(categoryKey, identifier -> this.categoryBackground.put(categoryKey, (ResourceLocation)identifier), () -> this.dataMap.get(categoryKey));
        }
        this.dataMap.put(categoryKey, Lists.newArrayList());
        if (this.fallbackCategory == null) {
            this.fallbackCategory = categoryKey;
        }
        return new ConfigCategoryImpl(categoryKey, identifier -> this.categoryBackground.put(categoryKey, (ResourceLocation)identifier), () -> this.dataMap.get(categoryKey));
    }

    @Override
    public ConfigBuilder removeCategory(String category) {
        if (this.dataMap.containsKey(category) && this.fallbackCategory.equals(category)) {
            this.fallbackCategory = null;
        }
        this.dataMap.remove(category);
        return this;
    }

    @Override
    public ConfigBuilder removeCategoryIfExists(String category) {
        if (this.dataMap.containsKey(category) && this.fallbackCategory.equals(category)) {
            this.fallbackCategory = null;
        }
        if (this.dataMap.containsKey(category)) {
            this.dataMap.remove(category);
        }
        return this;
    }

    @Override
    public boolean hasCategory(String category) {
        return this.dataMap.containsKey(category);
    }

    @Override
    public ConfigBuilder setShouldTabsSmoothScroll(boolean shouldTabsSmoothScroll) {
        this.tabsSmoothScroll = shouldTabsSmoothScroll;
        return this;
    }

    @Override
    public boolean isTabsSmoothScrolling() {
        return this.tabsSmoothScroll;
    }

    @Override
    public ConfigBuilder setShouldListSmoothScroll(boolean shouldListSmoothScroll) {
        this.listSmoothScroll = shouldListSmoothScroll;
        return this;
    }

    @Override
    public boolean isListSmoothScrolling() {
        return this.listSmoothScroll;
    }

    @Override
    public ConfigBuilder setDoesConfirmSave(boolean confirmSave) {
        this.doesConfirmSave = confirmSave;
        return this;
    }

    @Override
    public boolean doesConfirmSave() {
        return this.doesConfirmSave;
    }

    @Override
    public ConfigBuilder setDoesProcessErrors(boolean processErrors) {
        this.doesProcessErrors = processErrors;
        return this;
    }

    @Override
    public boolean doesProcessErrors() {
        return this.doesProcessErrors;
    }

    @Override
    public ResourceLocation getDefaultBackgroundTexture() {
        return this.defaultBackground;
    }

    @Override
    public ConfigBuilder setDefaultBackgroundTexture(ResourceLocation texture) {
        this.defaultBackground = texture;
        return this;
    }

    @Override
    public ConfigBuilder setSavingRunnable(Runnable runnable) {
        this.savingRunnable = runnable;
        return this;
    }

    @Override
    public Consumer<Screen> getAfterInitConsumer() {
        return this.afterInitConsumer;
    }

    @Override
    public Screen build() {
        if (this.dataMap.isEmpty() || this.fallbackCategory == null) {
            throw new NullPointerException("There cannot be no categories or fallback category!");
        }
        ClothConfigScreen screen = new ClothConfigScreen(this.parent, I18n.func_135052_a((String)this.title, (Object[])new Object[0]), this.dataMap, this.doesConfirmSave, this.doesProcessErrors, this.listSmoothScroll, this.defaultBackground, this.categoryBackground){

            @Override
            public void onSave(Map<String, List<Pair<String, Object>>> o) {
                if (ConfigBuilderImpl.this.savingRunnable != null) {
                    ConfigBuilderImpl.this.savingRunnable.run();
                }
            }

            @Override
            public boolean isEditable() {
                return ConfigBuilderImpl.this.editable;
            }

            @Override
            protected void init() {
                super.init();
                ConfigBuilderImpl.this.afterInitConsumer.accept(this);
            }

            @Override
            public String getFallbackCategory() {
                return ConfigBuilderImpl.this.fallbackCategory;
            }
        };
        screen.setSmoothScrollingTabs(this.tabsSmoothScroll);
        return screen;
    }

    @Override
    public Runnable getSavingRunnable() {
        return this.savingRunnable;
    }
}

