/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.impl;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.forge.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.forge.clothconfig2.api.ConfigCategory;
import net.minecraft.util.ResourceLocation;

public class ConfigCategoryImpl
implements ConfigCategory {
    private Supplier<List<Pair<String, Object>>> listSupplier;
    private Consumer<ResourceLocation> backgroundConsumer;
    private String categoryKey;

    ConfigCategoryImpl(String categoryKey, Consumer<ResourceLocation> backgroundConsumer, Supplier<List<Pair<String, Object>>> listSupplier) {
        this.listSupplier = listSupplier;
        this.backgroundConsumer = backgroundConsumer;
        this.categoryKey = categoryKey;
    }

    @Override
    public String getCategoryKey() {
        return this.categoryKey;
    }

    @Override
    public List<Object> getEntries() {
        return this.listSupplier.get().stream().map(Pair::getSecond).collect(Collectors.toList());
    }

    @Override
    public ConfigCategory addEntry(AbstractConfigListEntry entry) {
        this.listSupplier.get().add((Pair<String, Object>)new Pair((Object)entry.getFieldName(), (Object)entry));
        return this;
    }

    @Override
    public ConfigCategory setCategoryBackground(ResourceLocation resourceLocation) {
        this.backgroundConsumer.accept(resourceLocation);
        return this;
    }
}

