/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.impl.builders;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.forge.clothconfig2.gui.entries.BaseListEntry;
import me.shedaniel.forge.clothconfig2.gui.entries.FloatListListEntry;
import me.shedaniel.forge.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.client.resources.I18n;

public class FloatListBuilder
extends FieldBuilder<List<Float>, FloatListListEntry> {
    protected Function<Float, Optional<String>> cellErrorSupplier;
    private Consumer<List<Float>> saveConsumer = null;
    private Function<List<Float>, Optional<String[]>> tooltipSupplier = list -> Optional.empty();
    private List<Float> value;
    private boolean expended = false;
    private Float min = null;
    private Float max = null;
    private Function<BaseListEntry, FloatListListEntry.FloatListCell> createNewInstance;
    private String addTooltip = I18n.func_135052_a((String)"text.cloth-config.list.add", (Object[])new Object[0]);
    private String removeTooltip = I18n.func_135052_a((String)"text.cloth-config.list.remove", (Object[])new Object[0]);
    private boolean deleteButtonEnabled = true;
    private boolean insertInFront = true;

    public FloatListBuilder(String resetButtonKey, String fieldNameKey, List<Float> value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    public Function<Float, Optional<String>> getCellErrorSupplier() {
        return this.cellErrorSupplier;
    }

    public FloatListBuilder setCellErrorSupplier(Function<Float, Optional<String>> cellErrorSupplier) {
        this.cellErrorSupplier = cellErrorSupplier;
        return this;
    }

    public FloatListBuilder setDeleteButtonEnabled(boolean deleteButtonEnabled) {
        this.deleteButtonEnabled = deleteButtonEnabled;
        return this;
    }

    public FloatListBuilder setErrorSupplier(Function<List<Float>, Optional<String>> errorSupplier) {
        this.errorSupplier = errorSupplier;
        return this;
    }

    public FloatListBuilder setInsertInFront(boolean insertInFront) {
        this.insertInFront = insertInFront;
        return this;
    }

    public FloatListBuilder setAddButtonTooltip(String addTooltip) {
        this.addTooltip = addTooltip;
        return this;
    }

    public FloatListBuilder setRemoveButtonTooltip(String removeTooltip) {
        this.removeTooltip = removeTooltip;
        return this;
    }

    public FloatListBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public FloatListBuilder setCreateNewInstance(Function<BaseListEntry, FloatListListEntry.FloatListCell> createNewInstance) {
        this.createNewInstance = createNewInstance;
        return this;
    }

    public FloatListBuilder setExpended(boolean expended) {
        this.expended = expended;
        return this;
    }

    public FloatListBuilder setSaveConsumer(Consumer<List<Float>> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public FloatListBuilder setDefaultValue(Supplier<List<Float>> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public FloatListBuilder setMin(float min) {
        this.min = Float.valueOf(min);
        return this;
    }

    public FloatListBuilder setMax(float max) {
        this.max = Float.valueOf(max);
        return this;
    }

    public FloatListBuilder removeMin() {
        this.min = null;
        return this;
    }

    public FloatListBuilder removeMax() {
        this.max = null;
        return this;
    }

    public FloatListBuilder setDefaultValue(List<Float> defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public FloatListBuilder setTooltipSupplier(Supplier<Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = list -> (Optional)tooltipSupplier.get();
        return this;
    }

    public FloatListBuilder setTooltipSupplier(Function<List<Float>, Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public FloatListBuilder setTooltip(Optional<String[]> tooltip) {
        this.tooltipSupplier = list -> tooltip;
        return this;
    }

    public FloatListBuilder setTooltip(String ... tooltip) {
        this.tooltipSupplier = list -> Optional.ofNullable(tooltip);
        return this;
    }

    @Override
    public FloatListListEntry build() {
        FloatListListEntry entry = new FloatListListEntry(this.getFieldNameKey(), this.value, this.expended, null, this.saveConsumer, this.defaultValue, this.getResetButtonKey(), this.isRequireRestart()){

            @Override
            public boolean isDeleteButtonEnabled() {
                return FloatListBuilder.this.deleteButtonEnabled;
            }

            @Override
            public boolean insertInFront() {
                return FloatListBuilder.this.insertInFront;
            }
        };
        if (this.min != null) {
            entry.setMinimum(this.min.floatValue());
        }
        if (this.max != null) {
            entry.setMaximum(this.max.floatValue());
        }
        if (this.createNewInstance != null) {
            entry.setCreateNewInstance(this.createNewInstance);
        }
        entry.setCellErrorSupplier(this.cellErrorSupplier);
        entry.setTooltipSupplier(() -> this.tooltipSupplier.apply((List<Float>)entry.getValue()));
        entry.setAddTooltip(this.addTooltip);
        entry.setRemoveTooltip(this.removeTooltip);
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return entry;
    }
}

