/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.blocks;

import com.cgessinger.creaturesandbeasts.entities.LizardEntity;
import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import com.cgessinger.creaturesandbeasts.init.CNBLizardTypes;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.cgessinger.creaturesandbeasts.util.LizardType;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LizardEggBlock
extends Block {
    public static final IntegerProperty EGGS = IntegerProperty.m_61631_((String)"eggs", (int)1, (int)6);
    private static final VoxelShape THREE_EGG_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0);
    private LizardType parent1;
    private LizardType parent2;

    public LizardEggBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76286_, (MaterialColor)MaterialColor.f_76400_).m_60978_(0.5f).m_60918_(SoundType.f_56743_).m_60977_().m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
        this.parent1 = CNBLizardTypes.DESERT;
        this.parent2 = CNBLizardTypes.JUNGLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{EGGS});
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (this.canGrow((Level)worldIn)) {
            this.removeOneEgg((Level)worldIn, pos, state);
            worldIn.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            LizardEntity lizard = (LizardEntity)((EntityType)CNBEntityTypes.LIZARD.get()).m_20615_((Level)worldIn);
            lizard.m_146762_(-24000);
            lizard.setLizardType(lizard.m_21187_().nextBoolean() ? this.parent1 : this.parent2);
            lizard.m_7678_((double)pos.m_123341_() + 0.3, pos.m_123342_(), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
            worldIn.m_7967_((Entity)lizard);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return THREE_EGG_SHAPE;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.m_6240_(level, player, pos, state, blockEntity, stack);
        this.removeOneEgg(level, pos, state);
    }

    private boolean canGrow(Level worldIn) {
        float f = worldIn.m_46942_(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return worldIn.f_46441_.nextInt(200) == 0;
    }

    private void removeOneEgg(Level worldIn, BlockPos pos, BlockState state) {
        worldIn.m_5594_(null, pos, (SoundEvent)CNBSoundEvents.LIZARD_EGG_HATCH.get(), SoundSource.BLOCKS, 1.0f, 0.0f);
        int i = (Integer)state.m_61143_((Property)EGGS);
        if (i <= 1) {
            worldIn.m_46961_(pos, false);
        } else {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(i - 1)), 2);
            worldIn.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    public void setParents(LizardType parent1, LizardType parent2) {
        this.parent1 = parent1;
        this.parent2 = parent2;
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext context) {
        return context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (Integer)blockState.m_61143_((Property)EGGS) < 6 || super.m_6864_(blockState, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        return blockstate.m_60713_((Block)this) ? (BlockState)blockstate.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(Math.min(6, (Integer)blockstate.m_61143_((Property)EGGS) + 1))) : super.m_5573_(context);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        return stateBelow.m_60659_((BlockGetter)level, pos.m_7495_(), Direction.UP, SupportType.FULL);
    }
}

