/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.containers;

import com.cgessinger.creaturesandbeasts.entities.CindershellEntity;
import com.cgessinger.creaturesandbeasts.init.CNBContainerTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class CinderFurnaceContainer
extends RecipeBookMenu<Container> {
    public static final int INGREDIENT_SLOT = 0;
    public static final int RESULT_SLOT = 1;
    public static final int SLOT_COUNT = 2;
    private static final int INV_SLOT_START = 2;
    private static final int INV_SLOT_END = 29;
    private static final int USE_ROW_SLOT_START = 29;
    private static final int USE_ROW_SLOT_END = 38;
    private final Container container;
    private final ContainerData data;
    protected final Level level;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    private final RecipeBookType recipeBookType = RecipeBookType.FURNACE;

    public CinderFurnaceContainer(int id, Inventory inventory) {
        this(id, inventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(2));
    }

    public CinderFurnaceContainer(int id, Inventory inventory, Container container, ContainerData data) {
        super((MenuType)CNBContainerTypes.CINDER_FURNACE_CONTAINER.get(), id);
        this.recipeType = RecipeType.f_44108_;
        CinderFurnaceContainer.m_38869_((Container)container, (int)2);
        this.container = container;
        this.data = data;
        this.level = inventory.f_35978_.f_19853_;
        this.m_38897_(new Slot(container, 0, 56, 17));
        this.m_38897_(new CinderFurnaceResultSlot(inventory.f_35978_, container, 1, 116, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
        this.m_38884_(data);
    }

    public void m_5816_(StackedContents contents) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.container).m_5809_(contents);
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 2; ++i) {
            this.m_38853_(i).m_5852_(ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super Container> recipe) {
        return recipe.m_5818_(this.container, this.level);
    }

    public int m_6636_() {
        return 1;
    }

    public int m_6635_() {
        return 1;
    }

    public int m_6656_() {
        return 1;
    }

    public int m_6653_() {
        return 2;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex == 1) {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotIndex != 0 ? (this.canSmelt(itemstack1) ? !this.m_38903_(itemstack1, 0, 1, false) : (slotIndex >= 2 && slotIndex < 29 ? !this.m_38903_(itemstack1, 29, 38, false) : slotIndex >= 29 && slotIndex < 38 && !this.m_38903_(itemstack1, 2, 29, false))) : !this.m_38903_(itemstack1, 2, 38, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    protected boolean canSmelt(ItemStack stack) {
        return this.level.m_7465_().m_44015_(this.recipeType, (Container)new SimpleContainer(new ItemStack[]{stack}), this.level).isPresent();
    }

    public RecipeBookType m_5867_() {
        return this.recipeBookType;
    }

    public RecipeType<? extends AbstractCookingRecipe> getRecipeType() {
        return this.recipeType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookingProgress() {
        int i = this.data.m_6413_(0);
        int j = this.data.m_6413_(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public boolean m_142157_(int slotIndex) {
        return true;
    }

    public static class CinderFurnaceResultSlot
    extends Slot {
        private final Player player;
        private int removeCount;

        public CinderFurnaceResultSlot(Player player, Container container, int index, int x, int y) {
            super(container, index, x, y);
            this.player = player;
        }

        public boolean m_5857_(ItemStack p_39553_) {
            return false;
        }

        public ItemStack m_6201_(int amount) {
            if (this.m_6657_()) {
                this.removeCount += Math.min(amount, this.m_7993_().m_41613_());
            }
            return super.m_6201_(amount);
        }

        public void m_142406_(Player player, ItemStack stack) {
            this.m_5845_(stack);
            super.m_142406_(player, stack);
        }

        protected void m_7169_(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.m_5845_(stack);
        }

        public void m_5845_(ItemStack stack) {
            stack.m_41678_(this.player.f_19853_, this.player, this.removeCount);
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                player = this.f_40218_;
                if (player instanceof CindershellEntity) {
                    CindershellEntity cindershellEntity = (CindershellEntity)player;
                    cindershellEntity.awardUsedRecipesAndPopExperience(serverPlayer);
                }
            }
            this.removeCount = 0;
            ForgeEventFactory.firePlayerSmeltedEvent((Player)this.player, (ItemStack)stack);
        }
    }
}

