/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.entities.ai.GoToWaterGoal;
import com.cgessinger.creaturesandbeasts.entities.ai.MountAdultGoal;
import com.cgessinger.creaturesandbeasts.entities.ai.SmoothSwimGoal;
import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.cgessinger.creaturesandbeasts.init.CNBTags;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class LittleGrebeEntity
extends Animal
implements IAnimatable {
    private static final EntityDataAccessor<BlockPos> TRAVEL_POS = SynchedEntityData.m_135353_(LittleGrebeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private final UUID healthReductionUUID = UUID.fromString("189faad9-35de-4e15-a598-82d147b996d7");
    public float flapSpeed;
    private float nextFlap = 1.0f;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public LittleGrebeEntity(EntityType<LittleGrebeEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MountAdultGoal(this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new SmoothSwimGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(CNBTags.Items.LITTLE_GREBE_FOOD), false));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(6, (Goal)new LittleGrebeRandomStrollGoal(this, 1.0, 60, 1));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new GoToWaterGoal(this, 0.8));
    }

    public static boolean checkGrebeSpawnRules(EntityType<LittleGrebeEntity> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return worldIn.m_45524_(pos, 0) > 8;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(0.6f);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        double MAX_HEALTH = this.m_21051_(Attributes.f_22276_).m_22135_();
        float babyHealth = 5.0f;
        if (this.m_6162_() && MAX_HEALTH > (double)babyHealth) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(this.healthReductionUUID, "yeti_health_reduction", (double)babyHealth - MAX_HEALTH, AttributeModifier.Operation.ADDITION));
            this.m_21204_().m_22178_((Multimap)multimap);
            this.m_21153_(babyHealth);
        }
    }

    protected void m_142669_() {
        this.m_8127_();
        this.m_21051_(Attributes.f_22276_).m_22120_(this.healthReductionUUID);
        this.m_21153_((float)this.m_21051_(Attributes.f_22276_).m_22135_());
    }

    public void m_8107_() {
        super.m_8107_();
        this.flapSpeed += (this.f_19861_ ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        Vec3 vec3 = this.m_20184_();
        if (!this.f_19861_ && !this.m_6162_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return (AgeableMob)((EntityType)CNBEntityTypes.LITTLE_GREBE.get()).m_20615_((Level)p_241840_1_);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return this.m_6162_() && super.m_142535_(distance, damageMultiplier, source);
    }

    protected float m_6121_() {
        return 0.6f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_6162_()) {
            return (SoundEvent)CNBSoundEvents.LITTLE_GREBE_CHICK_AMBIENT.get();
        }
        return (SoundEvent)CNBSoundEvents.LITTLE_GREBE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CNBSoundEvents.LITTLE_GREBE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)CNBSoundEvents.LITTLE_GREBE_HURT.get();
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.3;
    }

    public boolean m_6063_() {
        return false;
    }

    private BlockPos getTravelPos() {
        return (BlockPos)this.f_19804_.m_135370_(TRAVEL_POS);
    }

    public int m_8085_() {
        return 60;
    }

    public int m_8132_() {
        return 35;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRAVEL_POS, (Object)new BlockPos(0, 2, 0));
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_204132_(CNBTags.Items.LITTLE_GREBE_FOOD).test(stack);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.1f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.5));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (!(this.m_20096_() || this.m_20069_() || this.m_6162_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("little_grebe.fall", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("little_grebe.swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!(this.f_20924_ > -0.15f) || !(this.f_20924_ < 0.15f)) {
            if (this.m_6162_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("little_grebe_chick.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("little_grebe.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class LittleGrebeRandomStrollGoal
    extends RandomStrollGoal {
        private static final Random rand = new Random();
        private final LittleGrebeEntity littleGrebe;
        private final int intervalLand;
        private final int intervalWater;
        private final boolean checkNoActionTime;

        public LittleGrebeRandomStrollGoal(LittleGrebeEntity littleGrebe, double speedModifier) {
            this(littleGrebe, speedModifier, 60, 120);
        }

        public LittleGrebeRandomStrollGoal(LittleGrebeEntity littleGrebe, double speedModifier, int intervalLand, int intervalWater) {
            this(littleGrebe, speedModifier, intervalLand, intervalWater, true);
        }

        public LittleGrebeRandomStrollGoal(LittleGrebeEntity littleGrebe, double speedModifier, int intervalLand, int intervalWater, boolean checkNoActionTime) {
            super((PathfinderMob)littleGrebe, speedModifier, intervalLand, checkNoActionTime);
            this.littleGrebe = littleGrebe;
            this.intervalLand = intervalLand;
            this.intervalWater = intervalWater;
            this.checkNoActionTime = checkNoActionTime;
        }

        public void m_8056_() {
            this.littleGrebe.m_21573_().m_26519_(this.f_25726_, this.f_25727_, this.f_25728_, this.f_25729_);
        }

        public boolean m_8036_() {
            Vec3 vec3;
            if (this.f_25725_.m_20160_()) {
                return false;
            }
            if (!this.f_25731_) {
                int i;
                if (this.checkNoActionTime && this.f_25725_.m_21216_() >= 100) {
                    return false;
                }
                int n = i = this.littleGrebe.m_20069_() ? this.intervalWater : this.intervalLand;
                if (this.f_25725_.m_21187_().nextInt(LittleGrebeRandomStrollGoal.m_186073_((int)i)) != 0) {
                    return false;
                }
            }
            if ((vec3 = this.m_7037_()) == null) {
                return false;
            }
            this.f_25726_ = vec3.f_82479_;
            this.f_25727_ = vec3.f_82480_;
            this.f_25728_ = vec3.f_82481_;
            this.f_25731_ = false;
            return true;
        }

        protected Vec3 m_7037_() {
            boolean flag = GoalUtils.m_148442_((PathfinderMob)this.littleGrebe, (int)10);
            return RandomPos.m_148542_((PathfinderMob)this.littleGrebe, () -> {
                BlockPos blockpos = this.littleGrebe.m_20069_() ? RandomPos.m_148549_((Random)this.littleGrebe.m_21187_(), (int)10, (int)1) : RandomPos.m_148549_((Random)this.littleGrebe.m_21187_(), (int)10, (int)7);
                return LittleGrebeRandomStrollGoal.generateRandomPosTowardDirection(this.littleGrebe, 10, flag, blockpos);
            });
        }

        @Nullable
        private static BlockPos generateRandomPosTowardDirection(LittleGrebeEntity littleGrebe, int horizontalRange, boolean flag, BlockPos posTowards) {
            BlockPos blockpos = RandomPos.m_148537_((PathfinderMob)littleGrebe, (int)horizontalRange, (Random)littleGrebe.m_21187_(), (BlockPos)posTowards);
            return !GoalUtils.m_148451_((BlockPos)blockpos, (PathfinderMob)littleGrebe) && !GoalUtils.m_148454_((boolean)flag, (PathfinderMob)littleGrebe, (BlockPos)blockpos) && !GoalUtils.m_148458_((PathfinderMob)littleGrebe, (BlockPos)blockpos) && (!GoalUtils.m_148448_((PathNavigation)littleGrebe.m_21573_(), (BlockPos)blockpos) || GoalUtils.m_148445_((PathfinderMob)littleGrebe, (BlockPos)blockpos)) ? blockpos : null;
        }
    }
}

