/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.blocks.LizardEggBlock;
import com.cgessinger.creaturesandbeasts.init.CNBBlocks;
import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import com.cgessinger.creaturesandbeasts.init.CNBItems;
import com.cgessinger.creaturesandbeasts.init.CNBLizardTypes;
import com.cgessinger.creaturesandbeasts.util.LizardType;
import com.cgessinger.creaturesandbeasts.util.Netable;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class LizardEntity
extends Animal
implements IAnimatable,
Netable {
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(LizardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> PARTYING = SynchedEntityData.m_135353_(LizardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SAD = SynchedEntityData.m_135353_(LizardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(LizardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LAYING_EGG = SynchedEntityData.m_135353_(LizardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_NET = SynchedEntityData.m_135353_(LizardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private LizardEntity partner;
    public BlockPos jukeboxPosition;
    int layEggCounter;

    public LizardEntity(EntityType<LizardEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21365_ = new LookControl((Mob)this){

            public void m_8128_() {
                LizardEntity lizard = (LizardEntity)this.f_24937_;
                if (lizard.shouldLookAround()) {
                    super.m_8128_();
                }
            }
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)CNBLizardTypes.DESERT.getId().toString());
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(LAYING_EGG, (Object)false);
        this.f_19804_.m_135372_(FROM_NET, (Object)false);
        this.f_19804_.m_135372_(PARTYING, (Object)false);
        this.f_19804_.m_135372_(SAD, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("LizardType", this.getLizardType().getId().toString());
        compound.m_128379_("Sad", this.getSad());
        compound.m_128379_("FromNet", this.fromNet());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        LizardType type = LizardType.getById(compound.m_128461_("LizardType"));
        if (type == null) {
            type = CNBLizardTypes.DESERT;
        }
        this.setLizardType(type);
        if (compound.m_128441_("Sad")) {
            this.setSad(compound.m_128471_("Sad"));
        }
        if (compound.m_128441_("FromNet")) {
            this.setFromNet(compound.m_128471_("FromNet"));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.18);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new LizardBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LizardLayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return !((LizardEntity)this.f_25725_).isPartying() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !((LizardEntity)this.f_25725_).isPartying() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jukeboxPosition != null) {
            BlockEntity te = this.f_19853_.m_7702_(this.jukeboxPosition);
            Vec3 pos = this.m_20182_();
            if (!this.jukeboxPosition.m_123314_(new Vec3i(pos.f_82479_, pos.f_82480_, pos.f_82481_), 10.0) || !(te instanceof JukeboxBlockEntity)) {
                this.setPartying(false, null);
            }
        }
        if (this.isPartying() || ((Boolean)this.f_19804_.m_135370_(LAYING_EGG)).booleanValue()) {
            this.f_21344_.m_26573_();
        }
        if (this.m_6084_() && this.isLayingEgg() && this.layEggCounter >= 1 && this.layEggCounter % 5 == 0) {
            BlockPos blockpos = this.m_142538_().m_7495_();
            this.f_19853_.m_46796_(2001, blockpos, Block.m_49956_((BlockState)this.f_19853_.m_8055_(blockpos)));
        }
    }

    public static boolean checkLizardSpawnRules(EntityType<LizardEntity> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return worldIn.m_45524_(pos, 0) > 8;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Holder biome = worldIn.m_204166_(this.m_142538_());
        Biome.BiomeCategory biomeCategory = Biome.m_204183_((Holder)biome);
        if (reason == MobSpawnType.SPAWN_EGG && dataTag != null && dataTag.m_128441_("LizardType")) {
            LizardType type = LizardType.getById(dataTag.m_128461_("LizardType"));
            if (type != null) {
                this.setLizardType(type);
            }
        } else if (biomeCategory.equals((Object)Biome.BiomeCategory.DESERT) || biomeCategory.equals((Object)Biome.BiomeCategory.MESA)) {
            if (this.f_19796_.nextBoolean()) {
                this.setLizardType(CNBLizardTypes.DESERT);
            } else {
                this.setLizardType(CNBLizardTypes.DESERT_2);
            }
        } else if (biomeCategory.equals((Object)Biome.BiomeCategory.JUNGLE)) {
            if (this.f_19796_.nextBoolean()) {
                this.setLizardType(CNBLizardTypes.JUNGLE);
            } else {
                this.setLizardType(CNBLizardTypes.JUNGLE_2);
            }
        } else if (biomeCategory.equals((Object)Biome.BiomeCategory.MUSHROOM)) {
            this.setLizardType(CNBLizardTypes.MUSHROOM);
        } else {
            switch (this.f_19796_.nextInt(4)) {
                case 0: {
                    this.setLizardType(CNBLizardTypes.DESERT);
                    break;
                }
                case 1: {
                    this.setLizardType(CNBLizardTypes.DESERT_2);
                    break;
                }
                case 2: {
                    this.setLizardType(CNBLizardTypes.JUNGLE);
                    break;
                }
                default: {
                    this.setLizardType(CNBLizardTypes.JUNGLE_2);
                }
            }
        }
        this.setSad(this.m_21187_().nextInt(10) == 0);
        if (dataTag != null && dataTag.m_128441_("Health")) {
            this.m_21153_(dataTag.m_128457_("Health"));
        }
        if (dataTag != null && dataTag.m_128441_("Name")) {
            this.m_6593_(Component.m_130674_((String)dataTag.m_128461_("Name")));
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_6818_(BlockPos pos, boolean isPartying) {
        this.setPartying(isPartying, pos);
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        super.m_6475_(damageSrc, damageAmount);
        this.setPartying(false, null);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (item.m_41656_(((Item)CNBItems.APPLE_SLICE.get()).m_7968_()) && this.getSad()) {
            this.setSad(false);
            this.m_142075_(player, hand, item);
            this.spawnParticles((ParticleOptions)ParticleTypes.f_123750_);
            return InteractionResult.SUCCESS;
        }
        return Netable.netMobPickup(player, hand, this).orElse(super.m_6071_(player, hand));
    }

    @Override
    public boolean fromNet() {
        return (Boolean)this.f_19804_.m_135370_(FROM_NET);
    }

    @Override
    public void setFromNet(boolean fromNet) {
        this.f_19804_.m_135381_(FROM_NET, (Object)fromNet);
    }

    @Override
    public void saveToNetTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        if (this.m_21525_()) {
            tag.m_128379_("NoAI", this.m_21525_());
        }
        if (this.m_20067_()) {
            tag.m_128379_("Silent", this.m_20067_());
        }
        if (this.m_20068_()) {
            tag.m_128379_("NoGravity", this.m_20068_());
        }
        if (this.m_146886_()) {
            tag.m_128379_("Glowing", this.m_146886_());
        }
        if (this.m_20147_()) {
            tag.m_128379_("Invulnerable", this.m_20147_());
        }
        tag.m_128350_("Health", this.m_21223_());
        tag.m_128379_("Sad", this.getSad());
        tag.m_128379_("FromNet", true);
        tag.m_128359_("LizardType", this.getLizardType().getId().toString());
    }

    @Override
    public void loadFromNetTag(CompoundTag compound) {
        LizardType type;
        if (compound.m_128441_("NoAI")) {
            this.m_21557_(compound.m_128471_("NoAI"));
        }
        if (compound.m_128441_("Silent")) {
            this.m_20225_(compound.m_128471_("Silent"));
        }
        if (compound.m_128441_("NoGravity")) {
            this.m_20242_(compound.m_128471_("NoGravity"));
        }
        if (compound.m_128441_("Glowing")) {
            this.m_146915_(compound.m_128471_("Glowing"));
        }
        if (compound.m_128441_("Invulnerable")) {
            this.m_20331_(compound.m_128471_("Invulnerable"));
        }
        if (compound.m_128425_("Health", 99)) {
            this.m_21153_(compound.m_128457_("Health"));
        }
        if (compound.m_128441_("Sad")) {
            this.setSad(compound.m_128471_("Sad"));
        }
        if (compound.m_128441_("LizardType") && (type = LizardType.getById(compound.m_128461_("LizardType"))) != null) {
            this.setLizardType(type);
        }
        if (compound.m_128441_("FromNet")) {
            this.setFromNet(compound.m_128471_("FromNet"));
        }
    }

    @Override
    public ItemStack getItemStack() {
        if (!this.m_6162_()) {
            return new ItemStack((ItemLike)this.getLizardType().getSpawnItem());
        }
        return null;
    }

    @Override
    public SoundEvent getPickupSound() {
        return SoundEvents.f_12019_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        LizardEntity baby = (LizardEntity)((EntityType)CNBEntityTypes.LIZARD.get()).m_20615_((Level)world);
        if (baby != null) {
            baby.setLizardType(((LizardEntity)entity).getLizardType());
        }
        return baby;
    }

    public void setPartying(boolean isPartying, @Nullable BlockPos jukeboxPos) {
        if (!this.getSad()) {
            this.f_19804_.m_135381_(PARTYING, (Object)isPartying);
            this.jukeboxPosition = jukeboxPos;
        }
    }

    public boolean isPartying() {
        return (Boolean)this.f_19804_.m_135370_(PARTYING);
    }

    public void setSad(boolean sad) {
        this.f_19804_.m_135381_(SAD, (Object)sad);
    }

    public boolean getSad() {
        return (Boolean)this.f_19804_.m_135370_(SAD);
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    void setHasEgg(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    public boolean isLayingEgg() {
        return (Boolean)this.f_19804_.m_135370_(LAYING_EGG);
    }

    void setLayingEgg(boolean layingEgg) {
        this.layEggCounter = layingEgg ? 1 : 0;
        this.f_19804_.m_135381_(LAYING_EGG, (Object)layingEgg);
    }

    public boolean shouldLookAround() {
        return !this.isPartying() && (Boolean)this.f_19804_.m_135370_(LAYING_EGG) == false;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41656_(((Item)CNBItems.APPLE_SLICE.get()).m_7968_());
    }

    public void spawnParticles(ParticleOptions data) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_(data, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void setLizardType(LizardType lizardType) {
        this.f_19804_.m_135381_(TYPE, (Object)lizardType.getId().toString());
    }

    public LizardType getLizardType() {
        return LizardType.getById((String)this.f_19804_.m_135370_(TYPE));
    }

    public int m_8085_() {
        return 50;
    }

    public int m_8132_() {
        return 35;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)this.getLizardType().getSpawnItem());
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (((Boolean)this.f_19804_.m_135370_(LAYING_EGG)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lizard_dig", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (!(this.f_20924_ > -0.13f) || !(this.f_20924_ < 0.13f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lizard_walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isPartying()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("lizard_dance", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class LizardBreedGoal
    extends BreedGoal {
        private final LizardEntity lizard;

        LizardBreedGoal(LizardEntity lizard, double speedModifier) {
            super((Animal)lizard, speedModifier);
            this.lizard = lizard;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.lizard.hasEgg();
        }

        protected void m_8026_() {
            ServerPlayer serverplayer = this.f_25113_.m_27592_();
            if (serverplayer == null && this.f_25115_.m_27592_() != null) {
                serverplayer = this.f_25115_.m_27592_();
            }
            if (serverplayer != null) {
                serverplayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayer, this.f_25113_, this.f_25115_, null);
            }
            this.lizard.setHasEgg(true);
            this.lizard.partner = (LizardEntity)this.f_25115_;
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            Random random = this.f_25113_.m_21187_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), random.nextInt(7) + 1));
            }
        }
    }

    static class LizardLayEggGoal
    extends MoveToBlockGoal {
        private final LizardEntity lizard;

        LizardLayEggGoal(LizardEntity lizard, double speedModifier) {
            super((PathfinderMob)lizard, speedModifier, 16);
            this.lizard = lizard;
        }

        public boolean m_8036_() {
            return this.lizard.hasEgg() && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.lizard.hasEgg();
        }

        public void m_8041_() {
            super.m_8041_();
            this.lizard.setLayingEgg(false);
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos blockpos = this.lizard.m_142538_();
            if (!this.lizard.m_20069_() && this.m_25625_()) {
                if (this.lizard.layEggCounter < 1) {
                    this.lizard.setLayingEgg(true);
                } else if (this.lizard.layEggCounter > this.m_183277_(200)) {
                    Level level = this.lizard.f_19853_;
                    level.m_5594_(null, blockpos, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.nextFloat() * 0.2f);
                    level.m_7731_(this.f_25602_.m_7494_(), (BlockState)((Block)CNBBlocks.LIZARD_EGGS.get()).m_49966_().m_61124_((Property)LizardEggBlock.EGGS, (Comparable)Integer.valueOf(this.lizard.f_19796_.nextInt(6) + 1)), 3);
                    LizardEggBlock lizardEggBlock = (LizardEggBlock)level.m_8055_(this.f_25602_.m_7494_()).m_60734_();
                    lizardEggBlock.setParents(this.lizard.getLizardType(), this.lizard.partner.getLizardType());
                    this.lizard.setHasEgg(false);
                    this.lizard.setLayingEgg(false);
                    this.lizard.m_27601_(600);
                }
                if (this.lizard.isLayingEgg()) {
                    ++this.lizard.layEggCounter;
                }
            } else if (!this.m_25625_()) {
                this.lizard.setLayingEgg(false);
                this.m_25624_();
            }
        }

        protected boolean m_6465_(LevelReader levelReader, BlockPos pos) {
            return levelReader.m_46859_(pos.m_7494_());
        }
    }
}

