/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.ParticleKeyFrameEvent;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class YetiEntity
extends TamableAnimal
implements IAnimatable,
Enemy,
NeutralMob {
    public static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> PASSIVE = SynchedEntityData.m_135353_(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<ItemStack> HELD_ITEM = SynchedEntityData.m_135353_(YetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final UUID healthReductionUUID = UUID.fromString("189faad9-35de-4e15-a598-82d147b996d7");
    private final float babyHealth = 20.0f;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private int eatTimer;
    private int attackTimer;

    public YetiEntity(EntityType<YetiEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_7105_(false);
        this.eatTimer = 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(EATING, (Object)false);
        this.f_19804_.m_135372_(PASSIVE, (Object)false);
        this.f_19804_.m_135372_(HELD_ITEM, (Object)ItemStack.f_41583_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Passive", this.isPassive());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Passive")) {
            this.setPassive(compound.m_128471_("Passive"));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 16.0).m_22268_(Attributes.f_22283_, 0.1).m_22268_(Attributes.f_22278_, 0.7);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new YetiAttackGoal(this, 1.2, true));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.01f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new TargetPlayerGoal(this));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isEating()) {
            this.f_21344_.m_26573_();
            --this.eatTimer;
        }
        if (this.isAttacking()) {
            this.f_21344_.m_26573_();
            --this.attackTimer;
        }
        if (this.eatTimer == 40) {
            if (this.m_6162_()) {
                this.m_146740_((int)((float)(-this.m_146764_()) / 20.0f * 0.1f), true);
            }
            if (this.getHolding().m_41656_(Items.f_42575_.m_7968_())) {
                this.m_6710_(null);
                this.setPassive(true);
            }
            this.setHolding(ItemStack.f_41583_);
        } else if (this.eatTimer == 0) {
            this.setEating(false);
        }
        if (this.attackTimer == 10 && !this.m_21224_()) {
            this.performAttack();
        } else if (this.attackTimer == 0) {
            this.setAttacking(false);
        }
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int angerTime) {
        this.remainingPersistentAngerTime = angerTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_142270_(this.f_19796_));
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return 10.0f;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (!this.isEating() && !this.isAttacking()) {
            if (!this.f_19853_.f_46443_ && item.m_41720_() == Items.f_42575_ && !this.isPassive()) {
                this.m_21816_(player.m_142081_());
                return this.startEat(player, item.m_41777_());
            }
            if (item.m_41720_() == Items.f_42780_) {
                if (!this.f_19853_.f_46443_ && this.m_146764_() == 0 && this.m_5957_()) {
                    this.m_27595_(player);
                    return this.startEat(player, item.m_41777_());
                }
                if (this.m_6162_()) {
                    return this.startEat(player, item.m_41777_());
                }
            }
        }
        if (this.f_19853_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        double MAX_HEALTH = this.m_21051_(Attributes.f_22276_).m_22135_();
        if (this.m_6162_()) {
            Objects.requireNonNull(this);
            if (MAX_HEALTH > 20.0) {
                HashMultimap multimap = HashMultimap.create();
                Objects.requireNonNull(this);
                multimap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(this.healthReductionUUID, "yeti_health_reduction", 20.0 - MAX_HEALTH, AttributeModifier.Operation.ADDITION));
                this.m_21204_().m_22178_((Multimap)multimap);
                this.m_21153_(this.babyHealth);
            }
        }
    }

    protected void m_142669_() {
        LivingEntity livingEntity;
        super.m_142669_();
        float percentHealth = this.m_21223_() / this.babyHealth;
        this.m_21051_(Attributes.f_22276_).m_22120_(this.healthReductionUUID);
        this.m_21153_(percentHealth * (float)this.m_21051_(Attributes.f_22276_).m_22135_());
        this.setEating(false);
        this.setHolding(ItemStack.f_41583_);
        if (!this.f_19853_.f_46443_ && this.isPassive() && this.m_142480_() != null && (livingEntity = this.m_142480_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            this.m_21828_((Player)player);
            this.setPassive(false);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.f_19853_.m_7605_((Entity)this, (byte)7);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)CNBEntityTypes.YETI.get()).m_20615_((Level)level);
    }

    public void setEating(boolean isEating) {
        this.eatTimer = isEating ? 60 : 0;
        this.f_19804_.m_135381_(EATING, (Object)isEating);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public void setAttacking(boolean isAttacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)isAttacking);
        this.attackTimer = isAttacking ? 24 : 0;
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public boolean isPassive() {
        return (Boolean)this.f_19804_.m_135370_(PASSIVE);
    }

    public void setPassive(boolean isPassive) {
        this.f_19804_.m_135381_(PASSIVE, (Object)isPassive);
    }

    public ItemStack getHolding() {
        return (ItemStack)this.f_19804_.m_135370_(HELD_ITEM);
    }

    public void setHolding(ItemStack stack) {
        this.f_19804_.m_135381_(HELD_ITEM, (Object)stack);
    }

    private InteractionResult startEat(Player player, ItemStack stack) {
        this.setHolding(stack);
        this.m_142075_(player, player.m_7655_(), stack);
        this.setEating(true);
        this.m_146859_(GameEvent.f_157771_, this.m_146901_());
        SoundEvent sound = this.m_6162_() ? (SoundEvent)CNBSoundEvents.YETI_BABY_EAT.get() : (SoundEvent)CNBSoundEvents.YETI_ADULT_EAT.get();
        this.m_5496_(sound, 1.1f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_21825_() {
        return false;
    }

    public void m_21837_(boolean p_21838_) {
    }

    public boolean m_21827_() {
        return false;
    }

    public void m_21839_(boolean p_21840_) {
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_21824_() && !this.m_8077_();
    }

    private void performAttack() {
        List list = this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82377_(1.5, 1.0, 1.5));
        for (LivingEntity entity : list) {
            if (entity instanceof Player && entity.m_142081_().equals(this.m_142504_()) || entity instanceof YetiEntity && Objects.equals(this.m_142504_(), ((YetiEntity)entity).m_142504_())) continue;
            this.m_7327_((Entity)entity);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6162_()) {
            List list = this.f_19853_.m_45976_(YetiEntity.class, this.m_142469_().m_82377_(8.0, 4.0, 8.0));
            for (YetiEntity yeti : list) {
                if (yeti.m_6162_() || yeti.m_21824_()) continue;
                yeti.setPassive(false);
                yeti.m_21816_(null);
            }
        }
        if (!this.m_21824_()) {
            this.setPassive(false);
            this.m_21816_(null);
        }
        return super.m_6469_(source, amount);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (!blockIn.m_60767_().m_76332_()) {
            this.m_5496_((SoundEvent)CNBSoundEvents.YETI_STEP.get(), this.m_6121_() * 0.3f, this.m_6100_());
        }
    }

    public float m_6100_() {
        float pitch = super.m_6100_();
        return this.m_6162_() ? pitch * 1.5f : pitch;
    }

    public int m_8085_() {
        return 50;
    }

    public int m_8132_() {
        return 25;
    }

    protected SoundEvent m_7515_() {
        return this.m_6162_() ? null : (SoundEvent)CNBSoundEvents.YETI_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return this.m_6162_() ? null : (SoundEvent)CNBSoundEvents.YETI_HURT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return this.m_6162_() ? null : (SoundEvent)CNBSoundEvents.YETI_HURT.get();
    }

    private <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> event) {
        if (this.isEating()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.m_6162_() ? "yeti_baby_eat" : "yeti_adult_eat"));
        } else if (this.isAttacking()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("yeti_attack"));
        } else if (!(this.f_20924_ > -0.15f) || !(this.f_20924_ < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.m_6162_() ? "yeti_baby_walk" : "yeti_adult_walk"));
        } else {
            event.getController().markNeedsReload();
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> void soundListener(SoundKeyframeEvent<E> event) {
        if (event.sound.equals("hit.ground.sound")) {
            this.m_5496_((SoundEvent)CNBSoundEvents.YETI_HIT.get(), 0.4f, 1.0f);
        } else if (event.sound.equals("yeti_ambient")) {
            this.m_5496_((SoundEvent)CNBSoundEvents.YETI_AMBIENT.get(), 1.0f, 1.0f);
        }
    }

    private <E extends IAnimatable> void particleListener(ParticleKeyFrameEvent<E> event) {
        ParticleEngine manager = Minecraft.m_91087_().f_91061_;
        BlockPos pos = this.m_142538_();
        if (event.effect.equals("hit.ground.particle")) {
            for (int x = pos.m_123341_() - 1; x <= pos.m_123341_() + 1; ++x) {
                for (int z = pos.m_123343_() - 1; z <= pos.m_123343_() + 1; ++z) {
                    BlockPos newPos = new BlockPos(x, pos.m_123342_() - 1, z);
                    manager.m_107355_(newPos, this.f_19853_.m_8055_(newPos));
                }
            }
        } else if (event.effect.equals("eat.particle")) {
            this.spawnParticles((ParticleOptions)ParticleTypes.f_123748_);
        }
    }

    public void spawnParticles(ParticleOptions data) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_(data, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void registerControllers(AnimationData animationData) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate);
        controller.registerSoundListener(this::soundListener);
        controller.registerParticleListener(this::particleListener);
        animationData.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class YetiAttackGoal
    extends MeleeAttackGoal {
        private final YetiEntity yeti;

        public YetiAttackGoal(YetiEntity yeti, double speedModifier, boolean requiresLineOfSight) {
            super((PathfinderMob)yeti, speedModifier, requiresLineOfSight);
            this.yeti = yeti;
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.yeti.m_6162_();
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.yeti.m_5448_();
            if (livingEntity instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)livingEntity;
                if (this.yeti.m_21824_() && this.yeti.m_142480_() != null && this.yeti.m_142480_().equals((Object)tamableAnimal.m_142480_())) {
                    return false;
                }
            }
            return super.m_8036_() && !this.yeti.m_6162_() && this.yeti.m_5448_() != this.yeti.m_142480_();
        }

        protected void m_6739_(LivingEntity entity, double distance) {
            double d0 = this.m_6639_(entity);
            if (distance <= d0 && this.yeti.attackTimer <= 0 && this.f_25548_ <= 0) {
                this.m_25563_();
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.yeti.setAttacking(false);
        }

        protected void m_25563_() {
            this.f_25548_ = this.m_183277_(25);
            this.yeti.setAttacking(true);
        }
    }

    static class TargetPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final YetiEntity yeti;

        public TargetPlayerGoal(YetiEntity yeti) {
            super((Mob)yeti, Player.class, 20, true, true, null);
            this.yeti = yeti;
        }

        public boolean m_8036_() {
            if (!this.yeti.m_6162_() && !this.yeti.isPassive() && super.m_8036_()) {
                for (YetiEntity yeti : this.yeti.f_19853_.m_45976_(YetiEntity.class, this.yeti.m_142469_().m_82377_(8.0, 4.0, 8.0))) {
                    if (!yeti.m_6162_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }
}

