/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.world.gen;

import com.cgessinger.creaturesandbeasts.CreaturesAndBeasts;
import com.cgessinger.creaturesandbeasts.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.config.EntitySpawnData;
import com.cgessinger.creaturesandbeasts.entities.CindershellEntity;
import com.cgessinger.creaturesandbeasts.entities.EndWhaleEntity;
import com.cgessinger.creaturesandbeasts.entities.LilytadEntity;
import com.cgessinger.creaturesandbeasts.entities.LittleGrebeEntity;
import com.cgessinger.creaturesandbeasts.entities.LizardEntity;
import com.cgessinger.creaturesandbeasts.entities.MinipadEntity;
import com.cgessinger.creaturesandbeasts.entities.SporelingEntity;
import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;

@Mod.EventBusSubscriber(modid="cnb")
public class ModEntitySpawns {
    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getCategory() == null) {
            return;
        }
        if (event.getName() == null) {
            return;
        }
        ResourceLocation name = event.getName();
        ResourceKey biome = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)name);
        ModEntitySpawns.onAddSpawns(event, (ResourceKey<Biome>)biome);
    }

    private static void onAddSpawns(BiomeLoadingEvent event, ResourceKey<Biome> biome) {
        for (EntitySpawnData spawn : CNBConfig.spawns) {
            if (spawn == null) {
                CreaturesAndBeasts.LOGGER.traceExit("SpawnData is null! This should never happen, please report this to the developers at: %s", (Object)((ModFileInfo)ModList.get().getModFileById("cnb")).getIssueURL().toString());
                continue;
            }
            if (spawn.getEntityType() == null) {
                CreaturesAndBeasts.LOGGER.traceExit("EntityType is null! This should never happen, please report this to the developers at: %s", (Object)((ModFileInfo)ModList.get().getModFileById("cnb")).getIssueURL().toString());
                continue;
            }
            if (spawn.getBiome() == null) {
                CreaturesAndBeasts.LOGGER.traceExit("Biome is null! This should never happen, please report this to the developers at: %s", (Object)((ModFileInfo)ModList.get().getModFileById("cnb")).getIssueURL().toString());
                continue;
            }
            if (spawn.getCategory() == null) {
                CreaturesAndBeasts.LOGGER.traceExit("SpawnCategory is null! This should never happen, please report this to the developers at: %s", (Object)((ModFileInfo)ModList.get().getModFileById("cnb")).getIssueURL().toString());
                continue;
            }
            if (!spawn.getBiome().equals(biome)) continue;
            event.getSpawns().m_48376_(spawn.getCategory(), new MobSpawnSettings.SpawnerData(spawn.getEntityType(), spawn.getSpawnWeight(), spawn.getMinCount(), spawn.getMaxCount()));
            if (!(spawn.getMobCost() > 0.0) || !(spawn.getEnergyBudget() > 0.0)) continue;
            event.getSpawns().m_48370_(spawn.getEntityType(), spawn.getMobCost(), spawn.getEnergyBudget());
        }
    }

    public static void entitySpawnPlacementRegistry() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)CNBEntityTypes.LITTLE_GREBE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LittleGrebeEntity::checkGrebeSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CNBEntityTypes.LIZARD.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LizardEntity::checkLizardSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CNBEntityTypes.CINDERSHELL.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CindershellEntity::checkCindershellSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CNBEntityTypes.SPORELING.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SporelingEntity::checkSporelingSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CNBEntityTypes.LILYTAD.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LilytadEntity::checkLilytadSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CNBEntityTypes.YETI.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_21400_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CNBEntityTypes.MINIPAD.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MinipadEntity::checkMinipadSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CNBEntityTypes.END_WHALE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndWhaleEntity::checkEndWhaleSpawnRules);
    }
}

