/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.coldsspeeders.entities;

import com.coldspell.coldsspeeders.init.ModEntityTypes;
import com.coldspell.coldsspeeders.items.BrushItem;
import com.coldspell.coldsspeeders.util.enums.SpeederHelper;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.EnderChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class SpeederEntity
extends AbstractHorseEntity {
    private static final DataParameter<Integer> SPEEDER_TYPE = EntityDataManager.func_187226_a(SpeederEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int totalSpeeders = 50;
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_ID = (Map)Util.func_200696_a((Object)Maps.newHashMap(), texture -> {
        texture.put(0, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_black.png"));
        texture.put(1, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_blue.png"));
        texture.put(2, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_brown.png"));
        texture.put(3, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_cyan.png"));
        texture.put(4, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_gray.png"));
        texture.put(5, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_green.png"));
        texture.put(6, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_light_blue.png"));
        texture.put(7, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_light_gray.png"));
        texture.put(8, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_lime.png"));
        texture.put(9, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_magenta.png"));
        texture.put(10, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_orange.png"));
        texture.put(11, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_pink.png"));
        texture.put(12, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_purple.png"));
        texture.put(13, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_red.png"));
        texture.put(14, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_white.png"));
        texture.put(15, new ResourceLocation("coldsspeeders", "textures/entity/base/speeder_texture_yellow.png"));
        texture.put(16, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_black.png"));
        texture.put(17, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_blue.png"));
        texture.put(18, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_brown.png"));
        texture.put(19, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_cyan.png"));
        texture.put(20, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_gray.png"));
        texture.put(21, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_green.png"));
        texture.put(22, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_light_blue.png"));
        texture.put(23, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_light_gray.png"));
        texture.put(24, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_lime.png"));
        texture.put(25, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_magenta.png"));
        texture.put(26, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_orange.png"));
        texture.put(27, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_pink.png"));
        texture.put(28, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_purple.png"));
        texture.put(29, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_red.png"));
        texture.put(30, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_white.png"));
        texture.put(31, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_yellow.png"));
        texture.put(32, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_diamond.png"));
        texture.put(33, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_emerald.png"));
        texture.put(34, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_gold.png"));
        texture.put(35, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_redstone.png"));
        texture.put(36, new ResourceLocation("coldsspeeders", "textures/entity/ultra/speeder_texture_eightball.png"));
        texture.put(37, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_checkered.png"));
        texture.put(38, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_mrbubs.png"));
        texture.put(39, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_sunset.png"));
        texture.put(40, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_sunrise.png"));
        texture.put(41, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_camo_green.png"));
        texture.put(42, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_camo_pink.png"));
        texture.put(43, new ResourceLocation("coldsspeeders", "textures/entity/rare/speeder_texture_rainbow.png"));
        texture.put(44, new ResourceLocation("coldsspeeders", "textures/entity/ultra/speeder_texture_slimy.png"));
        texture.put(45, new ResourceLocation("coldsspeeders", "textures/entity/ultra/speeder_texture_nyan.png"));
        texture.put(46, new ResourceLocation("coldsspeeders", "textures/entity/ultra/speeder_texture_boodlyneck.png"));
        texture.put(47, new ResourceLocation("coldsspeeders", "textures/entity/ultra/speeder_texture_coldspell.png"));
        texture.put(48, new ResourceLocation("coldsspeeders", "textures/entity/ultra/speeder_texture_phoenix.png"));
        texture.put(49, new ResourceLocation("coldsspeeders", "textures/entity/ultra/speeder_texture_pwrdown.png"));
    });
    private static final ITextComponent CONTAINER_NAME = new TranslationTextComponent("container.enderchest");

    public SpeederEntity(EntityType<? extends AbstractHorseEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.35).func_233815_a_(Attributes.field_233830_m_, 1.0);
    }

    protected float func_110267_cL() {
        return 0.0f;
    }

    protected double func_110245_cM() {
        return 0.0;
    }

    protected double func_110203_cN() {
        return 0.0;
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    public ActionResultType func_230254_b_(PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.func_213453_ef() && !this.func_184207_aI() && itemstack.func_77973_b() == Items.field_151042_j) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110138_aP() + 3.0f + (float)this.field_70146_Z.nextInt(3));
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            }
        } else if (playerIn.func_213453_ef() && !this.func_184207_aI() && itemstack.func_77973_b() instanceof BrushItem) {
            this.paintSpeeder(itemstack);
            this.func_184185_a(SoundEvents.field_187886_fs, this.func_70599_aP(), 1.0f);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        } else if (playerIn.func_213453_ef() && !this.func_184207_aI()) {
            ItemStack speeder = SpeederHelper.getSpeeder((Integer)this.field_70180_af.func_187225_a(SPEEDER_TYPE));
            CompoundNBT nbt = speeder.func_196082_o();
            nbt.func_74776_a("health", this.func_110143_aJ());
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerIn, (ItemStack)speeder);
            this.func_184185_a(SoundEvents.field_187686_e, this.func_70599_aP(), 1.0f);
            this.func_70106_y();
        }
        if (!playerIn.func_213453_ef() && !this.func_70631_g_() && this.func_184207_aI()) {
            return super.func_230254_b_(playerIn, handIn);
        }
        if (!playerIn.func_213453_ef() && this.func_70631_g_()) {
            return super.func_230254_b_(playerIn, handIn);
        }
        this.func_110237_h(playerIn);
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity baby) {
        SpeederEntity entity = new SpeederEntity((EntityType<? extends AbstractHorseEntity>)((EntityType)ModEntityTypes.SPEEDER.get()), this.field_70170_p);
        entity.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(entity.func_241205_ce_())), SpawnReason.BREEDING, null, null);
        this.func_190681_a(baby, entity);
        return entity;
    }

    private void paintSpeeder(ItemStack brush) {
        int speederType;
        int paintType = ((BrushItem)brush.func_77973_b()).getType();
        if (paintType == (speederType = this.getSpeederType())) {
            if (paintType == 0) {
                this.setSpeederType(16);
            } else if (paintType == 1) {
                this.setSpeederType(17);
            } else if (paintType == 2) {
                this.setSpeederType(18);
            } else if (paintType == 3) {
                this.setSpeederType(19);
            } else if (paintType == 4) {
                this.setSpeederType(20);
            } else if (paintType == 5) {
                this.setSpeederType(21);
            } else if (paintType == 6) {
                this.setSpeederType(22);
            } else if (paintType == 7) {
                this.setSpeederType(23);
            } else if (paintType == 8) {
                this.setSpeederType(24);
            } else if (paintType == 9) {
                this.setSpeederType(25);
            } else if (paintType == 10) {
                this.setSpeederType(26);
            } else if (paintType == 11) {
                this.setSpeederType(27);
            } else if (paintType == 12) {
                this.setSpeederType(28);
            } else if (paintType == 13) {
                this.setSpeederType(29);
            } else if (paintType == 14) {
                this.setSpeederType(30);
            } else if (paintType == 15) {
                this.setSpeederType(31);
            } else {
                this.setSpeederType(paintType);
            }
        } else {
            this.setSpeederType(paintType);
        }
    }

    public ResourceLocation getSpeederTexture() {
        return TEXTURE_BY_ID.getOrDefault(this.getSpeederType(), TEXTURE_BY_ID.get(0));
    }

    public int getSpeederType() {
        return (Integer)this.field_70180_af.func_187225_a(SPEEDER_TYPE);
    }

    public void setSpeederType(int type) {
        if (type < 0 || type >= 50) {
            type = this.field_70146_Z.nextInt(50);
        }
        this.field_70180_af.func_187227_b(SPEEDER_TYPE, (Object)type);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSpeederType(compound.func_74762_e("SpeederType"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("SpeederType", this.getSpeederType());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPEEDER_TYPE, (Object)50);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setSpeederType(this.field_70146_Z.nextInt(50));
        this.func_94061_f(true);
        this.func_230279_az_();
        return spawnDataIn;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 0;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187539_bB;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187686_e;
    }

    protected void func_190680_a(SoundType p_190680_1_) {
    }

    protected void func_205715_ee() {
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    public boolean func_82171_bF() {
        return true;
    }

    public void func_70636_d() {
        if (this.func_184207_aI() && this.func_184187_bx() != null && this.func_184187_bx() instanceof PlayerEntity) {
            this.func_184187_bx().field_70143_R = 0.0f;
        }
        this.field_70143_R = 0.0f;
        super.func_70636_d();
    }

    public boolean func_110248_bS() {
        return true;
    }

    public boolean func_110257_ck() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_190681_a(AgeableEntity baby, AbstractHorseEntity p_190681_2_) {
        this.func_94061_f(true);
        this.func_230279_az_();
    }

    protected float func_225515_ai_() {
        return super.func_225515_ai_();
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                assert (livingentity != null);
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                    this.field_110285_bP = 0;
                    this.func_189654_d(false);
                    this.func_70657_f(-0.01f);
                }
                if (f1 > 0.0f) {
                    this.func_189654_d(true);
                    this.func_70657_f(-0.01f);
                    this.func_191989_p(1.3f);
                    this.func_230245_c_(true);
                }
                if (!this.func_184207_aI()) {
                    this.func_189654_d(false);
                    this.func_70657_f(-0.01f);
                }
                if (this.field_110277_bt > 0.0f) {
                    double d0 = this.func_110215_cj() * (double)this.field_110277_bt * (double)this.func_226269_ah_();
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d0 + (double)((float)(Objects.requireNonNull(this.func_70660_b(Effects.field_76430_j)).func_76458_c() + 1) * 0.1f) : d0;
                    Vector3d vector3d = this.func_213322_ci();
                    this.func_213293_j(vector3d.field_72450_a, d1, vector3d.field_72449_c);
                    this.field_70160_al = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * f2 * this.field_110277_bt), 0.0, (double)(0.4f * f3 * this.field_110277_bt)));
                    }
                    this.field_110277_bt = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_));
                    super.func_213352_e(new Vector3d((double)f, travelVector.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(travelVector);
            }
        }
    }

    public void func_110199_f(PlayerEntity playerEntity) {
        EnderChestInventory enderchestinventory = playerEntity.func_71005_bN();
        TileEntity tileentity = this.field_70170_p.func_175625_s(this.func_233580_cy_());
        if (!this.field_70170_p.field_72995_K && (this.func_184207_aI() || this.func_184196_w((Entity)playerEntity)) && this.func_110248_bS()) {
            EnderChestTileEntity enderchesttileentity = (EnderChestTileEntity)tileentity;
            enderchestinventory.func_146031_a(enderchesttileentity);
            playerEntity.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, inventory, playerIn) -> ChestContainer.func_216992_a((int)id, (PlayerInventory)inventory, (IInventory)enderchestinventory), CONTAINER_NAME));
            playerEntity.func_195066_a(Stats.field_188090_X);
        }
    }

    protected void func_205714_dM() {
        super.func_205714_dM();
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof MobEntity && !(entityIn instanceof SpeederEntity) && this.func_184207_aI()) {
            entityIn.func_70097_a(new DamageSource("speeder_collide"), 8.0f + (float)this.field_70146_Z.nextInt(9));
        }
    }
}

