/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.block;

import com.robotgryphon.compactmachines.CompactMachines;
import com.robotgryphon.compactmachines.api.tunnels.ITunnelConnectionInfo;
import com.robotgryphon.compactmachines.api.tunnels.redstone.IRedstoneReaderTunnel;
import com.robotgryphon.compactmachines.block.tiles.CompactMachineTile;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import com.robotgryphon.compactmachines.compat.theoneprobe.IProbeData;
import com.robotgryphon.compactmachines.compat.theoneprobe.IProbeDataProvider;
import com.robotgryphon.compactmachines.compat.theoneprobe.providers.CompactMachineProvider;
import com.robotgryphon.compactmachines.config.ServerConfig;
import com.robotgryphon.compactmachines.core.EnumMachinePlayersBreakHandling;
import com.robotgryphon.compactmachines.core.Registration;
import com.robotgryphon.compactmachines.reference.EnumMachineSize;
import com.robotgryphon.compactmachines.tunnels.TunnelHelper;
import com.robotgryphon.compactmachines.util.CompactMachineUtil;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockCompactMachine
extends Block
implements IProbeDataProvider {
    private final EnumMachineSize size;

    public BlockCompactMachine(EnumMachineSize size, AbstractBlock.Properties props) {
        super(props);
        this.size = size;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        CompactMachineTile tile = (CompactMachineTile)worldIn.func_175625_s(pos);
        float normalHardness = super.func_180647_a(state, player, worldIn, pos);
        if (tile == null) {
            return normalHardness;
        }
        boolean hasPlayers = tile.hasPlayersInside();
        if (hasPlayers) {
            EnumMachinePlayersBreakHandling hand = (EnumMachinePlayersBreakHandling)((Object)ServerConfig.MACHINE_PLAYER_BREAK_HANDLING.get());
            switch (hand) {
                case UNBREAKABLE: {
                    return 0.0f;
                }
                case OWNER: {
                    Optional<UUID> ownerUUID = tile.getOwnerUUID();
                    return ownerUUID.map(uuid -> Float.valueOf(player.func_110124_au() == uuid ? normalHardness : 0.0f)).orElse(Float.valueOf(normalHardness)).floatValue();
                }
                case ANYONE: {
                    return normalHardness;
                }
            }
        }
        return normalHardness;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return false;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block changedBlock, BlockPos changedPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, changedBlock, changedPos, isMoving);
        if (world.field_72995_K) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        BlockState changedState = serverWorld.func_180495_p(changedPos);
        CompactMachineTile machine = (CompactMachineTile)serverWorld.func_175625_s(pos);
        if (machine == null) {
            return;
        }
        ServerWorld compactWorld = serverWorld.func_73046_m().func_71218_a(Registration.COMPACT_DIMENSION);
        if (compactWorld == null) {
            CompactMachines.LOGGER.warn("Warning: Compact Dimension was null! Cannot fetch internal state for machine neighbor change listener.");
            return;
        }
        Arrays.stream(Direction.values()).filter(hd -> pos.func_177972_a(hd).equals((Object)changedPos)).findFirst().ifPresent(facing -> {
            Set<BlockPos> tunnelsForMachineSide = TunnelHelper.getTunnelsForMachineSide(machine.machineId, serverWorld, facing);
            for (BlockPos tunnelPos : tunnelsForMachineSide) {
                TunnelWallTile tunnelTile = (TunnelWallTile)compactWorld.func_175625_s(tunnelPos);
                if (tunnelTile == null) continue;
                compactWorld.func_195593_d(tunnelPos, (Block)Registration.BLOCK_TUNNEL_WALL.get());
                ITunnelConnectionInfo connInfo = TunnelHelper.generateConnectionInfo(tunnelTile);
                tunnelTile.getTunnelDefinition().ifPresent(tunnelDefinition -> {
                    if (tunnelDefinition instanceof IRedstoneReaderTunnel) {
                        IRedstoneReaderTunnel rrt = (IRedstoneReaderTunnel)((Object)tunnelDefinition);
                        int latestPower = world.func_175651_c(changedPos, facing);
                        rrt.onPowerChanged(connInfo, latestPower);
                    }
                });
            }
        });
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        Block given = CompactMachineUtil.getMachineBlockBySize(this.size);
        ItemStack stack = new ItemStack((IItemProvider)given, 1);
        CompoundNBT nbt = stack.func_190925_c("cm");
        nbt.func_74778_a("size", this.size.getName());
        CompactMachineTile tileEntity = (CompactMachineTile)world.func_175625_s(pos);
        if (tileEntity != null) {
            nbt.func_74768_a("coords", tileEntity.machineId);
        }
        return stack;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CompactMachineTile();
    }

    public void func_176206_d(IWorld world, BlockPos pos, BlockState state) {
        if (world.func_201670_d()) {
            super.func_176206_d(world, pos, state);
            return;
        }
        if (!(world.func_175625_s(pos) instanceof CompactMachineTile)) {
            return;
        }
        CompactMachineTile te = (CompactMachineTile)world.func_175625_s(pos);
        super.func_176206_d(world, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CompoundNBT machineData;
        if (worldIn.func_201670_d()) {
            return;
        }
        ServerWorld serverWorld = (ServerWorld)worldIn;
        boolean hasProperTile = worldIn.func_175625_s(pos) instanceof CompactMachineTile;
        if (!hasProperTile) {
            return;
        }
        CompactMachineTile tile = (CompactMachineTile)worldIn.func_175625_s(pos);
        if (tile.machineId != -1) {
            return;
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("owner")) {
            tile.setOwner(nbt.func_186857_a("owner"));
        }
        if (!tile.getOwnerUUID().isPresent() && placer instanceof PlayerEntity) {
            tile.setOwner(placer.func_110124_au());
        }
        if (nbt.func_74764_b("cm") && (machineData = nbt.func_74775_l("cm")).func_74764_b("coords")) {
            int machineID = machineData.func_74762_e("coords");
            tile.setMachineId(machineID);
            CompactMachineUtil.updateMachineInWorldPosition(serverWorld, machineID, pos);
        }
        tile.doPostPlaced();
        tile.func_70296_d();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            TileEntity te = worldIn.func_175625_s(pos);
            CompactMachineTile tile = (CompactMachineTile)te;
            ItemStack mainItem = player.func_184614_ca();
            if (mainItem.func_190926_b()) {
                return ActionResultType.PASS;
            }
            if (mainItem.func_77973_b() == Registration.PERSONAL_SHRINKING_DEVICE.get()) {
                CompactMachineUtil.teleportInto(serverPlayer, pos, this.size);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public EnumMachineSize getSize() {
        return this.size;
    }

    @Override
    public void addProbeData(IProbeData data, PlayerEntity player, World world, BlockState state) {
        CompactMachineProvider.exec(data, player, world, state);
    }
}

