/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.block.walls;

import com.robotgryphon.compactmachines.api.tunnels.ITunnelConnectionInfo;
import com.robotgryphon.compactmachines.api.tunnels.TunnelDefinition;
import com.robotgryphon.compactmachines.api.tunnels.redstone.IRedstoneReaderTunnel;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import com.robotgryphon.compactmachines.block.walls.ProtectedWallBlock;
import com.robotgryphon.compactmachines.compat.theoneprobe.IProbeData;
import com.robotgryphon.compactmachines.compat.theoneprobe.IProbeDataProvider;
import com.robotgryphon.compactmachines.compat.theoneprobe.providers.TunnelProvider;
import com.robotgryphon.compactmachines.core.Registration;
import com.robotgryphon.compactmachines.tunnels.TunnelHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TunnelWallBlock
extends ProtectedWallBlock
implements IProbeDataProvider {
    public static DirectionProperty TUNNEL_SIDE = DirectionProperty.func_196962_a((String)"tunnel_side", (Direction[])Direction.values());
    public static DirectionProperty CONNECTED_SIDE = DirectionProperty.func_196962_a((String)"connected_side", (Direction[])Direction.values());
    public static BooleanProperty REDSTONE = BooleanProperty.func_177716_a((String)"redstone");

    public TunnelWallBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)CONNECTED_SIDE, (Comparable)Direction.UP)).func_206870_a((Property)TUNNEL_SIDE, (Comparable)Direction.UP)).func_206870_a((Property)REDSTONE, (Comparable)Boolean.valueOf(false)));
    }

    public Optional<TunnelDefinition> getTunnelInfo(IBlockReader world, BlockPos pos) {
        TunnelWallTile tile = (TunnelWallTile)world.func_175625_s(pos);
        if (tile == null) {
            return Optional.empty();
        }
        return tile.getTunnelDefinition();
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        Optional<TunnelDefinition> tunnelInfo = this.getTunnelInfo(world, pos);
        if (!tunnelInfo.isPresent()) {
            return false;
        }
        TunnelDefinition definition = tunnelInfo.get();
        if (definition instanceof IRedstoneReaderTunnel) {
            ITunnelConnectionInfo conn = TunnelHelper.generateConnectionInfo(world, pos);
            return ((IRedstoneReaderTunnel)((Object)definition)).canConnectRedstone(conn);
        }
        return false;
    }

    public boolean func_149744_f(BlockState state) {
        return (Boolean)state.func_177229_b((Property)REDSTONE);
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return 0;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        Optional<TunnelDefinition> tunnelInfo = this.getTunnelInfo(world, pos);
        if (!tunnelInfo.isPresent()) {
            return 0;
        }
        TunnelDefinition definition = tunnelInfo.get();
        if (definition instanceof IRedstoneReaderTunnel) {
            ITunnelConnectionInfo conn = TunnelHelper.generateConnectionInfo(world, pos);
            int weak = ((IRedstoneReaderTunnel)((Object)definition)).getPowerLevel(conn);
            return weak;
        }
        return 0;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_()) {
            Optional<TunnelDefinition> tunnelDef = this.getTunnelInfo((IBlockReader)worldIn, pos);
            if (!tunnelDef.isPresent()) {
                return ActionResultType.FAIL;
            }
            BlockState solidWall = ((Block)Registration.BLOCK_SOLID_WALL.get()).func_176223_P();
            worldIn.func_175656_a(pos, solidWall);
            TunnelDefinition tunnelRegistration = tunnelDef.get();
            ItemStack stack = new ItemStack((IItemProvider)Registration.ITEM_TUNNEL.get(), 1);
            CompoundNBT defTag = stack.func_190925_c("definition");
            defTag.func_74778_a("id", tunnelRegistration.getRegistryName().toString());
            ItemEntity ie = new ItemEntity(worldIn, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
            worldIn.func_217376_c((Entity)ie);
        } else {
            Direction dir = (Direction)state.func_177229_b((Property)CONNECTED_SIDE);
            Direction nextDir = TunnelHelper.getNextDirection(dir);
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)CONNECTED_SIDE, (Comparable)nextDir));
        }
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TUNNEL_SIDE}).func_206894_a(new Property[]{CONNECTED_SIDE}).func_206894_a(new Property[]{REDSTONE});
        super.func_206840_a(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TunnelWallTile();
    }

    @Override
    public void addProbeData(IProbeData data, PlayerEntity player, World world, BlockState state) {
        TunnelProvider.exec(data, player, world, state);
    }
}

