/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.compat.theoneprobe.providers;

import com.robotgryphon.compactmachines.api.tunnels.EnumTunnelSide;
import com.robotgryphon.compactmachines.api.tunnels.TunnelDefinition;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import com.robotgryphon.compactmachines.block.walls.TunnelWallBlock;
import com.robotgryphon.compactmachines.compat.theoneprobe.IProbeData;
import com.robotgryphon.compactmachines.core.Registration;
import com.robotgryphon.compactmachines.teleportation.DimensionalPosition;
import com.robotgryphon.compactmachines.tunnels.TunnelHelper;
import java.util.Optional;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TunnelProvider {
    public static void exec(IProbeData data, PlayerEntity player, World world, BlockState state) {
        ProbeMode mode = data.getMode();
        IProbeInfo info = data.getInfo();
        IProbeHitData hitData = data.getHitData();
        TunnelProvider.addProbeInfo(mode, info, player, world, state, hitData);
    }

    private static void addProbeInfo(ProbeMode probeMode, IProbeInfo info, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData hitData) {
        Direction side = (Direction)blockState.func_177229_b((Property)TunnelWallBlock.CONNECTED_SIDE);
        ILayoutStyle center = info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
        IProbeInfo v = info.vertical(info.defaultLayoutStyle().spacing(-1));
        TunnelWallTile tile = (TunnelWallTile)world.func_175625_s(hitData.getPos());
        if (tile == null) {
            return;
        }
        Optional<DimensionalPosition> outside = TunnelHelper.getTunnelConnectedPosition(tile, EnumTunnelSide.OUTSIDE);
        Optional<BlockState> connected = TunnelHelper.getConnectedState(tile, EnumTunnelSide.OUTSIDE);
        if (probeMode == ProbeMode.EXTENDED) {
            Optional<TunnelDefinition> definition = tile.getTunnelDefinition();
            if (definition.isPresent()) {
                IFormattableTextComponent tunType = new StringTextComponent(definition.get().getRegistryName().toString()).func_240699_a_(TextFormatting.GRAY);
                CompoundText type = CompoundText.create().name((ITextComponent)tunType);
                v.horizontal(center).item(new ItemStack((IItemProvider)Registration.ITEM_TUNNEL.get())).text(type);
            } else {
                ResourceLocation defID = tile.getTunnelDefinitionId().orElse(new ResourceLocation("compactmachines", "unknown"));
                IFormattableTextComponent tunType = new TranslationTextComponent("compactmachines.errors.unknown_tunnel_type", new Object[]{defID}).func_240699_a_(TextFormatting.GRAY);
                CompoundText type = CompoundText.create().name((ITextComponent)tunType);
                v.horizontal(center).item(new ItemStack((IItemProvider)Registration.ITEM_TUNNEL.get())).text(type);
            }
        }
        String sideTranslated = "{*".concat("compactmachines.direction.").concat(side.func_176742_j()).concat("*}");
        v.horizontal(center).item(new ItemStack((IItemProvider)Items.field_151111_aL)).text((ITextComponent)new TranslationTextComponent("compactmachines.direction.side", new Object[]{sideTranslated}));
        connected.ifPresent(state -> {
            if (!outside.isPresent()) {
                return;
            }
            DimensionalPosition outPos = (DimensionalPosition)outside.get();
            ServerWorld connectedWorld = (ServerWorld)world;
            BlockPos outPosBlock = outPos.getBlockPosition();
            try {
                if (!state.isAir((IBlockReader)connectedWorld, outPosBlock)) {
                    String blockName = "{*" + state.func_177230_c().func_149739_a() + "*}";
                    BlockRayTraceResult trace = new BlockRayTraceResult(hitData.getHitVec(), hitData.getSideHit(), outPosBlock, false);
                    ItemStack pick = state.func_177230_c().getPickBlock(state, (RayTraceResult)trace, (IBlockReader)connectedWorld, outPosBlock, playerEntity);
                    v.horizontal(center).item(pick).text((ITextComponent)new TranslationTextComponent("compactmachines".concat(".connected_block"), new Object[]{blockName}));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

