/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.core;

import com.robotgryphon.compactmachines.CompactMachines;
import com.robotgryphon.compactmachines.api.tunnels.TunnelDefinition;
import com.robotgryphon.compactmachines.block.BlockCompactMachine;
import com.robotgryphon.compactmachines.block.tiles.CompactMachineTile;
import com.robotgryphon.compactmachines.block.tiles.TunnelWallTile;
import com.robotgryphon.compactmachines.block.walls.BreakableWallBlock;
import com.robotgryphon.compactmachines.block.walls.SolidWallBlock;
import com.robotgryphon.compactmachines.block.walls.TunnelWallBlock;
import com.robotgryphon.compactmachines.item.ItemBlockMachine;
import com.robotgryphon.compactmachines.item.ItemBlockWall;
import com.robotgryphon.compactmachines.item.ItemPersonalShrinkingDevice;
import com.robotgryphon.compactmachines.item.TunnelItem;
import com.robotgryphon.compactmachines.reference.EnumMachineSize;
import com.robotgryphon.compactmachines.tunnels.definitions.ItemTunnelDefinition;
import com.robotgryphon.compactmachines.tunnels.definitions.RedstoneInTunnelDefinition;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="compactmachines")
public class Registration {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"compactmachines");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"compactmachines");
    private static final DeferredRegister<TileEntityType<?>> TILES_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"compactmachines");
    public static final DeferredRegister<TunnelDefinition> TUNNEL_DEFINITIONS = DeferredRegister.create(TunnelDefinition.class, (String)"compactmachines");
    private static AbstractBlock.Properties MACHINE_BLOCK_PROPS;
    private static Supplier<Item.Properties> BASIC_ITEM_PROPS;
    public static final RegistryObject<Block> MACHINE_BLOCK_TINY;
    public static final RegistryObject<Block> MACHINE_BLOCK_SMALL;
    public static final RegistryObject<Block> MACHINE_BLOCK_NORMAL;
    public static final RegistryObject<Block> MACHINE_BLOCK_LARGE;
    public static final RegistryObject<Block> MACHINE_BLOCK_GIANT;
    public static final RegistryObject<Block> MACHINE_BLOCK_MAXIMUM;
    public static final RegistryObject<Item> MACHINE_BLOCK_ITEM_TINY;
    public static final RegistryObject<Item> MACHINE_BLOCK_ITEM_SMALL;
    public static final RegistryObject<Item> MACHINE_BLOCK_ITEM_NORMAL;
    public static final RegistryObject<Item> MACHINE_BLOCK_ITEM_LARGE;
    public static final RegistryObject<Item> MACHINE_BLOCK_ITEM_GIANT;
    public static final RegistryObject<Item> MACHINE_BLOCK_ITEM_MAXIMUM;
    public static final RegistryObject<TileEntityType<CompactMachineTile>> MACHINE_TILE_ENTITY;
    public static final RegistryObject<Block> BLOCK_TUNNEL_WALL;
    public static final RegistryObject<Block> BLOCK_SOLID_WALL;
    public static final RegistryObject<Block> BLOCK_BREAKABLE_WALL;
    public static final RegistryObject<ItemPersonalShrinkingDevice> PERSONAL_SHRINKING_DEVICE;
    public static final RegistryObject<Item> ITEM_SOLID_WALL;
    public static final RegistryObject<Item> ITEM_BREAKABLE_WALL;
    public static final RegistryObject<Item> ITEM_TUNNEL;
    public static final RegistryObject<TileEntityType<TunnelWallTile>> TUNNEL_WALL_TILE;
    public static final RegistryObject<TunnelDefinition> ITEM_TUNNEL_DEF;
    public static final RegistryObject<TunnelDefinition> REDSTONE_IN_TUNNEL;
    public static final RegistryKey<World> COMPACT_DIMENSION;

    public static void init() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        TILES_ENTITIES.register(eventBus);
        TUNNEL_DEFINITIONS.register(eventBus);
    }

    static {
        TUNNEL_DEFINITIONS.makeRegistry("tunnel_types", () -> new RegistryBuilder().setType(TunnelDefinition.class).tagFolder("tunnel_types"));
        MACHINE_BLOCK_PROPS = AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(8.0f, 20.0f).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_235861_h_();
        BASIC_ITEM_PROPS = () -> new Item.Properties().func_200916_a(CompactMachines.COMPACT_MACHINES_ITEMS);
        MACHINE_BLOCK_TINY = BLOCKS.register("machine_tiny", () -> new BlockCompactMachine(EnumMachineSize.TINY, MACHINE_BLOCK_PROPS));
        MACHINE_BLOCK_SMALL = BLOCKS.register("machine_small", () -> new BlockCompactMachine(EnumMachineSize.SMALL, MACHINE_BLOCK_PROPS));
        MACHINE_BLOCK_NORMAL = BLOCKS.register("machine_normal", () -> new BlockCompactMachine(EnumMachineSize.NORMAL, MACHINE_BLOCK_PROPS));
        MACHINE_BLOCK_LARGE = BLOCKS.register("machine_large", () -> new BlockCompactMachine(EnumMachineSize.LARGE, MACHINE_BLOCK_PROPS));
        MACHINE_BLOCK_GIANT = BLOCKS.register("machine_giant", () -> new BlockCompactMachine(EnumMachineSize.GIANT, MACHINE_BLOCK_PROPS));
        MACHINE_BLOCK_MAXIMUM = BLOCKS.register("machine_maximum", () -> new BlockCompactMachine(EnumMachineSize.MAXIMUM, MACHINE_BLOCK_PROPS));
        MACHINE_BLOCK_ITEM_TINY = ITEMS.register("machine_tiny", () -> new ItemBlockMachine((Block)MACHINE_BLOCK_TINY.get(), EnumMachineSize.TINY, BASIC_ITEM_PROPS.get()));
        MACHINE_BLOCK_ITEM_SMALL = ITEMS.register("machine_small", () -> new ItemBlockMachine((Block)MACHINE_BLOCK_SMALL.get(), EnumMachineSize.SMALL, BASIC_ITEM_PROPS.get()));
        MACHINE_BLOCK_ITEM_NORMAL = ITEMS.register("machine_normal", () -> new ItemBlockMachine((Block)MACHINE_BLOCK_NORMAL.get(), EnumMachineSize.NORMAL, BASIC_ITEM_PROPS.get()));
        MACHINE_BLOCK_ITEM_LARGE = ITEMS.register("machine_large", () -> new ItemBlockMachine((Block)MACHINE_BLOCK_LARGE.get(), EnumMachineSize.LARGE, BASIC_ITEM_PROPS.get()));
        MACHINE_BLOCK_ITEM_GIANT = ITEMS.register("machine_giant", () -> new ItemBlockMachine((Block)MACHINE_BLOCK_GIANT.get(), EnumMachineSize.GIANT, BASIC_ITEM_PROPS.get()));
        MACHINE_BLOCK_ITEM_MAXIMUM = ITEMS.register("machine_maximum", () -> new ItemBlockMachine((Block)MACHINE_BLOCK_MAXIMUM.get(), EnumMachineSize.MAXIMUM, BASIC_ITEM_PROPS.get()));
        MACHINE_TILE_ENTITY = TILES_ENTITIES.register("compact_machine", () -> TileEntityType.Builder.func_223042_a(CompactMachineTile::new, (Block[])new Block[]{(Block)MACHINE_BLOCK_TINY.get(), (Block)MACHINE_BLOCK_SMALL.get(), (Block)MACHINE_BLOCK_NORMAL.get(), (Block)MACHINE_BLOCK_LARGE.get(), (Block)MACHINE_BLOCK_GIANT.get(), (Block)MACHINE_BLOCK_MAXIMUM.get()}).func_206865_a(null));
        BLOCK_TUNNEL_WALL = BLOCKS.register("tunnel_wall", () -> new TunnelWallBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151667_k).func_200948_a(-1.0f, 3600000.8f).func_200947_a(SoundType.field_185852_e).func_235838_a_(state -> 15).func_222380_e()));
        BLOCK_SOLID_WALL = BLOCKS.register("solid_wall", () -> new SolidWallBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151667_k).func_200948_a(-1.0f, 3600000.8f).func_200947_a(SoundType.field_185852_e).func_235838_a_(state -> 15).func_222380_e()));
        BLOCK_BREAKABLE_WALL = BLOCKS.register("wall", () -> new BreakableWallBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 128.0f).func_235861_h_().harvestTool(ToolType.PICKAXE).harvestLevel(1)));
        PERSONAL_SHRINKING_DEVICE = ITEMS.register("personal_shrinking_device", () -> new ItemPersonalShrinkingDevice(BASIC_ITEM_PROPS.get().func_200917_a(1)));
        ITEM_SOLID_WALL = ITEMS.register("solid_wall", () -> new ItemBlockWall((Block)BLOCK_SOLID_WALL.get(), BASIC_ITEM_PROPS.get()));
        ITEM_BREAKABLE_WALL = ITEMS.register("wall", () -> new ItemBlockWall((Block)BLOCK_BREAKABLE_WALL.get(), BASIC_ITEM_PROPS.get()));
        ITEM_TUNNEL = ITEMS.register("tunnel", () -> new TunnelItem(BASIC_ITEM_PROPS.get()));
        TUNNEL_WALL_TILE = TILES_ENTITIES.register("tunnel_wall", () -> TileEntityType.Builder.func_223042_a(TunnelWallTile::new, (Block[])new Block[]{(Block)BLOCK_TUNNEL_WALL.get()}).func_206865_a(null));
        ITEM_TUNNEL_DEF = TUNNEL_DEFINITIONS.register("item", ItemTunnelDefinition::new);
        REDSTONE_IN_TUNNEL = TUNNEL_DEFINITIONS.register("redstone_in", RedstoneInTunnelDefinition::new);
        COMPACT_DIMENSION = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("compactmachines:compact_world"));
    }
}

