/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.data;

import com.robotgryphon.compactmachines.data.NbtListCollector;
import com.robotgryphon.compactmachines.data.machines.CompactMachinePlayerData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class CompactMachineCommonData {
    protected Map<Integer, CompactMachinePlayerData> playerData = new HashMap<Integer, CompactMachinePlayerData>();
    private static CompactMachineCommonData INSTANCE = new CompactMachineCommonData();

    protected CompactMachineCommonData() {
    }

    public static CompactMachineCommonData getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CompactMachineCommonData();
        }
        return INSTANCE;
    }

    public static CompoundNBT serializePlayerData(CompactMachineCommonData shared, CompoundNBT nbt) {
        ListNBT playerList = shared.playerData.values().stream().filter(CompactMachinePlayerData::hasPlayers).map(CompactMachinePlayerData::serializeNBT).collect(NbtListCollector.toNbtList());
        if (!playerList.isEmpty()) {
            nbt.func_218657_a("players", (INBT)playerList);
        }
        return nbt;
    }

    public CompoundNBT serializeNBT(CompoundNBT compound) {
        compound = CompactMachineCommonData.serializePlayerData(this, compound);
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.deserializePlayerData(nbt);
    }

    public void deserializePlayerData(CompoundNBT nbt) {
        if (nbt.func_74764_b("players")) {
            ListNBT players = nbt.func_150295_c("players", 10);
            players.forEach(data -> {
                CompactMachinePlayerData pmd = CompactMachinePlayerData.fromNBT(data);
                this.playerData.put(pmd.getId(), pmd);
            });
        }
    }

    public void updatePlayerData(CompactMachinePlayerData pd) {
        int id = pd.getId();
        if (!this.playerData.containsKey(id)) {
            this.playerData.put(id, pd);
            return;
        }
        this.playerData.replace(id, pd);
    }

    public Optional<CompactMachinePlayerData> getPlayerData(int id) {
        if (!this.playerData.containsKey(id)) {
            this.playerData.put(id, new CompactMachinePlayerData(id));
        }
        return Optional.ofNullable(this.playerData.get(id));
    }
}

