/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.data;

import com.robotgryphon.compactmachines.CompactMachines;
import com.robotgryphon.compactmachines.core.Registration;
import com.robotgryphon.compactmachines.data.CompactMachineServerData;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class SavedMachineData
extends WorldSavedData {
    public static final String DATA_NAME = "compactmachines_machines";
    private static CompactMachineServerData DATA;

    public SavedMachineData() {
        super(DATA_NAME);
    }

    @Nonnull
    public static SavedMachineData getInstance(MinecraftServer server) {
        ServerWorld compactWorld = server.func_71218_a(Registration.COMPACT_DIMENSION);
        if (compactWorld == null) {
            CompactMachines.LOGGER.error("No compact dimension found. Falling back to overworld.");
            return (SavedMachineData)server.func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(SavedMachineData::new, DATA_NAME);
        }
        DimensionSavedDataManager sd = compactWorld.func_217481_x();
        return (SavedMachineData)sd.func_215752_a(SavedMachineData::new, DATA_NAME);
    }

    public void func_76184_a(CompoundNBT nbt) {
        DATA = CompactMachineServerData.fromNbt(nbt);
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        if (DATA != null) {
            return DATA.serializeNBT(compound);
        }
        return compound;
    }

    public CompactMachineServerData getData() {
        if (DATA == null) {
            DATA = new CompactMachineServerData();
        }
        return DATA;
    }
}

