/*
 * Decompiled with CFR 0.152.
 */
package com.robotgryphon.compactmachines.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.robotgryphon.compactmachines.core.Registration;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class BlockLootGenerator
extends LootTableProvider {
    public BlockLootGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootParameterSets.field_216267_h));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)name, (LootTable)table));
    }

    private static class Blocks
    extends BlockLootTables {
        private ILootFunction.IBuilder CopyOwnerAndReferenceFunction = CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("owner", "owner").func_216056_a("coords", "cm.coords");

        private Blocks() {
        }

        protected void addTables() {
            this.registerSelfDroppedBlock(Registration.BLOCK_BREAKABLE_WALL, Registration.ITEM_BREAKABLE_WALL);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_TINY, Registration.MACHINE_BLOCK_ITEM_TINY);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_SMALL, Registration.MACHINE_BLOCK_ITEM_SMALL);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_NORMAL, Registration.MACHINE_BLOCK_ITEM_NORMAL);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_LARGE, Registration.MACHINE_BLOCK_ITEM_LARGE);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_GIANT, Registration.MACHINE_BLOCK_ITEM_GIANT);
            this.registerCompactMachineBlockDrops(Registration.MACHINE_BLOCK_MAXIMUM, Registration.MACHINE_BLOCK_ITEM_MAXIMUM);
        }

        private LootPool.Builder registerSelfDroppedBlock(RegistryObject<Block> block, RegistryObject<Item> item) {
            LootPool.Builder builder = LootPool.func_216096_a().name(((Block)block.get()).getRegistryName().toString()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(SurvivesExplosion.func_215968_b()).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)item.get())));
            this.func_218507_a((Block)block.get(), LootTable.func_216119_b().func_216040_a(builder));
            return builder;
        }

        private LootPool.Builder registerCompactMachineBlockDrops(RegistryObject<Block> block, RegistryObject<Item> item) {
            LootPool.Builder builder = LootPool.func_216096_a().name(((Block)block.get()).getRegistryName().toString()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(SurvivesExplosion.func_215968_b()).func_212841_b_(this.CopyOwnerAndReferenceFunction).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)item.get())));
            this.func_218507_a((Block)block.get(), LootTable.func_216119_b().func_216040_a(builder));
            return builder;
        }

        protected Iterable<Block> getKnownBlocks() {
            return ImmutableList.of((Object)Registration.BLOCK_BREAKABLE_WALL.get(), (Object)Registration.MACHINE_BLOCK_TINY.get(), (Object)Registration.MACHINE_BLOCK_SMALL.get(), (Object)Registration.MACHINE_BLOCK_NORMAL.get(), (Object)Registration.MACHINE_BLOCK_LARGE.get(), (Object)Registration.MACHINE_BLOCK_GIANT.get(), (Object)Registration.MACHINE_BLOCK_MAXIMUM.get());
        }
    }
}

